/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class PicoExceptionsTestCase
extends TestCase {
    public static final String MESSAGE = "Message of the exception";
    public static final Throwable THROWABLE = new Throwable();
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$picocontainer$PicoInitializationException;
    static /* synthetic */ Class class$org$picocontainer$PicoInstantiationException;
    static /* synthetic */ Class class$org$picocontainer$PicoIntrospectionException;
    static /* synthetic */ Class class$org$picocontainer$PicoRegistrationException;

    final void executeTestOfStandardException(Class clazz) {
        List list;
        Iterator iter;
        HashSet set;
        Exception exception;
        ConstructorInjectionComponentAdapter componentAdapter = new ConstructorInjectionComponentAdapter((Object)clazz, clazz, null, true);
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponentInstance((Object)MESSAGE);
        try {
            exception = (Exception)componentAdapter.getComponentInstance((PicoContainer)pico);
            PicoExceptionsTestCase.assertEquals((String)MESSAGE, (String)exception.getMessage());
        }
        catch (UnsatisfiableDependenciesException ex) {
            set = new HashSet();
            iter = ex.getUnsatisfiableDependencies().iterator();
            while (iter.hasNext()) {
                list = (List)iter.next();
                set.addAll(list);
            }
            PicoExceptionsTestCase.assertTrue((boolean)set.contains(class$java$lang$Throwable == null ? (class$java$lang$Throwable = PicoExceptionsTestCase.class$("java.lang.Throwable")) : class$java$lang$Throwable));
        }
        pico = new DefaultPicoContainer();
        pico.registerComponentInstance((Object)THROWABLE);
        try {
            exception = (PicoException)componentAdapter.getComponentInstance((PicoContainer)pico);
            PicoExceptionsTestCase.assertSame((Object)THROWABLE, (Object)exception.getCause());
        }
        catch (UnsatisfiableDependenciesException ex) {
            set = new HashSet();
            iter = ex.getUnsatisfiableDependencies().iterator();
            while (iter.hasNext()) {
                list = (List)iter.next();
                set.addAll(list);
            }
            PicoExceptionsTestCase.assertTrue((boolean)set.contains(class$java$lang$String == null ? (class$java$lang$String = PicoExceptionsTestCase.class$("java.lang.String")) : class$java$lang$String));
        }
        pico.registerComponentInstance((Object)MESSAGE);
        exception = (PicoException)componentAdapter.getComponentInstance((PicoContainer)pico);
        PicoExceptionsTestCase.assertEquals((String)MESSAGE, (String)exception.getMessage());
        PicoExceptionsTestCase.assertSame((Object)THROWABLE, (Object)exception.getCause());
    }

    public void testPicoInitializationException() {
        this.executeTestOfStandardException(class$org$picocontainer$PicoInitializationException == null ? (class$org$picocontainer$PicoInitializationException = PicoExceptionsTestCase.class$("org.picocontainer.PicoInitializationException")) : class$org$picocontainer$PicoInitializationException);
    }

    public void testPicoInstantiationException() {
        this.executeTestOfStandardException(class$org$picocontainer$PicoInstantiationException == null ? (class$org$picocontainer$PicoInstantiationException = PicoExceptionsTestCase.class$("org.picocontainer.PicoInstantiationException")) : class$org$picocontainer$PicoInstantiationException);
    }

    public void testPicoIntrospectionException() {
        this.executeTestOfStandardException(class$org$picocontainer$PicoIntrospectionException == null ? (class$org$picocontainer$PicoIntrospectionException = PicoExceptionsTestCase.class$("org.picocontainer.PicoIntrospectionException")) : class$org$picocontainer$PicoIntrospectionException);
    }

    public void testPicoRegistrationException() {
        this.executeTestOfStandardException(class$org$picocontainer$PicoRegistrationException == null ? (class$org$picocontainer$PicoRegistrationException = PicoExceptionsTestCase.class$("org.picocontainer.PicoRegistrationException")) : class$org$picocontainer$PicoRegistrationException);
    }

    public void testCyclicDependencyException() {
        CyclicDependencyException cdEx = new CyclicDependencyException(((Object)((Object)this)).getClass());
        cdEx.push(class$java$lang$String == null ? (class$java$lang$String = PicoExceptionsTestCase.class$("java.lang.String")) : class$java$lang$String);
        Class[] classes = cdEx.getDependencies();
        PicoExceptionsTestCase.assertEquals((int)2, (int)classes.length);
        PicoExceptionsTestCase.assertSame(((Object)((Object)this)).getClass(), (Object)classes[0]);
        PicoExceptionsTestCase.assertSame((Object)(class$java$lang$String == null ? (class$java$lang$String = PicoExceptionsTestCase.class$("java.lang.String")) : class$java$lang$String), (Object)classes[1]);
        PicoExceptionsTestCase.assertTrue((cdEx.getMessage().indexOf(((Object)((Object)this)).getClass().getName()) >= 0 ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

