/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import junit.framework.TestCase;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoInstantiationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.testmodel.SimpleTouchable;
import org.picocontainer.testmodel.Touchable;

public class ParameterTestCase
extends TestCase {
    static /* synthetic */ Class class$org$picocontainer$testmodel$Touchable;
    static /* synthetic */ Class class$org$picocontainer$testmodel$SimpleTouchable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$picocontainer$testmodel$DependsOnTouchable;
    static /* synthetic */ Class class$junit$framework$TestCase;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;

    public void testComponentParameterFetches() throws PicoInstantiationException, PicoRegistrationException, PicoInitializationException {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        ComponentAdapter adapter = pico.registerComponentImplementation((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = ParameterTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable), class$org$picocontainer$testmodel$SimpleTouchable == null ? (class$org$picocontainer$testmodel$SimpleTouchable = ParameterTestCase.class$("org.picocontainer.testmodel.SimpleTouchable")) : class$org$picocontainer$testmodel$SimpleTouchable);
        ComponentParameter parameter = new ComponentParameter();
        ParameterTestCase.assertNotNull((Object)pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = ParameterTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable)));
        Touchable touchable = (Touchable)parameter.resolveInstance((PicoContainer)pico, adapter, class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = ParameterTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable);
        ParameterTestCase.assertNotNull((Object)touchable);
    }

    public void testConstantParameter() throws PicoInitializationException, AssignabilityRegistrationException, NotConcreteRegistrationException, PicoIntrospectionException {
        Object value = new Object();
        ConstantParameter parameter = new ConstantParameter(value);
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        ParameterTestCase.assertSame((Object)value, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, class$java$lang$Object == null ? (class$java$lang$Object = ParameterTestCase.class$("java.lang.Object")) : class$java$lang$Object));
    }

    public void testDependsOnTouchableWithTouchableSpecifiedAsConstant() throws PicoRegistrationException, PicoInitializationException {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        SimpleTouchable touchable = new SimpleTouchable();
        pico.registerComponentImplementation((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = ParameterTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable), class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = ParameterTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable, new Parameter[]{new ConstantParameter((Object)touchable)});
        pico.getComponentInstances();
        ParameterTestCase.assertTrue((boolean)touchable.wasTouched);
    }

    public void testComponentParameterRespectsExpectedType() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        ComponentParameter parameter = new ComponentParameter();
        ComponentAdapter adapter = picoContainer.registerComponentImplementation((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = ParameterTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable), class$org$picocontainer$testmodel$SimpleTouchable == null ? (class$org$picocontainer$testmodel$SimpleTouchable = ParameterTestCase.class$("org.picocontainer.testmodel.SimpleTouchable")) : class$org$picocontainer$testmodel$SimpleTouchable);
        ParameterTestCase.assertNull((Object)parameter.resolveInstance((PicoContainer)picoContainer, adapter, class$junit$framework$TestCase == null ? (class$junit$framework$TestCase = ParameterTestCase.class$("junit.framework.TestCase")) : class$junit$framework$TestCase));
    }

    public void testComponentParameterResolvesPrimitiveType() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        ComponentAdapter adapter = picoContainer.registerComponentInstance((Object)"glarch", (Object)new Integer(239));
        ComponentParameter parameter = new ComponentParameter((Object)"glarch");
        ParameterTestCase.assertNotNull((Object)parameter.resolveInstance((PicoContainer)picoContainer, adapter, Integer.TYPE));
        ParameterTestCase.assertEquals((int)239, (int)((Integer)parameter.resolveInstance((PicoContainer)picoContainer, adapter, Integer.TYPE)));
    }

    public void testConstantParameterRespectsExpectedType() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        ConstantParameter parameter = new ConstantParameter((Object)new SimpleTouchable());
        ComponentAdapter adapter = picoContainer.registerComponentImplementation((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = ParameterTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable), class$org$picocontainer$testmodel$SimpleTouchable == null ? (class$org$picocontainer$testmodel$SimpleTouchable = ParameterTestCase.class$("org.picocontainer.testmodel.SimpleTouchable")) : class$org$picocontainer$testmodel$SimpleTouchable);
        ParameterTestCase.assertFalse((boolean)parameter.isResolvable((PicoContainer)picoContainer, adapter, class$junit$framework$TestCase == null ? (class$junit$framework$TestCase = ParameterTestCase.class$("junit.framework.TestCase")) : class$junit$framework$TestCase));
    }

    public void testParameterRespectsExpectedType() throws PicoInitializationException, NotConcreteRegistrationException, PicoIntrospectionException {
        ConstantParameter parameter = new ConstantParameter((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = ParameterTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable));
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        ParameterTestCase.assertFalse((boolean)parameter.isResolvable((PicoContainer)picoContainer, null, class$junit$framework$TestCase == null ? (class$junit$framework$TestCase = ParameterTestCase.class$("junit.framework.TestCase")) : class$junit$framework$TestCase));
        parameter = new ComponentParameter();
        ComponentAdapter adapter = picoContainer.registerComponentImplementation((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = ParameterTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable), class$org$picocontainer$testmodel$SimpleTouchable == null ? (class$org$picocontainer$testmodel$SimpleTouchable = ParameterTestCase.class$("org.picocontainer.testmodel.SimpleTouchable")) : class$org$picocontainer$testmodel$SimpleTouchable);
        ParameterTestCase.assertNull((Object)parameter.resolveInstance((PicoContainer)picoContainer, adapter, class$junit$framework$TestCase == null ? (class$junit$framework$TestCase = ParameterTestCase.class$("junit.framework.TestCase")) : class$junit$framework$TestCase));
    }

    public void testConstantParameterWithPrimitives() throws PicoInitializationException, AssignabilityRegistrationException, NotConcreteRegistrationException, PicoIntrospectionException {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        Byte byteValue = new Byte(5);
        ConstantParameter parameter = new ConstantParameter((Object)byteValue);
        ParameterTestCase.assertSame((Object)byteValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, Byte.TYPE));
        ParameterTestCase.assertSame((Object)byteValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, class$java$lang$Byte == null ? (class$java$lang$Byte = ParameterTestCase.class$("java.lang.Byte")) : class$java$lang$Byte));
        Short shortValue = new Short(5);
        parameter = new ConstantParameter((Object)shortValue);
        ParameterTestCase.assertSame((Object)shortValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, Short.TYPE));
        ParameterTestCase.assertSame((Object)shortValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, class$java$lang$Short == null ? (class$java$lang$Short = ParameterTestCase.class$("java.lang.Short")) : class$java$lang$Short));
        Integer intValue = new Integer(5);
        parameter = new ConstantParameter((Object)intValue);
        ParameterTestCase.assertSame((Object)intValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, Integer.TYPE));
        ParameterTestCase.assertSame((Object)intValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterTestCase.class$("java.lang.Integer")) : class$java$lang$Integer));
        Long longValue = new Long(5L);
        parameter = new ConstantParameter((Object)longValue);
        ParameterTestCase.assertSame((Object)longValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, Long.TYPE));
        ParameterTestCase.assertSame((Object)longValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, class$java$lang$Long == null ? (class$java$lang$Long = ParameterTestCase.class$("java.lang.Long")) : class$java$lang$Long));
        Float floatValue = new Float(5.5);
        parameter = new ConstantParameter((Object)floatValue);
        ParameterTestCase.assertSame((Object)floatValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, Float.TYPE));
        ParameterTestCase.assertSame((Object)floatValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, class$java$lang$Float == null ? (class$java$lang$Float = ParameterTestCase.class$("java.lang.Float")) : class$java$lang$Float));
        Double doubleValue = new Double(5.5);
        parameter = new ConstantParameter((Object)doubleValue);
        ParameterTestCase.assertSame((Object)doubleValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, Double.TYPE));
        ParameterTestCase.assertSame((Object)doubleValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, class$java$lang$Double == null ? (class$java$lang$Double = ParameterTestCase.class$("java.lang.Double")) : class$java$lang$Double));
        Boolean booleanValue = new Boolean(true);
        parameter = new ConstantParameter((Object)booleanValue);
        ParameterTestCase.assertSame((Object)booleanValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, Boolean.TYPE));
        ParameterTestCase.assertSame((Object)booleanValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ParameterTestCase.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        Character charValue = new Character('x');
        parameter = new ConstantParameter((Object)charValue);
        ParameterTestCase.assertSame((Object)charValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, Character.TYPE));
        ParameterTestCase.assertSame((Object)charValue, (Object)parameter.resolveInstance((PicoContainer)picoContainer, null, class$java$lang$Character == null ? (class$java$lang$Character = ParameterTestCase.class$("java.lang.Character")) : class$java$lang$Character));
    }

    public void testConstantParameterWithPrimitivesRejectsUnexpectedType() throws PicoInitializationException, AssignabilityRegistrationException, NotConcreteRegistrationException, PicoIntrospectionException {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        Byte byteValue = new Byte(5);
        ConstantParameter parameter = new ConstantParameter((Object)byteValue);
        ParameterTestCase.assertFalse((boolean)parameter.isResolvable((PicoContainer)picoContainer, null, Integer.TYPE));
        Short shortValue = new Short(5);
        parameter = new ConstantParameter((Object)shortValue);
        ParameterTestCase.assertFalse((boolean)parameter.isResolvable((PicoContainer)picoContainer, null, Byte.TYPE));
        Integer intValue = new Integer(5);
        parameter = new ConstantParameter((Object)intValue);
        ParameterTestCase.assertFalse((boolean)parameter.isResolvable((PicoContainer)picoContainer, null, Byte.TYPE));
        Long longValue = new Long(5L);
        parameter = new ConstantParameter((Object)longValue);
        ParameterTestCase.assertFalse((boolean)parameter.isResolvable((PicoContainer)picoContainer, null, Byte.TYPE));
        Float floatValue = new Float(5.5);
        parameter = new ConstantParameter((Object)floatValue);
        ParameterTestCase.assertFalse((boolean)parameter.isResolvable((PicoContainer)picoContainer, null, Byte.TYPE));
        Double doubleValue = new Double(5.5);
        parameter = new ConstantParameter((Object)doubleValue);
        ParameterTestCase.assertFalse((boolean)parameter.isResolvable((PicoContainer)picoContainer, null, Byte.TYPE));
        Boolean booleanValue = new Boolean(true);
        parameter = new ConstantParameter((Object)booleanValue);
        ParameterTestCase.assertFalse((boolean)parameter.isResolvable((PicoContainer)picoContainer, null, Byte.TYPE));
        Character charValue = new Character('x');
        parameter = new ConstantParameter((Object)charValue);
        ParameterTestCase.assertFalse((boolean)parameter.isResolvable((PicoContainer)picoContainer, null, Byte.TYPE));
    }

    public void testKeyClashBug118() throws PicoRegistrationException, PicoInitializationException {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponentImplementation((Object)"A", class$java$lang$String == null ? (class$java$lang$String = ParameterTestCase.class$("java.lang.String")) : class$java$lang$String, new Parameter[]{new ConstantParameter((Object)"A")});
        pico.registerComponentImplementation((Object)"B", class$java$lang$String == null ? (class$java$lang$String = ParameterTestCase.class$("java.lang.String")) : class$java$lang$String, new Parameter[]{new ConstantParameter((Object)"A")});
        pico.verify();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

