/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.util.Arrays;
import java.util.List;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.Constraint;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.GenericCollectionComponentAdapter;
import org.picocontainer.defaults.InstanceComponentAdapter;

public class GenericCollectionComponentAdapterTestCase
extends MockObjectTestCase {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$picocontainer$PicoContainer;
    static /* synthetic */ Class class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl;
    static /* synthetic */ Class class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Cod;
    static /* synthetic */ Class class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Shark;

    public void testShouldInstantiateArrayOfStrings() {
        GenericCollectionComponentAdapter ca = new GenericCollectionComponentAdapter((Object)"x", null, class$java$lang$String == null ? (class$java$lang$String = GenericCollectionComponentAdapterTestCase.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = GenericCollectionComponentAdapterTestCase.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        Mock containerMock = this.mock(class$org$picocontainer$PicoContainer == null ? (class$org$picocontainer$PicoContainer = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.PicoContainer")) : class$org$picocontainer$PicoContainer);
        containerMock.expects(this.once()).method("getComponentAdaptersOfType").with((Constraint)this.eq(class$java$lang$String == null ? (class$java$lang$String = GenericCollectionComponentAdapterTestCase.class$("java.lang.String")) : class$java$lang$String)).will(this.returnValue(Arrays.asList(new InstanceComponentAdapter((Object)"y", (Object)"Hello"), new InstanceComponentAdapter((Object)"z", (Object)"World"))));
        containerMock.expects(this.once()).method("getComponentInstance").with((Constraint)this.eq("y")).will(this.returnValue("Hello"));
        containerMock.expects(this.once()).method("getComponentInstance").with((Constraint)this.eq("z")).will(this.returnValue("World"));
        List<String> expected = Arrays.asList("Hello", "World");
        List<Object> actual = Arrays.asList((Object[])ca.getComponentInstance((PicoContainer)containerMock.proxy()));
        GenericCollectionComponentAdapterTestCase.assertEquals(expected, actual);
    }

    public void testNativeArrays() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation(class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl == null ? (class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.defaults.GenericCollectionComponentAdapterTestCase$Bowl")) : class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl);
        mpc.registerComponentImplementation(class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Cod == null ? (class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Cod = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.defaults.GenericCollectionComponentAdapterTestCase$Cod")) : class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Cod);
        mpc.registerComponentImplementation(class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Shark == null ? (class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Shark = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.defaults.GenericCollectionComponentAdapterTestCase$Shark")) : class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Shark);
        Cod cod = (Cod)mpc.getComponentInstanceOfType(class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Cod == null ? (class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Cod = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.defaults.GenericCollectionComponentAdapterTestCase$Cod")) : class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Cod);
        Bowl bowl = (Bowl)mpc.getComponentInstance((Object)(class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl == null ? (class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.defaults.GenericCollectionComponentAdapterTestCase$Bowl")) : class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl));
        GenericCollectionComponentAdapterTestCase.assertEquals((int)1, (int)bowl.cods.length);
        GenericCollectionComponentAdapterTestCase.assertEquals((int)2, (int)bowl.fishes.length);
        GenericCollectionComponentAdapterTestCase.assertSame((Object)cod, (Object)bowl.cods[0]);
        GenericCollectionComponentAdapterTestCase.assertNotSame((Object)bowl.fishes[0], (Object)bowl.fishes[1]);
    }

    public void testCollectionsAreGeneratedOnTheFly() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponent((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)(class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl == null ? (class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.defaults.GenericCollectionComponentAdapterTestCase$Bowl")) : class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl), class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl == null ? (class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.defaults.GenericCollectionComponentAdapterTestCase$Bowl")) : class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl));
        mpc.registerComponentImplementation(class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Cod == null ? (class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Cod = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.defaults.GenericCollectionComponentAdapterTestCase$Cod")) : class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Cod);
        Bowl bowl = (Bowl)mpc.getComponentInstance((Object)(class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl == null ? (class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.defaults.GenericCollectionComponentAdapterTestCase$Bowl")) : class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl));
        GenericCollectionComponentAdapterTestCase.assertEquals((int)1, (int)bowl.cods.length);
        mpc.registerComponentInstance((Object)"Nemo", (Object)new Cod());
        bowl = (Bowl)mpc.getComponentInstance((Object)(class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl == null ? (class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl = GenericCollectionComponentAdapterTestCase.class$("org.picocontainer.defaults.GenericCollectionComponentAdapterTestCase$Bowl")) : class$org$picocontainer$defaults$GenericCollectionComponentAdapterTestCase$Bowl));
        GenericCollectionComponentAdapterTestCase.assertEquals((int)2, (int)bowl.cods.length);
        GenericCollectionComponentAdapterTestCase.assertNotSame((Object)bowl.cods[0], (Object)bowl.cods[1]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Bowl {
        private final Cod[] cods;
        private final Fish[] fishes;

        public Bowl(Cod[] cods, Fish[] fishes) {
            this.cods = cods;
            this.fishes = fishes;
        }
    }

    public static class Shark
    implements Fish {
        public String toString() {
            return "Shark";
        }
    }

    public static class Cod
    implements Fish {
        public String toString() {
            return "Cod";
        }
    }

    public static interface Fish {
    }
}

