/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.picocontainer.Disposable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.Startable;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class DefaultPicoContainerLifecycleTestCase
extends TestCase {
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Four;
    static /* synthetic */ Class class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two;
    static /* synthetic */ Class class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One;
    static /* synthetic */ Class class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three;
    static /* synthetic */ Class class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FooRunnable;
    static /* synthetic */ Class class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FiveTriesToBeMalicious;
    static /* synthetic */ Class class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$NotStartable;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$org$picocontainer$defaults$DefaultPicoContainer;
    static /* synthetic */ Class class$java$util$HashMap;

    public void testOrderOfInstantiationShouldBeDependencyOrder() throws Exception {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponentImplementation((Object)"recording", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = DefaultPicoContainerLifecycleTestCase.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Four == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Four = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Four")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Four);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Two")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$One")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Three")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three);
        List componentInstances = pico.getComponentInstances();
        DefaultPicoContainerLifecycleTestCase.assertEquals((String)"Incorrect Order of Instantiation", (Object)(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$One")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One), componentInstances.get(1).getClass());
        DefaultPicoContainerLifecycleTestCase.assertEquals((String)"Incorrect Order of Instantiation", (Object)(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Two")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two), componentInstances.get(2).getClass());
        DefaultPicoContainerLifecycleTestCase.assertEquals((String)"Incorrect Order of Instantiation", (Object)(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Three")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three), componentInstances.get(3).getClass());
        DefaultPicoContainerLifecycleTestCase.assertEquals((String)"Incorrect Order of Instantiation", (Object)(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Four == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Four = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Four")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Four), componentInstances.get(4).getClass());
    }

    public void testOrderOfStartShouldBeDependencyOrderAndStopAndDisposeTheOpposite() throws Exception {
        DefaultPicoContainer parent = new DefaultPicoContainer();
        MutablePicoContainer child = parent.makeChildContainer();
        parent.registerComponentImplementation((Object)"recording", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = DefaultPicoContainerLifecycleTestCase.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        child.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Four == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Four = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Four")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Four);
        parent.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Two")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two);
        parent.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$One")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One);
        child.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Three")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three);
        parent.start();
        parent.stop();
        parent.dispose();
        DefaultPicoContainerLifecycleTestCase.assertEquals((String)"<One<Two<Three<FourFour>Three>Two>One>!Four!Three!Two!One", (String)parent.getComponentInstance((Object)"recording").toString());
    }

    public void testStartStartShouldFail() throws Exception {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.start();
        try {
            pico.start();
            DefaultPicoContainerLifecycleTestCase.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testStartStopStopShouldFail() throws Exception {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.start();
        pico.stop();
        try {
            pico.stop();
            DefaultPicoContainerLifecycleTestCase.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testStartStopDisposeDisposeShouldFail() throws Exception {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.start();
        pico.stop();
        pico.dispose();
        try {
            pico.dispose();
            DefaultPicoContainerLifecycleTestCase.fail((String)"Should have barfed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testStartStopOfDaemonizedThread() throws Exception {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FooRunnable == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FooRunnable = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$FooRunnable")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FooRunnable);
        pico.getComponentInstances();
        pico.start();
        Thread.sleep(100L);
        pico.stop();
        FooRunnable foo = (FooRunnable)pico.getComponentInstance((Object)(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FooRunnable == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FooRunnable = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$FooRunnable")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FooRunnable));
        DefaultPicoContainerLifecycleTestCase.assertEquals((int)1, (int)foo.runCount());
        pico.start();
        Thread.sleep(100L);
        pico.stop();
        DefaultPicoContainerLifecycleTestCase.assertEquals((int)2, (int)foo.runCount());
    }

    public void testGetComponentInstancesOnParentContainerHostedChildContainerDoesntReturnParentAdapter() {
        DefaultPicoContainer parent = new DefaultPicoContainer();
        MutablePicoContainer child = parent.makeChildContainer();
        DefaultPicoContainerLifecycleTestCase.assertEquals((int)0, (int)child.getComponentInstances().size());
    }

    public void testComponentsAreStartedBreadthFirstAndStoppedAndDisposedDepthFirst() {
        DefaultPicoContainer parent = new DefaultPicoContainer();
        parent.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Two")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two);
        parent.registerComponentImplementation((Object)"recording", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = DefaultPicoContainerLifecycleTestCase.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        parent.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$One")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One);
        MutablePicoContainer child = parent.makeChildContainer();
        child.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Three")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three);
        parent.start();
        parent.stop();
        parent.dispose();
        DefaultPicoContainerLifecycleTestCase.assertEquals((String)"<One<Two<ThreeThree>Two>One>!Three!Two!One", (String)parent.getComponentInstance((Object)"recording").toString());
    }

    public void testMaliciousComponentCannotExistInAChildContainerAndSeeAnyElementOfContainerHierarchy() {
        DefaultPicoContainer parent = new DefaultPicoContainer();
        parent.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Two")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Two);
        parent.registerComponentImplementation((Object)"recording", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = DefaultPicoContainerLifecycleTestCase.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        parent.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$One")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One);
        MutablePicoContainer child = parent.makeChildContainer();
        child.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$Three")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$Three);
        child.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FiveTriesToBeMalicious == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FiveTriesToBeMalicious = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$FiveTriesToBeMalicious")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$FiveTriesToBeMalicious);
        try {
            parent.start();
            DefaultPicoContainerLifecycleTestCase.fail();
        }
        catch (UnsatisfiableDependenciesException unsatisfiableDependenciesException) {
            // empty catch block
        }
    }

    public void testOnlyStartableComponentsAreInstantiatedOnStart() {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponentImplementation((Object)"recording", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = DefaultPicoContainerLifecycleTestCase.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$One")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$One);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$NotStartable == null ? (class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$NotStartable = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainerLifecycleTestCase$NotStartable")) : class$org$picocontainer$defaults$DefaultPicoContainerLifecycleTestCase$NotStartable);
        pico.start();
        pico.stop();
        pico.dispose();
        DefaultPicoContainerLifecycleTestCase.assertEquals((String)"<OneOne>!One", (String)pico.getComponentInstance((Object)"recording").toString());
    }

    public void testShouldFailOnStartAfterDispose() {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.dispose();
        try {
            pico.start();
            DefaultPicoContainerLifecycleTestCase.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testShouldFailOnStopAfterDispose() {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.dispose();
        try {
            pico.stop();
            DefaultPicoContainerLifecycleTestCase.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testShouldStackContainersLast() {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponentImplementation(class$java$util$ArrayList == null ? (class$java$util$ArrayList = DefaultPicoContainerLifecycleTestCase.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$DefaultPicoContainer == null ? (class$org$picocontainer$defaults$DefaultPicoContainer = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainer")) : class$org$picocontainer$defaults$DefaultPicoContainer);
        pico.registerComponentImplementation(class$java$util$HashMap == null ? (class$java$util$HashMap = DefaultPicoContainerLifecycleTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        pico.start();
        PicoContainer childContainer = (PicoContainer)pico.getComponentInstance((Object)(class$org$picocontainer$defaults$DefaultPicoContainer == null ? (class$org$picocontainer$defaults$DefaultPicoContainer = DefaultPicoContainerLifecycleTestCase.class$("org.picocontainer.defaults.DefaultPicoContainer")) : class$org$picocontainer$defaults$DefaultPicoContainer));
        try {
            childContainer.start();
            DefaultPicoContainerLifecycleTestCase.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NotStartable {
        public NotStartable() {
            Assert.fail((String)"Shouldn't be instantiated");
        }
    }

    public static class FooRunnable
    implements Runnable,
    Startable {
        private int runCount;
        private Thread thread = new Thread();
        private boolean interrupted;

        public int runCount() {
            return this.runCount;
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void stop() {
            this.thread.interrupt();
        }

        public void run() {
            ++this.runCount;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                this.interrupted = true;
            }
        }
    }

    public static class FiveTriesToBeMalicious
    extends RecordingLifecycle {
        public FiveTriesToBeMalicious(StringBuffer sb, PicoContainer pc) {
            super(sb);
            Assert.assertNotNull((Object)pc);
            sb.append("Whao! Should not get instantiated!!");
        }
    }

    public static class Four
    extends RecordingLifecycle {
        public Four(StringBuffer sb, Two two, Three three, One one) {
            super(sb);
            Assert.assertNotNull((Object)one);
            Assert.assertNotNull((Object)two);
            Assert.assertNotNull((Object)three);
        }
    }

    public static class Three
    extends RecordingLifecycle {
        public Three(StringBuffer sb, One one, Two two) {
            super(sb);
            Assert.assertNotNull((Object)one);
            Assert.assertNotNull((Object)two);
        }
    }

    public static class Two
    extends RecordingLifecycle {
        public Two(StringBuffer sb, One one) {
            super(sb);
            Assert.assertNotNull((Object)one);
        }
    }

    public static class One
    extends RecordingLifecycle {
        public One(StringBuffer sb) {
            super(sb);
        }
    }

    public static abstract class RecordingLifecycle
    implements Startable,
    Disposable {
        private final StringBuffer recording;

        protected RecordingLifecycle(StringBuffer recording) {
            this.recording = recording;
        }

        public void start() {
            this.recording.append("<" + this.code());
        }

        public void stop() {
            this.recording.append(this.code() + ">");
        }

        public void dispose() {
            this.recording.append("!" + this.code());
        }

        private String code() {
            String name = this.getClass().getName();
            return name.substring(name.indexOf(36) + 1);
        }
    }
}

