/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ArraysTestCase
extends TestCase {
    private MutablePicoContainer pico;
    private Shark shark;
    private Cod cod;
    private Bowl bowl;
    static /* synthetic */ Class class$org$picocontainer$defaults$ArraysTestCase$Shark;
    static /* synthetic */ Class class$org$picocontainer$defaults$ArraysTestCase$Cod;
    static /* synthetic */ Class class$org$picocontainer$defaults$ArraysTestCase$Bowl;
    static /* synthetic */ Class class$org$picocontainer$defaults$ArraysTestCase$UngenericCollectionBowl;
    static /* synthetic */ Class class$org$picocontainer$defaults$ArraysTestCase$AnotherGenericCollectionBowl;

    protected void setUp() throws Exception {
        this.pico = new DefaultPicoContainer();
        this.pico.registerComponentImplementation(class$org$picocontainer$defaults$ArraysTestCase$Shark == null ? (class$org$picocontainer$defaults$ArraysTestCase$Shark = ArraysTestCase.class$("org.picocontainer.defaults.ArraysTestCase$Shark")) : class$org$picocontainer$defaults$ArraysTestCase$Shark);
        this.pico.registerComponentImplementation(class$org$picocontainer$defaults$ArraysTestCase$Cod == null ? (class$org$picocontainer$defaults$ArraysTestCase$Cod = ArraysTestCase.class$("org.picocontainer.defaults.ArraysTestCase$Cod")) : class$org$picocontainer$defaults$ArraysTestCase$Cod);
        this.pico.registerComponentImplementation(class$org$picocontainer$defaults$ArraysTestCase$Bowl == null ? (class$org$picocontainer$defaults$ArraysTestCase$Bowl = ArraysTestCase.class$("org.picocontainer.defaults.ArraysTestCase$Bowl")) : class$org$picocontainer$defaults$ArraysTestCase$Bowl);
        this.bowl = (Bowl)this.pico.getComponentInstance((Object)(class$org$picocontainer$defaults$ArraysTestCase$Bowl == null ? (class$org$picocontainer$defaults$ArraysTestCase$Bowl = ArraysTestCase.class$("org.picocontainer.defaults.ArraysTestCase$Bowl")) : class$org$picocontainer$defaults$ArraysTestCase$Bowl));
        this.shark = (Shark)this.pico.getComponentInstanceOfType(class$org$picocontainer$defaults$ArraysTestCase$Shark == null ? (class$org$picocontainer$defaults$ArraysTestCase$Shark = ArraysTestCase.class$("org.picocontainer.defaults.ArraysTestCase$Shark")) : class$org$picocontainer$defaults$ArraysTestCase$Shark);
        this.cod = (Cod)this.pico.getComponentInstanceOfType(class$org$picocontainer$defaults$ArraysTestCase$Cod == null ? (class$org$picocontainer$defaults$ArraysTestCase$Cod = ArraysTestCase.class$("org.picocontainer.defaults.ArraysTestCase$Cod")) : class$org$picocontainer$defaults$ArraysTestCase$Cod);
    }

    private void explanation() {
        Shark shark = new Shark();
        Cod cod = new Cod();
        Fish[] fishes = new Fish[]{shark, cod};
        Cod[] cods = new Cod[]{cod};
        Bowl bowl = new Bowl(fishes, cods);
    }

    public void testShouldCreateBowlWithFishCollection() {
        Fish[] fishes = this.bowl.getFishes();
        ArraysTestCase.assertEquals((int)2, (int)fishes.length);
        ArraysTestCase.assertTrue((boolean)Arrays.asList(fishes).contains(this.shark));
        ArraysTestCase.assertTrue((boolean)Arrays.asList(fishes).contains(this.cod));
        Cod[] cods = this.bowl.getCods();
        ArraysTestCase.assertEquals((int)1, (int)cods.length);
        ArraysTestCase.assertTrue((boolean)Arrays.asList(cods).contains(this.cod));
    }

    public void testShouldNotInstantiateCollectionForUngenericCollectionParameters() {
        this.pico.registerComponentImplementation(class$org$picocontainer$defaults$ArraysTestCase$UngenericCollectionBowl == null ? (class$org$picocontainer$defaults$ArraysTestCase$UngenericCollectionBowl = ArraysTestCase.class$("org.picocontainer.defaults.ArraysTestCase$UngenericCollectionBowl")) : class$org$picocontainer$defaults$ArraysTestCase$UngenericCollectionBowl);
        try {
            this.pico.getComponentInstance((Object)(class$org$picocontainer$defaults$ArraysTestCase$UngenericCollectionBowl == null ? (class$org$picocontainer$defaults$ArraysTestCase$UngenericCollectionBowl = ArraysTestCase.class$("org.picocontainer.defaults.ArraysTestCase$UngenericCollectionBowl")) : class$org$picocontainer$defaults$ArraysTestCase$UngenericCollectionBowl));
            ArraysTestCase.fail();
        }
        catch (UnsatisfiableDependenciesException unsatisfiableDependenciesException) {
            // empty catch block
        }
    }

    public void testShouldFailWhenThereAreNoComponentsToPutInTheArray() {
        this.pico.registerComponentImplementation(class$org$picocontainer$defaults$ArraysTestCase$AnotherGenericCollectionBowl == null ? (class$org$picocontainer$defaults$ArraysTestCase$AnotherGenericCollectionBowl = ArraysTestCase.class$("org.picocontainer.defaults.ArraysTestCase$AnotherGenericCollectionBowl")) : class$org$picocontainer$defaults$ArraysTestCase$AnotherGenericCollectionBowl);
        try {
            this.pico.getComponentInstance((Object)(class$org$picocontainer$defaults$ArraysTestCase$AnotherGenericCollectionBowl == null ? (class$org$picocontainer$defaults$ArraysTestCase$AnotherGenericCollectionBowl = ArraysTestCase.class$("org.picocontainer.defaults.ArraysTestCase$AnotherGenericCollectionBowl")) : class$org$picocontainer$defaults$ArraysTestCase$AnotherGenericCollectionBowl));
            ArraysTestCase.fail();
        }
        catch (UnsatisfiableDependenciesException unsatisfiableDependenciesException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class AnotherGenericCollectionBowl {
        private final String[] strings;

        public AnotherGenericCollectionBowl(String[] strings) {
            this.strings = strings;
        }

        public String[] getStrings() {
            return this.strings;
        }
    }

    public static class UngenericCollectionBowl {
        public UngenericCollectionBowl(Collection fish) {
        }
    }

    public static class Bowl {
        private final Fish[] fishes;
        private final Cod[] cods;

        public Bowl(Fish[] fishes, Cod[] cods) {
            this.fishes = fishes;
            this.cods = cods;
        }

        public Fish[] getFishes() {
            return this.fishes;
        }

        public Cod[] getCods() {
            return this.cods;
        }
    }

    public static class Shark
    implements Fish {
    }

    public static class Cod
    implements Fish {
    }

    public static interface Fish {
    }
}

