/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.alternatives;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.Constraint;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Disposable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.alternatives.ImmutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;

public class ImmutablePicoContainerTestCase
extends MockObjectTestCase {
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$UnsatisfiableIterator;
    static /* synthetic */ Class class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable;
    static /* synthetic */ Class class$org$picocontainer$PicoVisitor;

    public void testImmutingofNullBarfs() {
        try {
            new ImmutablePicoContainer(null);
            ImmutablePicoContainerTestCase.fail((String)"Should have barfed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDelegationOfGettingComponentInstance() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        Map map = (Map)ipc.getComponentInstance((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map));
        ImmutablePicoContainerTestCase.assertNotNull((Object)map);
    }

    public void testDelegationOfGettingComponentInstanceOfType() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        Map map = (Map)ipc.getComponentInstanceOfType(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map);
        ImmutablePicoContainerTestCase.assertNotNull((Object)map);
    }

    public void testDelegationOfGettingComponentInstancesOfType() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        mpc.registerComponentImplementation((Object)(class$java$util$Collection == null ? (class$java$util$Collection = ImmutablePicoContainerTestCase.class$("java.util.Collection")) : class$java$util$Collection), class$java$util$Vector == null ? (class$java$util$Vector = ImmutablePicoContainerTestCase.class$("java.util.Vector")) : class$java$util$Vector);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        List list = ipc.getComponentInstancesOfType(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map);
        ImmutablePicoContainerTestCase.assertNotNull((Object)list);
        ImmutablePicoContainerTestCase.assertEquals((int)1, (int)list.size());
    }

    public void testDelegationOfGetComponentInstances() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        List comps = ipc.getComponentInstances();
        ImmutablePicoContainerTestCase.assertNotNull((Object)comps);
        ImmutablePicoContainerTestCase.assertEquals((int)1, (int)comps.size());
    }

    public void testDelegationOfGetComponentAdapter() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        ComponentAdapter ca = ipc.getComponentAdapter((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map));
        ImmutablePicoContainerTestCase.assertNotNull((Object)ca);
    }

    public void testDelegationOfGetComponentAdapterOfType() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        ComponentAdapter ca = ipc.getComponentAdapterOfType(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map);
        ImmutablePicoContainerTestCase.assertNotNull((Object)ca);
    }

    public void testDelegationOfGetComponentAdapters() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        Collection comps = ipc.getComponentAdapters();
        ImmutablePicoContainerTestCase.assertNotNull((Object)comps);
        ImmutablePicoContainerTestCase.assertEquals((int)1, (int)comps.size());
    }

    public void testDelegationOfGetComponentAdaptersOfType() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        List comps = ipc.getComponentAdaptersOfType(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map);
        ImmutablePicoContainerTestCase.assertNotNull((Object)comps);
        ImmutablePicoContainerTestCase.assertEquals((int)1, (int)comps.size());
    }

    public void testDelegationOfVerify() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Iterator == null ? (class$java$util$Iterator = ImmutablePicoContainerTestCase.class$("java.util.Iterator")) : class$java$util$Iterator), class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$UnsatisfiableIterator == null ? (class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$UnsatisfiableIterator = ImmutablePicoContainerTestCase.class$("org.picocontainer.alternatives.ImmutablePicoContainerTestCase$UnsatisfiableIterator")) : class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$UnsatisfiableIterator);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        try {
            ipc.verify();
            ImmutablePicoContainerTestCase.fail((String)"wrong!");
        }
        catch (PicoVerificationException picoVerificationException) {
            // empty catch block
        }
    }

    public void testGetParentForMutable() {
        DefaultPicoContainer par = new DefaultPicoContainer();
        DefaultPicoContainer mpc = new DefaultPicoContainer((PicoContainer)par);
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        PicoContainer parent = ipc.getParent();
        ImmutablePicoContainerTestCase.assertNotNull((Object)parent);
        ImmutablePicoContainerTestCase.assertNotSame((Object)par, (Object)parent);
        PicoContainer parent2 = ipc.getParent();
        ImmutablePicoContainerTestCase.assertNotNull((Object)parent2);
        ImmutablePicoContainerTestCase.assertEquals((Object)parent, (Object)parent2);
    }

    public void testGetParentForNonMutable() {
        DefaultPicoContainer par = new DefaultPicoContainer();
        ImmutablePicoContainer par2 = new ImmutablePicoContainer((PicoContainer)par);
        DefaultPicoContainer mpc = new DefaultPicoContainer((PicoContainer)par2);
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        PicoContainer parent = ipc.getParent();
        ImmutablePicoContainerTestCase.assertNotNull((Object)parent);
        ImmutablePicoContainerTestCase.assertNotSame((Object)par, (Object)parent);
        PicoContainer parent2 = ipc.getParent();
        ImmutablePicoContainerTestCase.assertNotNull((Object)parent2);
        ImmutablePicoContainerTestCase.assertEquals((Object)parent, (Object)parent2);
    }

    public void testStartBarfs() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        try {
            ipc.start();
            ImmutablePicoContainerTestCase.fail((String)"should have barfed");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testStopBarfs() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        try {
            ipc.stop();
            ImmutablePicoContainerTestCase.fail((String)"stop have barfed");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testDisposeBarfs() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = ImmutablePicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = ImmutablePicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        try {
            ipc.dispose();
            ImmutablePicoContainerTestCase.fail((String)"should have barfed");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testLifecycleGuardIsEasyToCircumventSoItMightAsWellBeDeleted() {
        DefaultPicoContainer mpc = new DefaultPicoContainer();
        mpc.registerComponentImplementation(class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable == null ? (class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable = ImmutablePicoContainerTestCase.class$("org.picocontainer.alternatives.ImmutablePicoContainerTestCase$MyDisposable")) : class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)mpc);
        List componentInstances = ipc.getComponentInstances();
        Iterator iterator = componentInstances.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof Disposable)) continue;
            ((Disposable)o).dispose();
        }
        MyDisposable disposable = (MyDisposable)ipc.getComponentInstance((Object)(class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable == null ? (class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable = ImmutablePicoContainerTestCase.class$("org.picocontainer.alternatives.ImmutablePicoContainerTestCase$MyDisposable")) : class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable));
        ImmutablePicoContainerTestCase.assertTrue((boolean)disposable.disposed);
    }

    public void testFacetiouslyThatLifeCycleGuardPreventsCyclingOfChildContainersAsComponentsAreNotTheOnlyThingsThatAreLifecycleable() {
        DefaultPicoContainer parent = new DefaultPicoContainer();
        MutablePicoContainer child = parent.makeChildContainer();
        parent.registerComponentImplementation((Object)"foo", class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable == null ? (class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable = ImmutablePicoContainerTestCase.class$("org.picocontainer.alternatives.ImmutablePicoContainerTestCase$MyDisposable")) : class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable);
        child.registerComponentImplementation((Object)"bar", class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable == null ? (class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable = ImmutablePicoContainerTestCase.class$("org.picocontainer.alternatives.ImmutablePicoContainerTestCase$MyDisposable")) : class$org$picocontainer$alternatives$ImmutablePicoContainerTestCase$MyDisposable);
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)parent);
        try {
            ipc.dispose();
            ImmutablePicoContainerTestCase.fail((String)"Should have barfed");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        MyDisposable parentDisposable = (MyDisposable)parent.getComponentInstance((Object)"foo");
        ImmutablePicoContainerTestCase.assertFalse((boolean)parentDisposable.disposed);
        MyDisposable childDisposable = (MyDisposable)child.getComponentInstance((Object)"bar");
        ImmutablePicoContainerTestCase.assertFalse((boolean)childDisposable.disposed);
        ((Disposable)ipc.getComponentInstances().get(0)).dispose();
        ImmutablePicoContainerTestCase.assertTrue((boolean)parentDisposable.disposed);
    }

    public void testVisitingOfImmutableContainerWorks() {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        Object foo = new Object();
        ComponentAdapter componentAdapter = pico.registerComponentInstance(foo);
        Mock fooVisitor = new Mock(class$org$picocontainer$PicoVisitor == null ? (class$org$picocontainer$PicoVisitor = ImmutablePicoContainerTestCase.class$("org.picocontainer.PicoVisitor")) : class$org$picocontainer$PicoVisitor);
        fooVisitor.expects(this.atLeastOnce()).method("isReverseTraversal").withNoArguments().will(this.returnValue(false));
        fooVisitor.expects(this.once()).method("visitContainer").with((Constraint)this.eq(pico));
        fooVisitor.expects(this.once()).method("visitComponentAdapter").with((Constraint)this.eq(componentAdapter));
        ImmutablePicoContainer ipc = new ImmutablePicoContainer((PicoContainer)pico);
        ipc.accept((PicoVisitor)fooVisitor.proxy());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MyDisposable
    implements Disposable {
        public boolean disposed;

        public void dispose() {
            this.disposed = true;
        }
    }

    public static class UnsatisfiableIterator
    implements Iterator {
        public UnsatisfiableIterator(Map map) {
        }

        public void remove() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }
    }
}

