/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Disposable;
import org.picocontainer.Parameter;
import org.picocontainer.Startable;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.CachingComponentAdapterFactory;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.SetterInjectionComponentAdapter;
import org.picocontainer.defaults.SetterInjectionComponentAdapterFactory;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class SetterInjectionComponentAdapterTestCase
extends TestCase {
    static /* synthetic */ Class class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$A;
    static /* synthetic */ Class class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$C;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Four;
    static /* synthetic */ Class class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Two;
    static /* synthetic */ Class class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$One;
    static /* synthetic */ Class class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Three;
    static /* synthetic */ Class class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yin;
    static /* synthetic */ Class class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yang;

    public void testDependenciesAreResolved() {
        SetterInjectionComponentAdapter aAdapter = new SetterInjectionComponentAdapter((Object)"a", class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$A == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$A = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$A")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$A, null);
        SetterInjectionComponentAdapter bAdapter = new SetterInjectionComponentAdapter((Object)"b", class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$B")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B, null);
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponent((ComponentAdapter)bAdapter);
        pico.registerComponent((ComponentAdapter)aAdapter);
        pico.registerComponentInstance((Object)"YO");
        pico.registerComponentImplementation(class$java$util$ArrayList == null ? (class$java$util$ArrayList = SetterInjectionComponentAdapterTestCase.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        A a = (A)aAdapter.getComponentInstance();
        SetterInjectionComponentAdapterTestCase.assertNotNull((Object)a.getB());
        SetterInjectionComponentAdapterTestCase.assertNotNull((Object)a.getString());
        SetterInjectionComponentAdapterTestCase.assertNotNull((Object)a.getList());
    }

    public void testAllUnsatisfiableDependenciesAreSignalled() {
        SetterInjectionComponentAdapter aAdapter = new SetterInjectionComponentAdapter((Object)"a", class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$A == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$A = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$A")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$A, null);
        SetterInjectionComponentAdapter bAdapter = new SetterInjectionComponentAdapter((Object)"b", class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$B")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B, null);
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponent((ComponentAdapter)bAdapter);
        pico.registerComponent((ComponentAdapter)aAdapter);
        try {
            aAdapter.getComponentInstance();
        }
        catch (UnsatisfiableDependenciesException e) {
            SetterInjectionComponentAdapterTestCase.assertTrue((boolean)e.getUnsatisfiableDependencies().contains(class$java$util$List == null ? (class$java$util$List = SetterInjectionComponentAdapterTestCase.class$("java.util.List")) : class$java$util$List));
            SetterInjectionComponentAdapterTestCase.assertTrue((boolean)e.getUnsatisfiableDependencies().contains(class$java$lang$String == null ? (class$java$lang$String = SetterInjectionComponentAdapterTestCase.class$("java.lang.String")) : class$java$lang$String));
        }
    }

    public void testShouldBeAbleToTakeParameters() {
        ArrayList list = new ArrayList();
        Parameter[] aParameters = new Parameter[]{new ComponentParameter(), new ConstantParameter((Object)"YO"), new ConstantParameter(list)};
        SetterInjectionComponentAdapter aAdapter = new SetterInjectionComponentAdapter((Object)"a", class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$A == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$A = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$A")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$A, aParameters);
        SetterInjectionComponentAdapter bAdapter = new SetterInjectionComponentAdapter((Object)"b", class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$B")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B, null);
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponent((ComponentAdapter)bAdapter);
        pico.registerComponent((ComponentAdapter)aAdapter);
        A a = (A)aAdapter.getComponentInstance();
        SetterInjectionComponentAdapterTestCase.assertNotNull((Object)a.getB());
        SetterInjectionComponentAdapterTestCase.assertEquals((String)"YO", (String)a.getString());
        SetterInjectionComponentAdapterTestCase.assertSame(list, (Object)a.getList());
    }

    public void testHybridBeans() {
        SetterInjectionComponentAdapter bAdapter = new SetterInjectionComponentAdapter((Object)"b", class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$B")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$B, null);
        SetterInjectionComponentAdapter cAdapter = new SetterInjectionComponentAdapter((Object)"c", class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$C == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$C = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$C")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$C, null);
        SetterInjectionComponentAdapter cNullAdapter = new SetterInjectionComponentAdapter((Object)"c0", class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$C == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$C = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$C")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$C, null);
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponent((ComponentAdapter)bAdapter);
        pico.registerComponent((ComponentAdapter)cAdapter);
        pico.registerComponent((ComponentAdapter)cNullAdapter);
        pico.registerComponentImplementation(class$java$util$ArrayList == null ? (class$java$util$ArrayList = SetterInjectionComponentAdapterTestCase.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        C c2 = (C)cAdapter.getComponentInstance();
        SetterInjectionComponentAdapterTestCase.assertTrue((boolean)c2.instantiatedAsBean());
        C c0 = (C)cNullAdapter.getComponentInstance();
        SetterInjectionComponentAdapterTestCase.assertTrue((boolean)c0.instantiatedAsBean());
    }

    public void testOrderOfInstantiationShouldBeDependencyOrder() throws Exception {
        DefaultPicoContainer pico = new DefaultPicoContainer((ComponentAdapterFactory)new CachingComponentAdapterFactory((ComponentAdapterFactory)new SetterInjectionComponentAdapterFactory()));
        pico.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)"recording", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = SetterInjectionComponentAdapterTestCase.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer)));
        pico.registerComponentImplementation(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Four == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Four = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Four")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Four);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Two == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Two = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Two")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Two);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$One == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$One = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$One")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$One);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Three == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Three = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Three")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Three);
        List componentInstances = pico.getComponentInstances();
        SetterInjectionComponentAdapterTestCase.assertEquals((String)"Incorrect Order of Instantiation", (Object)(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$One == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$One = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$One")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$One), componentInstances.get(1).getClass());
        SetterInjectionComponentAdapterTestCase.assertEquals((String)"Incorrect Order of Instantiation", (Object)(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Two == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Two = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Two")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Two), componentInstances.get(2).getClass());
        SetterInjectionComponentAdapterTestCase.assertEquals((String)"Incorrect Order of Instantiation", (Object)(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Three == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Three = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Three")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Three), componentInstances.get(3).getClass());
        SetterInjectionComponentAdapterTestCase.assertEquals((String)"Incorrect Order of Instantiation", (Object)(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Four == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Four = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Four")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Four), componentInstances.get(4).getClass());
    }

    public void testOrderOfStartShouldBeDependencyOrderAndStopAndDisposeTheOpposite() throws Exception {
        DefaultPicoContainer pico = new DefaultPicoContainer((ComponentAdapterFactory)new CachingComponentAdapterFactory((ComponentAdapterFactory)new SetterInjectionComponentAdapterFactory()));
        pico.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)"recording", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = SetterInjectionComponentAdapterTestCase.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer)));
        pico.registerComponentImplementation(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Four == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Four = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Four")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Four);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Two == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Two = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Two")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Two);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$One == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$One = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$One")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$One);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Three == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Three = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Three")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Three);
        pico.start();
        pico.stop();
        pico.dispose();
        SetterInjectionComponentAdapterTestCase.assertEquals((String)"<One<Two<Three<FourFour>Three>Two>One>!Four!Three!Two!One", (String)pico.getComponentInstance((Object)"recording").toString());
    }

    public void FIXME_testShouldBeAbleToHandleMutualDependenciesWithSetterInjection() {
        DefaultPicoContainer pico = new DefaultPicoContainer((ComponentAdapterFactory)new CachingComponentAdapterFactory((ComponentAdapterFactory)new SetterInjectionComponentAdapterFactory()));
        pico.registerComponentImplementation(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yin == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yin = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Yin")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yin);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yang == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yang = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Yang")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yang);
        Yin yin = (Yin)pico.getComponentInstance((Object)(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yin == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yin = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Yin")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yin));
        Yang yang = (Yang)pico.getComponentInstance((Object)(class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yang == null ? (class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yang = SetterInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.SetterInjectionComponentAdapterTestCase$Yang")) : class$org$picocontainer$defaults$SetterInjectionComponentAdapterTestCase$Yang));
        SetterInjectionComponentAdapterTestCase.assertSame((Object)yin, (Object)yang.getYin());
        SetterInjectionComponentAdapterTestCase.assertSame((Object)yang, (Object)yin.getYang());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Yang {
        private Yin yin;

        public void setYang(Yin yin) {
            this.yin = yin;
        }

        public Yin getYin() {
            return this.yin;
        }
    }

    public static class Yin {
        private Yang yang;

        public void setYin(Yang yang) {
            this.yang = yang;
        }

        public Yang getYang() {
            return this.yang;
        }
    }

    public static class Four
    extends RecordingLifecycle {
        public void setOne(One one) {
        }

        public void setTwo(Two two) {
        }

        public void setThree(Three three) {
        }
    }

    public static class Three
    extends RecordingLifecycle {
        public void setOne(One one) {
        }

        public void setTwo(Two two) {
        }
    }

    public static class Two
    extends RecordingLifecycle {
        public void setOne(One one) {
        }
    }

    public static class One
    extends RecordingLifecycle {
    }

    public static abstract class RecordingLifecycle
    implements Startable,
    Disposable {
        private StringBuffer recording;

        protected RecordingLifecycle() {
        }

        public void setRecording(StringBuffer recording) {
            this.recording = recording;
        }

        public void start() {
            this.recording.append("<" + this.code());
        }

        public void stop() {
            this.recording.append(this.code() + ">");
        }

        public void dispose() {
            this.recording.append("!" + this.code());
        }

        private String code() {
            String name = this.getClass().getName();
            return name.substring(name.indexOf(36) + 1);
        }
    }

    public static class C {
        private B b;
        private List l;
        private final boolean asBean;

        public C() {
            this.asBean = true;
        }

        public C(B b) {
            this.l = new ArrayList();
            this.b = b;
            this.asBean = false;
        }

        public void setB(B b) {
            this.b = b;
        }

        public B getB() {
            return this.b;
        }

        public void setList(List l) {
            this.l = l;
        }

        public List getList() {
            return this.l;
        }

        public boolean instantiatedAsBean() {
            return this.asBean;
        }
    }

    public static class B {
    }

    public static class A {
        private B b;
        private String string;
        private List list;

        public void setB(B b) {
            this.b = b;
        }

        public B getB() {
            return this.b;
        }

        public String getString() {
            return this.string;
        }

        public void setString(String string) {
            this.string = string;
        }

        public List getList() {
            return this.list;
        }

        public void setList(List list) {
            this.list = list;
        }
    }
}

