/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.awt.AWTError;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapterFactory;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ConstructorInjectionComponentAdapterTestCase
extends TestCase {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$Service;
    static /* synthetic */ Class class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent;
    static /* synthetic */ Class class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$A;
    static /* synthetic */ Class class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$B;
    static /* synthetic */ Class class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$C1;
    static /* synthetic */ Class class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$C2;
    static /* synthetic */ Class class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$D;
    static /* synthetic */ Class class$org$picocontainer$defaults$Erroneous;
    static /* synthetic */ Class class$org$picocontainer$defaults$RuntimeThrowing;
    static /* synthetic */ Class class$org$picocontainer$defaults$NormalExceptionThrowing;
    static /* synthetic */ Class class$org$picocontainer$defaults$InstantiationExceptionThrowing;
    static /* synthetic */ Class class$org$picocontainer$defaults$IllegalAccessExceptionThrowing;
    static /* synthetic */ Class class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$Private;
    static /* synthetic */ Class class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$NotYourBusiness;

    public void testNonCachingComponentAdapterReturnsNewInstanceOnEachCallToGetComponentInstance() {
        ConstructorInjectionComponentAdapter componentAdapter = new ConstructorInjectionComponentAdapter((Object)"blah", class$java$lang$Object == null ? (class$java$lang$Object = ConstructorInjectionComponentAdapterTestCase.class$("java.lang.Object")) : class$java$lang$Object);
        Object o1 = componentAdapter.getComponentInstance();
        Object o2 = componentAdapter.getComponentInstance();
        ConstructorInjectionComponentAdapterTestCase.assertNotNull((Object)o1);
        ConstructorInjectionComponentAdapterTestCase.assertNotSame((Object)o1, (Object)o2);
    }

    public void testDefaultPicoContainerReturnsNewInstanceForEachCallWhenUsingTransientComponentAdapter() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        picoContainer.registerComponentImplementation(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$Service == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$Service = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$Service")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$Service);
        picoContainer.registerComponent((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$TransientComponent")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent), class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$TransientComponent")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent));
        TransientComponent c1 = (TransientComponent)picoContainer.getComponentInstance((Object)(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$TransientComponent")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent));
        TransientComponent c2 = (TransientComponent)picoContainer.getComponentInstance((Object)(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$TransientComponent")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$TransientComponent));
        ConstructorInjectionComponentAdapterTestCase.assertNotSame((Object)c1, (Object)c2);
        ConstructorInjectionComponentAdapterTestCase.assertSame((Object)c1.service, (Object)c2.service);
    }

    public void testSuccessfulVerificationWithNoDependencies() {
        ConstructorInjectionComponentAdapter componentAdapter = new ConstructorInjectionComponentAdapter((Object)"foo", class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$A == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$A = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$A")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$A);
        componentAdapter.verify();
    }

    public void testFailingVerificationWithUnsatisfiedDependencies() {
        ConstructorInjectionComponentAdapter componentAdapter = new ConstructorInjectionComponentAdapter((Object)"foo", class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$B == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$B = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$B")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$B);
        componentAdapter.setContainer((PicoContainer)new DefaultPicoContainer());
        try {
            componentAdapter.verify();
            ConstructorInjectionComponentAdapterTestCase.fail();
        }
        catch (UnsatisfiableDependenciesException unsatisfiableDependenciesException) {
            // empty catch block
        }
    }

    public void testFailingVerificationWithCyclicDependencyException() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        picoContainer.registerComponentImplementation(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$C1 == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$C1 = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$C1")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$C1);
        picoContainer.registerComponentImplementation(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$C2 == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$C2 = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$C2")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$C2);
        try {
            picoContainer.verify();
            ConstructorInjectionComponentAdapterTestCase.fail();
        }
        catch (CyclicDependencyException e) {
            String message = e.getMessage();
            ConstructorInjectionComponentAdapterTestCase.assertTrue((message.indexOf("C1") + message.indexOf("C2") > 0 ? 1 : 0) != 0);
        }
    }

    public void testFailingVerificationWithPicoInitializationException() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        picoContainer.registerComponentImplementation(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$A == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$A = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$A")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$A);
        picoContainer.registerComponentImplementation(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$B == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$B = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$B")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$B);
        picoContainer.registerComponentImplementation((Object)(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$D == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$D = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$D")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$D), class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$D == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$D = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$D")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$D, new Parameter[]{new ComponentParameter(), new ComponentParameter()});
        try {
            picoContainer.verify();
            ConstructorInjectionComponentAdapterTestCase.fail();
        }
        catch (PicoInitializationException e) {
            String message = e.getMessage();
            ConstructorInjectionComponentAdapterTestCase.assertTrue((message.indexOf((class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$D == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$D = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$D")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$D).getName() + "(" + (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$A == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$A = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$A")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$A).getName() + ")") > 0 ? 1 : 0) != 0);
        }
    }

    public void testErrorThrownInCtorIsRethrown() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        picoContainer.registerComponentImplementation(class$org$picocontainer$defaults$Erroneous == null ? (class$org$picocontainer$defaults$Erroneous = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.Erroneous")) : class$org$picocontainer$defaults$Erroneous);
        try {
            picoContainer.getComponentInstance((Object)(class$org$picocontainer$defaults$Erroneous == null ? (class$org$picocontainer$defaults$Erroneous = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.Erroneous")) : class$org$picocontainer$defaults$Erroneous));
            ConstructorInjectionComponentAdapterTestCase.fail();
        }
        catch (AWTError aWTError) {
            // empty catch block
        }
    }

    public void testRuntimeExceptionThrownInCtorIsRethrown() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        picoContainer.registerComponentImplementation(class$org$picocontainer$defaults$RuntimeThrowing == null ? (class$org$picocontainer$defaults$RuntimeThrowing = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.RuntimeThrowing")) : class$org$picocontainer$defaults$RuntimeThrowing);
        try {
            picoContainer.getComponentInstance((Object)(class$org$picocontainer$defaults$RuntimeThrowing == null ? (class$org$picocontainer$defaults$RuntimeThrowing = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.RuntimeThrowing")) : class$org$picocontainer$defaults$RuntimeThrowing));
            ConstructorInjectionComponentAdapterTestCase.fail();
        }
        catch (RuntimeException e) {
            ConstructorInjectionComponentAdapterTestCase.assertEquals((String)"ha!", (String)e.getMessage());
        }
    }

    public void testNormalExceptionThrownInCtorIsRethrownInsideInvocationTargetExeption() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        picoContainer.registerComponentImplementation(class$org$picocontainer$defaults$NormalExceptionThrowing == null ? (class$org$picocontainer$defaults$NormalExceptionThrowing = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.NormalExceptionThrowing")) : class$org$picocontainer$defaults$NormalExceptionThrowing);
        try {
            picoContainer.getComponentInstance((Object)(class$org$picocontainer$defaults$NormalExceptionThrowing == null ? (class$org$picocontainer$defaults$NormalExceptionThrowing = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.NormalExceptionThrowing")) : class$org$picocontainer$defaults$NormalExceptionThrowing));
            ConstructorInjectionComponentAdapterTestCase.fail();
        }
        catch (PicoInvocationTargetInitializationException e) {
            ConstructorInjectionComponentAdapterTestCase.assertEquals((String)"ha!", (String)e.getCause().getMessage());
        }
    }

    public void testInstantiationExceptionThrownInCtorIsRethrownInsideInvocationTargetExeption() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        try {
            picoContainer.registerComponentImplementation(class$org$picocontainer$defaults$InstantiationExceptionThrowing == null ? (class$org$picocontainer$defaults$InstantiationExceptionThrowing = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.InstantiationExceptionThrowing")) : class$org$picocontainer$defaults$InstantiationExceptionThrowing);
            picoContainer.getComponentInstance((Object)(class$org$picocontainer$defaults$InstantiationExceptionThrowing == null ? (class$org$picocontainer$defaults$InstantiationExceptionThrowing = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.InstantiationExceptionThrowing")) : class$org$picocontainer$defaults$InstantiationExceptionThrowing));
            ConstructorInjectionComponentAdapterTestCase.fail();
        }
        catch (NotConcreteRegistrationException notConcreteRegistrationException) {
            // empty catch block
        }
    }

    public void testIllegalAccessExceptionThrownInCtorIsRethrownInsideInvocationTargetExeption() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer();
        try {
            picoContainer.registerComponentImplementation(class$org$picocontainer$defaults$IllegalAccessExceptionThrowing == null ? (class$org$picocontainer$defaults$IllegalAccessExceptionThrowing = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.IllegalAccessExceptionThrowing")) : class$org$picocontainer$defaults$IllegalAccessExceptionThrowing);
            picoContainer.getComponentInstance((Object)(class$org$picocontainer$defaults$IllegalAccessExceptionThrowing == null ? (class$org$picocontainer$defaults$IllegalAccessExceptionThrowing = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.IllegalAccessExceptionThrowing")) : class$org$picocontainer$defaults$IllegalAccessExceptionThrowing));
            ConstructorInjectionComponentAdapterTestCase.fail();
        }
        catch (PicoInitializationException e) {
            ConstructorInjectionComponentAdapterTestCase.assertTrue((e.getCause().getMessage().indexOf((class$org$picocontainer$defaults$IllegalAccessExceptionThrowing == null ? (class$org$picocontainer$defaults$IllegalAccessExceptionThrowing = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.IllegalAccessExceptionThrowing")) : class$org$picocontainer$defaults$IllegalAccessExceptionThrowing).getName()) > 0 ? 1 : 0) != 0);
        }
    }

    public void testShouldBeAbleToInstantiateNonPublicClassesWithNonPublicConstructors() {
        DefaultPicoContainer pico = new DefaultPicoContainer((ComponentAdapterFactory)new ConstructorInjectionComponentAdapterFactory(true));
        pico.registerComponentImplementation(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$Private == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$Private = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$Private")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$Private);
        pico.registerComponentImplementation(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$NotYourBusiness == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$NotYourBusiness = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$NotYourBusiness")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$NotYourBusiness);
        ConstructorInjectionComponentAdapterTestCase.assertNotNull((Object)pico.getComponentInstance((Object)(class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$NotYourBusiness == null ? (class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$NotYourBusiness = ConstructorInjectionComponentAdapterTestCase.class$("org.picocontainer.defaults.ConstructorInjectionComponentAdapterTestCase$NotYourBusiness")) : class$org$picocontainer$defaults$ConstructorInjectionComponentAdapterTestCase$NotYourBusiness)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NotYourBusiness {
        private NotYourBusiness(Private aPrivate) {
            Assert.assertNotNull((Object)aPrivate);
        }
    }

    private static class Private {
        private Private() {
        }
    }

    public static class D {
        public D(A a) {
        }
    }

    public static class C2 {
        public C2(C1 i1) {
            Assert.fail((String)"verification should not instantiate");
        }
    }

    public static class C1 {
        public C1(C2 c2) {
            Assert.fail((String)"verification should not instantiate");
        }
    }

    public static class B {
        public B(A a) {
            Assert.fail((String)"verification should not instantiate");
        }
    }

    public static class A {
        public A() {
            Assert.fail((String)"verification should not instantiate");
        }
    }

    public static class TransientComponent {
        private Service service;

        public TransientComponent(Service service) {
            this.service = service;
        }
    }

    public static class Service {
    }
}

