/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api;

import com.pcloud.networking.api.ApiComposer;
import com.pcloud.networking.api.ApiResponse;
import com.pcloud.networking.api.Call;
import com.pcloud.networking.api.CallAdapter;
import com.pcloud.networking.api.MultiCall;
import com.pcloud.utils.Types;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class DirectCallAdapter {
    static final DirectCallAdapterFactory FACTORY = new DirectCallAdapterFactory();

    DirectCallAdapter() {
    }

    static class DirectCallAdapterFactory
    extends CallAdapter.Factory {
        DirectCallAdapterFactory() {
        }

        @Override
        public CallAdapter<?, ?> get(ApiComposer apiComposer, Method method) {
            final Class returnType = Types.getRawType((Type)method.getGenericReturnType());
            if (!ApiResponse.class.isAssignableFrom(returnType)) {
                return null;
            }
            return new CallAdapter<Object, Object>(){

                @Override
                public Type responseType() {
                    return returnType;
                }

                @Override
                public Object adapt(Call<Object> call) throws IOException {
                    return call.execute();
                }

                @Override
                public Object adapt(MultiCall<?, Object> call) throws IOException {
                    return call.execute();
                }
            };
        }
    }
}

