/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api;

import com.pcloud.networking.api.ApiClientMultiCall;
import com.pcloud.networking.api.ApiComposer;
import com.pcloud.networking.api.ApiMethod;
import com.pcloud.networking.api.CallAdapter;
import com.pcloud.networking.api.DataApiResponse;
import com.pcloud.networking.api.Parameter;
import com.pcloud.networking.api.RequestAdapter;
import com.pcloud.networking.api.RequestBody;
import com.pcloud.networking.api.RequestData;
import com.pcloud.networking.api.ResponseAdapter;
import com.pcloud.networking.client.MultiCall;
import com.pcloud.networking.client.Request;
import com.pcloud.utils.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MultiCallWrappedApiMethod<T, R>
extends ApiMethod<R> {
    static final ApiMethod.Factory FACTORY = new Factory();
    private String apiMethodName;
    private RequestContainerAdapter<Object, T> argumentsRequestContainerAdapter;
    private RequestAdapter requestAdapter;
    private ResponseAdapter<R> returnTypeAdapter;
    private CallAdapter callAdapter;

    private MultiCallWrappedApiMethod(String apiMethodName, RequestContainerAdapter<Object, T> argumentsRequestContainerAdapter, RequestAdapter requestAdapter, ResponseAdapter<R> returnTypeAdapter, CallAdapter callAdapter) {
        this.apiMethodName = apiMethodName;
        this.argumentsRequestContainerAdapter = argumentsRequestContainerAdapter;
        this.requestAdapter = requestAdapter;
        this.returnTypeAdapter = returnTypeAdapter;
        this.callAdapter = callAdapter;
    }

    @Override
    public R invoke(ApiComposer apiComposer, Object[] args) throws IOException {
        List<T> requests = this.argumentsRequestContainerAdapter.convert(args[0]);
        if (requests == null) {
            throw new IllegalArgumentException("The requests container cannot be null!");
        }
        ArrayList<Request> rawRequests = new ArrayList<Request>(requests.size());
        Request.Builder builder = Request.create().methodName(this.apiMethodName);
        for (T request : requests) {
            this.requestAdapter.adapt(builder, request);
            rawRequests.add(builder.build());
        }
        MultiCall rawCall = apiComposer.apiClient().newCall(rawRequests);
        return this.callAdapter.adapt(new ApiClientMultiCall<T, R>(apiComposer, rawCall, this.returnTypeAdapter, requests));
    }

    private static class Factory
    extends ApiMethod.Factory {
        private Factory() {
        }

        @Override
        public ApiMethod<?> create(ApiComposer composer, Method method, Type[] argumentTypes, Annotation[][] argumentAnnotations) {
            if (argumentTypes.length == 0) {
                return null;
            }
            Type requestContainerType = argumentTypes[0];
            String apiMethodName = Factory.parseMethodNameAnnotation(method);
            if (!Factory.hasRequestBodyAnnotation(argumentAnnotations) || !Factory.hasValidRequestContainerType(requestContainerType)) {
                return null;
            }
            Factory.checkArgumentAnnotations(method, argumentAnnotations);
            RequestContainerAdapter containerAdapter = Factory.getContainerAdapter(method, requestContainerType);
            RequestAdapter requestAdapter = Factory.getRequestAdapter(composer, method, new Type[]{containerAdapter.requestType()}, argumentAnnotations);
            CallAdapter<?, ?> callAdapter = composer.nextCallAdapter(method);
            Class innerReturnType = Types.getRawType((Type)callAdapter.responseType());
            if (!Factory.isAllowedResponseType(innerReturnType)) {
                return null;
            }
            if (DataApiResponse.class.isAssignableFrom(innerReturnType)) {
                throw Factory.apiMethodError(method, "Return types assignable from '%s' are not supported for MultiCall<>- returning API methods.", DataApiResponse.class);
            }
            ResponseAdapter returnTypeAdapter = Factory.getResponseAdapter(composer, method, innerReturnType);
            return new MultiCallWrappedApiMethod(apiMethodName, containerAdapter, requestAdapter, returnTypeAdapter, callAdapter);
        }

        private static boolean hasValidRequestContainerType(Type requestContainerType) {
            return Types.arrayComponentType((Type)requestContainerType) != null || List.class.isAssignableFrom(Types.getRawType((Type)requestContainerType));
        }

        private static <T> RequestContainerAdapter<?, T> getContainerAdapter(Method method, Type requestContainerType) {
            RequestContainerAdapter containerAdapter;
            Type elementType = Types.arrayComponentType((Type)requestContainerType);
            if (elementType != null) {
                final Type actualRequestType = elementType;
                containerAdapter = new RequestContainerAdapter<T[], T>(){

                    @Override
                    public Type requestType() {
                        return actualRequestType;
                    }

                    @Override
                    public List<T> convert(T[] requestsContainer) {
                        if (requestsContainer == null) {
                            throw new IllegalArgumentException("The requests container cannot be null!");
                        }
                        return Arrays.asList(requestsContainer);
                    }
                };
            } else if (List.class.isAssignableFrom(Types.getRawType((Type)requestContainerType))) {
                if (!(requestContainerType instanceof ParameterizedType)) {
                    throw new IllegalStateException("Requests List type must be parameterized as List<Foo> or List<? extends Foo>");
                }
                final Type actualRequestType = Types.getParameterUpperBound((int)0, (Type)requestContainerType);
                containerAdapter = new RequestContainerAdapter<List<T>, T>(){

                    @Override
                    public Type requestType() {
                        return actualRequestType;
                    }

                    @Override
                    public List<T> convert(List<T> requestsContainer) {
                        return requestsContainer;
                    }
                };
            } else {
                throw Factory.apiMethodError(method, "MultiCall-returning methods should have a single, @RequestBody-annotated argument , either an array or a java.util.List<> of the Request type.", new Object[0]);
            }
            return containerAdapter;
        }

        private static boolean hasRequestBodyAnnotation(Annotation[][] annotations) {
            if (annotations.length == 1) {
                Annotation[] containerAnnotations;
                for (Annotation annotation : containerAnnotations = annotations[0]) {
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    if (annotationType != RequestBody.class) continue;
                    return true;
                }
            }
            return false;
        }

        private static void checkArgumentAnnotations(Method method, Annotation[][] annotations) {
            Annotation[] containerAnnotations;
            for (Annotation annotation : containerAnnotations = annotations[0]) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType == Parameter.class) {
                    throw Factory.apiMethodError(method, "MultiCall methods cannot have @Parameter-annotated arguments.", new Object[0]);
                }
                if (annotationType != RequestData.class) continue;
                throw Factory.apiMethodError(method, "MultiCall methods cannot have @RequestData-annotated arguments.", new Object[0]);
            }
        }
    }

    private static interface RequestContainerAdapter<T, R> {
        public Type requestType();

        public List<R> convert(T var1);
    }
}

