/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api;

import com.pcloud.networking.api.ApiClientCall;
import com.pcloud.networking.api.ApiComposer;
import com.pcloud.networking.api.ApiMethod;
import com.pcloud.networking.api.RequestAdapter;
import com.pcloud.networking.api.ResponseAdapter;
import com.pcloud.networking.client.Call;
import com.pcloud.networking.client.Request;
import com.pcloud.utils.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class DirectApiMethod<T>
extends ApiMethod<T> {
    static final ApiMethod.Factory FACTORY = new Factory();
    private String apiMethodName;
    private RequestAdapter requestAdapter;
    private ResponseAdapter<T> responseAdapter;

    private DirectApiMethod(String apiMethodName, RequestAdapter requestAdapter, ResponseAdapter<T> responseAdapter) {
        this.apiMethodName = apiMethodName;
        this.requestAdapter = requestAdapter;
        this.responseAdapter = responseAdapter;
    }

    @Override
    public T invoke(ApiComposer apiComposer, Object[] args) throws IOException {
        Request.Builder builder = Request.create().methodName(this.apiMethodName);
        this.requestAdapter.adapt(builder, args);
        Call rawCall = apiComposer.apiClient().newCall(builder.build());
        ApiClientCall<T> call = new ApiClientCall<T>(apiComposer, rawCall, this.responseAdapter);
        return call.execute();
    }

    private static class Factory
    extends ApiMethod.Factory {
        private Factory() {
        }

        @Override
        public ApiMethod<?> create(ApiComposer composer, Method method, Type[] argumentTypes, Annotation[][] argumentAnnotations) {
            Class returnType = Types.getRawType(method.getReturnType());
            if (!Factory.isAllowedResponseType(returnType)) {
                return null;
            }
            String apiMethodName = Factory.parseMethodNameAnnotation(method);
            Factory.checkMethodThrowsExceptions(method, new Type[]{IOException.class});
            RequestAdapter requestAdapter = Factory.getRequestAdapter(composer, method, argumentTypes, argumentAnnotations);
            ResponseAdapter returnTypeAdapter = Factory.getResponseAdapter(composer, method, returnType);
            return new DirectApiMethod(apiMethodName, requestAdapter, returnTypeAdapter);
        }
    }
}

