/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api;

import com.pcloud.networking.api.ApiMethod;
import com.pcloud.networking.api.CallAdapter;
import com.pcloud.networking.api.CallWrappedApiMethod;
import com.pcloud.networking.api.CallWrappedCallAdapter;
import com.pcloud.networking.api.DirectApiMethod;
import com.pcloud.networking.api.DirectCallAdapter;
import com.pcloud.networking.api.MultiCallWrappedApiMethod;
import com.pcloud.networking.api.ResponseInterceptor;
import com.pcloud.networking.client.PCloudAPIClient;
import com.pcloud.networking.serialization.Transformer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ApiComposer {
    private static final List<ApiMethod.Factory> BUILT_IN_API_METHOD_FACTORIES = Arrays.asList(MultiCallWrappedApiMethod.FACTORY, CallWrappedApiMethod.FACTORY, DirectApiMethod.FACTORY);
    private static final List<CallAdapter.Factory> BUILD_IN_CALL_ADAPTER_FACTORIES = Arrays.asList(CallWrappedCallAdapter.FACTORY, DirectCallAdapter.FACTORY);
    private PCloudAPIClient apiClient;
    private Transformer transformer;
    private List<ResponseInterceptor> interceptors;
    private boolean loadEagerly;
    private Map<Method, ApiMethod<?>> apiMethodsCache = new ConcurrentHashMap();
    private List<ApiMethod.Factory> factories = new ArrayList<ApiMethod.Factory>(BUILT_IN_API_METHOD_FACTORIES);
    private List<CallAdapter.Factory> callAdapterFactories = new ArrayList<CallAdapter.Factory>(BUILD_IN_CALL_ADAPTER_FACTORIES);

    public static Builder create() {
        return new Builder();
    }

    private ApiComposer(Builder builder) {
        if (builder.apiClient == null) {
            throw new IllegalArgumentException("PCloudAPIClient instance cannot be null.");
        }
        this.apiClient = builder.apiClient;
        this.transformer = builder.transformer != null ? builder.transformer : Transformer.create().build();
        this.interceptors = new ArrayList<ResponseInterceptor>(builder.interceptors);
        this.callAdapterFactories.addAll(builder.callAdapterFactories);
        this.loadEagerly = builder.loadEagerly;
    }

    public Transformer transformer() {
        return this.transformer;
    }

    public PCloudAPIClient apiClient() {
        return this.apiClient;
    }

    public List<ResponseInterceptor> interceptors() {
        return this.interceptors;
    }

    public <T> T compose(Class<T> apiType) {
        ApiComposer.validateApiInterface(apiType);
        if (this.loadEagerly) {
            Method[] methods;
            for (Method method : methods = apiType.getDeclaredMethods()) {
                this.loadApiMethod(method);
            }
        }
        return (T)Proxy.newProxyInstance(apiType.getClassLoader(), new Class[]{apiType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                ApiMethod apiMethod = ApiComposer.this.loadApiMethod(method);
                return apiMethod.invoke(ApiComposer.this, args);
            }
        });
    }

    CallAdapter<?, ?> nextCallAdapter(Method method) {
        CallAdapter.Factory adapterFactory;
        CallAdapter<?, ?> callAdapter = null;
        Iterator<CallAdapter.Factory> iterator = this.callAdapterFactories.iterator();
        while (iterator.hasNext() && (callAdapter = (adapterFactory = iterator.next()).get(this, method)) == null) {
        }
        return callAdapter;
    }

    private ApiMethod<?> loadApiMethod(Method javaMethod) {
        ApiMethod<?> apiMethod = this.apiMethodsCache.get(javaMethod);
        if (apiMethod == null) {
            apiMethod = this.createApiMethod(javaMethod);
            if (apiMethod == null) {
                throw ApiMethod.Factory.apiMethodError(javaMethod, "Cannot adapt method, return type '%s' is not supported.", javaMethod.getReturnType().getName());
            }
            this.apiMethodsCache.put(javaMethod, apiMethod);
        }
        return apiMethod;
    }

    private ApiMethod<?> createApiMethod(Method javaMethod) {
        ApiMethod.Factory factory;
        ApiMethod<?> apiMethod = null;
        Type[] argumentTypes = javaMethod.getGenericParameterTypes();
        Annotation[][] argumentAnnotations = javaMethod.getParameterAnnotations();
        Iterator<ApiMethod.Factory> iterator = this.factories.iterator();
        while (iterator.hasNext() && (apiMethod = (factory = iterator.next()).create(this, javaMethod, argumentTypes, argumentAnnotations)) == null) {
        }
        return apiMethod;
    }

    private static <T> void validateApiInterface(Class<T> apiInterface) {
        if (!apiInterface.isInterface()) {
            throw new IllegalArgumentException("API declaration '" + apiInterface + "' is not an interface.");
        }
        if (apiInterface.getInterfaces().length > 0) {
            throw new IllegalArgumentException("API declarations must not extend other interfaces.");
        }
    }

    public Builder newBuilder() {
        this.callAdapterFactories.removeAll(BUILD_IN_CALL_ADAPTER_FACTORIES);
        return new Builder(this);
    }

    public static class Builder {
        private PCloudAPIClient apiClient;
        private Transformer transformer;
        private List<ResponseInterceptor> interceptors = new LinkedList<ResponseInterceptor>();
        private List<CallAdapter.Factory> callAdapterFactories = new ArrayList<CallAdapter.Factory>();
        private boolean loadEagerly;

        private Builder() {
        }

        private Builder(ApiComposer composer) {
            this.apiClient = composer.apiClient;
            this.transformer = composer.transformer;
            this.interceptors = new ArrayList<ResponseInterceptor>(composer.interceptors);
            this.callAdapterFactories = new ArrayList<CallAdapter.Factory>(composer.callAdapterFactories);
        }

        public Builder apiClient(PCloudAPIClient apiClient) {
            if (apiClient == null) {
                throw new IllegalArgumentException("PCloudAPIClient argument cannot be null.");
            }
            this.apiClient = apiClient;
            return this;
        }

        public Builder transformer(Transformer transformer) {
            if (transformer == null) {
                throw new IllegalArgumentException("Transformer argument cannot be null.");
            }
            this.transformer = transformer;
            return this;
        }

        public Builder addInterceptor(ResponseInterceptor interceptor) {
            if (interceptor == null) {
                throw new IllegalArgumentException("ResponseInterceptor argument cannot be null.");
            }
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder removeInterceptor(ResponseInterceptor interceptor) {
            if (interceptor == null) {
                throw new IllegalArgumentException("ResponseInterceptor argument cannot be null.");
            }
            this.interceptors.remove(interceptor);
            return this;
        }

        public Builder removeInterceptors(Collection<ResponseInterceptor> interceptors) {
            if (interceptors == null) {
                throw new IllegalArgumentException("ResponseInterceptor collection argument cannot be null.");
            }
            for (ResponseInterceptor r : interceptors) {
                this.removeInterceptor(r);
            }
            return this;
        }

        public Builder addInterceptors(Collection<ResponseInterceptor> interceptors) {
            if (interceptors == null) {
                throw new IllegalArgumentException("ResponseInterceptor collection argument cannot be null.");
            }
            for (ResponseInterceptor r : interceptors) {
                this.addInterceptor(r);
            }
            return this;
        }

        public Builder addAdapterFactory(CallAdapter.Factory adapterFactory) {
            if (adapterFactory == null) {
                throw new IllegalArgumentException("CallAdapter.Factory argument cannot be null.");
            }
            this.callAdapterFactories.add(adapterFactory);
            return this;
        }

        public Builder addAdapterFactories(CallAdapter.Factory ... adapterFactories) {
            if (adapterFactories == null) {
                throw new IllegalArgumentException("CallAdapter.Factory collection argument cannot be null.");
            }
            return this.addAdapterFactories(Arrays.asList(adapterFactories));
        }

        public Builder addAdapterFactories(Iterable<CallAdapter.Factory> adapterFactories) {
            if (adapterFactories == null) {
                throw new IllegalArgumentException("CallAdapter.Factory collection argument cannot be null.");
            }
            for (CallAdapter.Factory factory : adapterFactories) {
                this.addAdapterFactory(factory);
            }
            return this;
        }

        public Builder loadEagerly(boolean loadEagerly) {
            this.loadEagerly = loadEagerly;
            return this;
        }

        public ApiComposer create() {
            return new ApiComposer(this);
        }
    }
}

