/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api;

import com.pcloud.networking.api.ApiComposer;
import com.pcloud.networking.api.Call;
import com.pcloud.networking.api.CallAdapter;
import com.pcloud.networking.api.MultiCall;
import com.pcloud.utils.Types;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class CallWrappedCallAdapter {
    static final CallWrappedCallAdapterFactory FACTORY = new CallWrappedCallAdapterFactory();

    CallWrappedCallAdapter() {
    }

    static class CallWrappedCallAdapterFactory
    extends CallAdapter.Factory {
        CallWrappedCallAdapterFactory() {
        }

        @Override
        public CallAdapter<?, ?> get(ApiComposer apiComposer, Method method) {
            Type responseType;
            Type returnType = method.getGenericReturnType();
            Class rawType = Types.getRawType((Type)returnType);
            if (rawType == Call.class) {
                responseType = this.getParameterUpperBound(0, returnType);
            } else if (rawType == MultiCall.class) {
                responseType = this.getParameterUpperBound(1, returnType);
            } else {
                return null;
            }
            return new CallAdapter<Object, Object>(){

                @Override
                public Type responseType() {
                    return responseType;
                }

                @Override
                public Call<?> adapt(Call<Object> call) {
                    return call;
                }

                @Override
                public MultiCall<?, ?> adapt(MultiCall<?, Object> call) {
                    return call;
                }
            };
        }
    }
}

