/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api;

import com.pcloud.networking.api.ApiComposer;
import com.pcloud.networking.api.ApiResponse;
import com.pcloud.networking.api.ApiResponseAdapter;
import com.pcloud.networking.api.ArgumentAdapter;
import com.pcloud.networking.api.ArgumentAdapters;
import com.pcloud.networking.api.DataApiResponse;
import com.pcloud.networking.api.DataApiResponseAdapter;
import com.pcloud.networking.api.DefaultRequestAdapter;
import com.pcloud.networking.api.Method;
import com.pcloud.networking.api.Parameter;
import com.pcloud.networking.api.RequestAdapter;
import com.pcloud.networking.api.RequestBody;
import com.pcloud.networking.api.RequestData;
import com.pcloud.networking.api.ResponseAdapter;
import com.pcloud.networking.api.ResponseBodyAdapter;
import com.pcloud.networking.client.ResponseBody;
import com.pcloud.networking.serialization.TypeAdapter;
import com.pcloud.utils.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

abstract class ApiMethod<T> {
    ApiMethod() {
    }

    abstract T invoke(ApiComposer var1, Object[] var2) throws IOException;

    static abstract class Factory {
        Factory() {
        }

        abstract ApiMethod<?> create(ApiComposer var1, java.lang.reflect.Method var2, Type[] var3, Annotation[][] var4);

        protected static String parseMethodNameAnnotation(java.lang.reflect.Method javaMethod) {
            Method methodName = javaMethod.getAnnotation(Method.class);
            if (methodName == null) {
                throw Factory.apiMethodError(javaMethod, "Method must be annotated with the @Method annotation", new Object[0]);
            }
            if (methodName.value().equals("")) {
                throw Factory.apiMethodError(javaMethod, "API method name cannot be empty.", new Object[0]);
            }
            return methodName.value();
        }

        protected static boolean isAllowedResponseType(Class<?> type) {
            return ApiResponse.class.isAssignableFrom(type) || type == ResponseBody.class;
        }

        protected static boolean isAllowedResponseType(Type type) {
            return Factory.isAllowedResponseType(Types.getRawType((Type)type));
        }

        protected static ResponseAdapter<?> getResponseAdapter(ApiComposer composer, java.lang.reflect.Method method, Type returnType) {
            return Factory.getResponseAdapter(composer, method, Types.getRawType((Type)returnType));
        }

        protected static <T> ResponseAdapter<T> getResponseAdapter(ApiComposer composer, java.lang.reflect.Method method, Class<T> returnType) {
            if (ApiResponse.class.isAssignableFrom(returnType)) {
                TypeAdapter<T> typeAdapter = Factory.getTypeAdapter(composer, method, returnType);
                if (DataApiResponse.class.isAssignableFrom(returnType)) {
                    return new DataApiResponseAdapter(typeAdapter);
                }
                return new ApiResponseAdapter(typeAdapter);
            }
            if (returnType == ResponseBody.class) {
                return new ResponseBodyAdapter();
            }
            throw Factory.apiMethodError(method, "Return type '%s' is not supported, must be or extend from %s, or be '%s'", returnType, Arrays.asList(DataApiResponse.class, ApiResponse.class), ResponseBody.class);
        }

        protected static RequestAdapter getRequestAdapter(ApiComposer composer, java.lang.reflect.Method method, Type[] parameterTypes, Annotation[][] annotations) {
            int argumentCount = parameterTypes.length;
            boolean hasDataParameter = false;
            ArgumentAdapter[] argumentAdapters = new ArgumentAdapter[argumentCount];
            for (int index = 0; index < argumentCount; ++index) {
                Annotation[] argumentAnnotations = annotations[index];
                Type parameterType = parameterTypes[index];
                ArgumentAdapter resolvedAdapter = null;
                for (Annotation annotation : argumentAnnotations) {
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    if (annotationType == RequestBody.class) {
                        TypeAdapter typeAdapter = Factory.getTypeAdapter(composer, method, parameterType);
                        resolvedAdapter = ArgumentAdapters.requestBody(typeAdapter);
                        continue;
                    }
                    if (annotationType == Parameter.class) {
                        String name = ((Parameter)annotation).value();
                        if (name.equals("")) {
                            throw Factory.apiMethodError(method, "@Parameter-annotated methods cannot have an empty parameter name.", new Object[0]);
                        }
                        if (!Factory.parameterAnnotatedTypeIsSerializable(parameterType)) {
                            throw new IllegalArgumentException("Cannot create adapt method argument of type '" + parameterType + "'," + " @Parameter-annotated arguments must be of type long, int, short, byte, boolean " + "or boxed equivalents, String or an enum.");
                        }
                        TypeAdapter typeAdapter = Factory.getTypeAdapter(composer, method, parameterType);
                        resolvedAdapter = ArgumentAdapters.parameter(name, typeAdapter);
                        continue;
                    }
                    if (annotationType != RequestData.class) continue;
                    if (hasDataParameter) {
                        throw Factory.apiMethodError(method, "API method cannot have more than one parameter annotated with @RequestData", new Object[0]);
                    }
                    hasDataParameter = true;
                    resolvedAdapter = ArgumentAdapters.dataSource(parameterType);
                }
                if (resolvedAdapter == null) {
                    throw Factory.apiMethodError(method, "Each API method parameter must be annotated with one of %s", Arrays.asList(RequestBody.class, Parameter.class, RequestData.class));
                }
                argumentAdapters[index] = resolvedAdapter;
            }
            return new DefaultRequestAdapter(argumentAdapters);
        }

        protected static <T> TypeAdapter<T> getTypeAdapter(ApiComposer composer, java.lang.reflect.Method method, Type parameterType) {
            TypeAdapter typeAdapter = composer.transformer().getTypeAdapter(parameterType);
            if (typeAdapter == null) {
                throw Factory.apiMethodError(method, "Cannot find a suitable TypeAdapter for argument of type '%s'.", parameterType);
            }
            return typeAdapter;
        }

        protected static void checkMethodThrowsExceptions(java.lang.reflect.Method method, Type ... exceptionTypes) {
            List<Type> expectedExceptions;
            List<Class<Type>> declaredExceptions = Arrays.asList(method.getExceptionTypes());
            if (!declaredExceptions.containsAll(expectedExceptions = Arrays.asList(exceptionTypes))) {
                throw Factory.apiMethodError(method, "Method should declare that it throws %s.", expectedExceptions);
            }
        }

        protected static RuntimeException apiMethodError(java.lang.reflect.Method method, Throwable cause, String message, Object ... args) {
            message = String.format(message, args);
            return new IllegalArgumentException(message + "\n for method " + method.getDeclaringClass().getSimpleName() + "." + method.getName(), cause);
        }

        protected static RuntimeException apiMethodError(java.lang.reflect.Method method, String message, Object ... args) {
            return Factory.apiMethodError(method, null, message, args);
        }

        static boolean parameterAnnotatedTypeIsSerializable(Type type) {
            return type == Long.class || type == Long.TYPE || type == Integer.class || type == Integer.TYPE || type == Short.class || type == Short.TYPE || type == Byte.class || type == Byte.TYPE || type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE || type == String.class || Types.getRawType((Type)type).isEnum() || type == Boolean.class || type == Boolean.TYPE;
        }
    }
}

