/*
 * Copyright (c) 2017 pCloud AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.pcloud.networking.api;

import com.pcloud.utils.Types;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

/**
 * Created by Dimitard on 25.4.2017 г..
 */
public interface CallAdapter<T, R> {

    Type responseType();

    R adapt(Call<T> call) throws IOException;

    R adapt(MultiCall<?, T> call) throws IOException;

    abstract class Factory {
        /**
         * Returns a call adapter for interface methods that return {@code returnType}, or null if it
         * cannot be handled by this factory.
         */
        public abstract CallAdapter<?, ?> get(ApiComposer apiComposer, Method method);

        protected Type getParameterUpperBound(int index, Type type) {
            return Types.getParameterUpperBound(index, type);
        }
    }
}
