/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api;

import com.pcloud.networking.api.ApiComposer;
import com.pcloud.networking.api.ApiResponse;
import com.pcloud.networking.api.Interactor;
import com.pcloud.networking.api.MultiCall;
import com.pcloud.networking.api.MultiCallback;
import com.pcloud.networking.api.ResponseAdapter;
import com.pcloud.networking.api.ResponseInterceptor;
import com.pcloud.networking.client.MultiResponse;
import com.pcloud.networking.client.Request;
import com.pcloud.networking.client.Response;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ApiClientMultiCall<T, R>
implements MultiCall<T, R> {
    private ApiComposer apiComposer;
    private com.pcloud.networking.client.MultiCall rawCall;
    private ResponseAdapter<R> responseAdapter;
    private List<T> requests;

    ApiClientMultiCall(ApiComposer apiComposer, com.pcloud.networking.client.MultiCall rawCall, ResponseAdapter<R> responseAdapter, List<T> requests) {
        this.apiComposer = apiComposer;
        this.rawCall = rawCall;
        this.responseAdapter = responseAdapter;
        this.requests = Collections.unmodifiableList(requests);
    }

    @Override
    public List<T> requests() {
        return this.requests;
    }

    @Override
    public List<R> execute() throws IOException {
        try {
            return this.adapt(this.rawCall.execute());
        }
        catch (IOException e) {
            this.apiComposer.notifyIOError(((Request)this.rawCall.requests().get(0)).endpoint(), e);
            throw e;
        }
    }

    @Override
    public List<R> enqueueAndWait() throws IOException, InterruptedException {
        return this.adapt(this.rawCall.enqueueAndWait());
    }

    @Override
    public List<R> enqueueAndWait(long timeout, TimeUnit timeUnit) throws IOException, InterruptedException, TimeoutException {
        return this.adapt(this.rawCall.enqueueAndWait(timeout, timeUnit));
    }

    @Override
    public void enqueue(final MultiCallback<T, R> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback argument cannot be null.");
        }
        int responseCount = this.requests.size();
        final ArrayList results = new ArrayList(responseCount);
        ApiClientMultiCall.growSize(results, responseCount);
        this.rawCall.enqueue(new com.pcloud.networking.client.MultiCallback(){

            public void onFailure(com.pcloud.networking.client.MultiCall call, IOException e, List<Response> completedResponses) {
                ApiClientMultiCall.this.apiComposer.notifyIOError(((Request)ApiClientMultiCall.this.rawCall.requests().get(0)).endpoint(), e);
                if (!ApiClientMultiCall.this.isCancelled()) {
                    callback.onFailure(ApiClientMultiCall.this, e, Collections.unmodifiableList(results));
                }
            }

            public void onResponse(com.pcloud.networking.client.MultiCall call, int key, Response response) throws IOException {
                if (!ApiClientMultiCall.this.isCancelled()) {
                    try {
                        Object result = ApiClientMultiCall.this.adapt(response);
                        results.set(key, result);
                        callback.onResponse(ApiClientMultiCall.this, key, result);
                    }
                    catch (IOException e) {
                        ApiClientMultiCall.this.apiComposer.notifyIOError(((Request)call.requests().get(key)).endpoint(), e);
                        callback.onFailure(ApiClientMultiCall.this, e, results);
                        ApiClientMultiCall.this.rawCall.cancel();
                    }
                }
            }

            public void onComplete(com.pcloud.networking.client.MultiCall call, MultiResponse response) throws IOException {
                if (!ApiClientMultiCall.this.isCancelled()) {
                    callback.onComplete(ApiClientMultiCall.this, Collections.unmodifiableList(results));
                }
            }
        });
    }

    @Override
    public Interactor<R> start() {
        final com.pcloud.networking.client.Interactor rawInteractor = this.rawCall.start();
        return new Interactor<R>(){

            @Override
            public boolean hasMoreRequests() {
                return rawInteractor.hasMoreRequests();
            }

            @Override
            public int submitRequests(int count) throws IOException {
                return rawInteractor.submitRequests(count);
            }

            @Override
            public boolean hasNextResponse() {
                return rawInteractor.hasNextResponse();
            }

            @Override
            public R nextResponse() throws IOException {
                return ApiClientMultiCall.this.adapt(rawInteractor.nextResponse());
            }

            @Override
            public void close() {
                rawInteractor.close();
            }
        };
    }

    @Override
    public boolean isExecuted() {
        return this.rawCall.isExecuted();
    }

    @Override
    public void cancel() {
        this.rawCall.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.rawCall.isCancelled();
    }

    @Override
    public MultiCall<T, R> clone() {
        return new ApiClientMultiCall<T, R>(this.apiComposer, this.rawCall, this.responseAdapter, this.requests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<R> adapt(MultiResponse multiResponse) throws IOException {
        try {
            int responseCount = multiResponse.responses().size();
            ArrayList<R> responses = new ArrayList<R>(responseCount);
            for (Response response : multiResponse.responses()) {
                responses.add(this.adapt(response));
            }
            ArrayList<R> arrayList = responses;
            return arrayList;
        }
        finally {
            IOUtils.closeQuietly((Closeable)multiResponse);
        }
    }

    private R adapt(Response response) throws IOException {
        if (this.isCancelled()) {
            throw new IOException("Cancelled");
        }
        R result = this.responseAdapter.adapt(response);
        if (result instanceof ApiResponse) {
            List<ResponseInterceptor> interceptors = this.apiComposer.interceptors();
            for (ResponseInterceptor interceptor : interceptors) {
                try {
                    interceptor.intercept((ApiResponse)result);
                }
                catch (Exception e) {
                    IOUtils.closeQuietly((Closeable)response);
                    throw new RuntimeException(String.format("Error while calling ResponseInterceptor of type '%s'", interceptor.getClass()), e);
                }
            }
        }
        return result;
    }

    private static void growSize(List<?> list, int count) {
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                list.add(null);
            }
        }
    }
}

