/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api;

import com.pcloud.networking.api.ApiClientCall;
import com.pcloud.networking.api.ApiComposer;
import com.pcloud.networking.api.ApiMethod;
import com.pcloud.networking.api.CallAdapter;
import com.pcloud.networking.api.RequestAdapter;
import com.pcloud.networking.api.ResponseAdapter;
import com.pcloud.networking.client.Call;
import com.pcloud.networking.client.Request;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class CallWrappedApiMethod<T, R>
extends ApiMethod<R> {
    static final ApiMethod.Factory FACTORY = new Factory();
    private String apiMethodName;
    private RequestAdapter requestAdapter;
    private ResponseAdapter<T> returnTypeAdapter;
    private CallAdapter callAdapter;

    private CallWrappedApiMethod(String apiMethodName, RequestAdapter requestAdapter, ResponseAdapter<T> returnTypeAdapter, CallAdapter callAdapter) {
        this.apiMethodName = apiMethodName;
        this.requestAdapter = requestAdapter;
        this.returnTypeAdapter = returnTypeAdapter;
        this.callAdapter = callAdapter;
    }

    @Override
    public R invoke(ApiComposer apiComposer, Object[] args) throws IOException {
        Request.Builder builder = Request.create().endpoint(apiComposer.endpointProvider().endpoint()).methodName(this.apiMethodName);
        this.requestAdapter.adapt(builder, args);
        Call rawCall = apiComposer.apiClient().newCall(builder.build());
        return this.callAdapter.adapt(new ApiClientCall<T>(apiComposer, rawCall, this.returnTypeAdapter));
    }

    private static class Factory
    extends ApiMethod.Factory {
        private Factory() {
        }

        @Override
        public ApiMethod<?> create(ApiComposer composer, Method method, Type[] argumentTypes, Annotation[][] argumentAnnotations) {
            String apiMethodName = Factory.parseMethodNameAnnotation(method);
            CallAdapter<?, ?> callAdapter = composer.nextCallAdapter(method);
            if (callAdapter == null) {
                return null;
            }
            Type adapterResponseType = callAdapter.responseType();
            if (!Factory.isAllowedResponseType(adapterResponseType)) {
                return null;
            }
            RequestAdapter requestAdapter = Factory.getRequestAdapter(composer, method, argumentTypes, argumentAnnotations);
            ResponseAdapter<?> returnTypeAdapter = Factory.getResponseAdapter(composer, method, adapterResponseType);
            return new CallWrappedApiMethod(apiMethodName, requestAdapter, returnTypeAdapter, callAdapter);
        }
    }
}

