/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api;

import com.pcloud.networking.api.ArgumentAdapter;
import com.pcloud.networking.client.Request;
import com.pcloud.networking.protocol.DataSource;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.networking.serialization.TypeAdapter;
import com.pcloud.utils.Types;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import okio.ByteString;

class ArgumentAdapters {
    private ArgumentAdapters() {
    }

    static <T> ArgumentAdapter<T> parameter(final String name, final TypeAdapter<T> adapter) {
        return new BodyWritingArgumentAdapter<T>(){

            @Override
            public void adapt(ProtocolWriter writer, T argValue) throws IOException {
                if (argValue == null) {
                    throw new IllegalArgumentException("The parameter cannot be null.");
                }
                writer.writeName(name);
                adapter.serialize(writer, argValue);
            }
        };
    }

    static <T> ArgumentAdapter<T> requestBody(final TypeAdapter<T> adapter) {
        return new BodyWritingArgumentAdapter<T>(){

            @Override
            public void adapt(ProtocolWriter writer, T argValue) throws IOException {
                if (argValue == null) {
                    throw new IllegalArgumentException("The RequestBody parameter cannot be null.");
                }
                adapter.serialize(writer, argValue);
            }
        };
    }

    static <T> ArgumentAdapter<T> dataSource(Type dataSourceType) {
        Class argType = Types.getRawType((Type)dataSourceType);
        if (DataSource.class.isAssignableFrom(argType)) {
            return new BuilderArgumentAdapter<T>(){

                @Override
                public void adapt(Request.Builder builder, T argValue) throws IOException {
                    builder.dataSource((DataSource)argValue);
                }
            };
        }
        if (File.class.isAssignableFrom(argType)) {
            return new BuilderArgumentAdapter<T>(){

                @Override
                public void adapt(Request.Builder builder, T argValue) throws IOException {
                    builder.dataSource(DataSource.create((File)((File)argValue)));
                }
            };
        }
        if (ByteString.class.isAssignableFrom(argType)) {
            return new BuilderArgumentAdapter<T>(){

                @Override
                public void adapt(Request.Builder builder, T argValue) throws IOException {
                    builder.dataSource(DataSource.create((ByteString)((ByteString)argValue)));
                }
            };
        }
        if (byte[].class == argType) {
            return new BuilderArgumentAdapter<T>(){

                @Override
                public void adapt(Request.Builder builder, T argValue) throws IOException {
                    builder.dataSource(DataSource.create((byte[])((byte[])argValue)));
                }
            };
        }
        throw new IllegalStateException("Cannot convert argument of type '" + argType + "' to DataSource.");
    }

    private static abstract class BuilderArgumentAdapter<T>
    implements ArgumentAdapter<T> {
        private BuilderArgumentAdapter() {
        }

        @Override
        public void adapt(ProtocolWriter writer, T argValue) throws IOException {
        }
    }

    private static abstract class BodyWritingArgumentAdapter<T>
    implements ArgumentAdapter<T> {
        private BodyWritingArgumentAdapter() {
        }

        @Override
        public void adapt(Request.Builder builder, T argValue) throws IOException {
        }
    }
}

