/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api;

import com.pcloud.networking.api.ApiComposer;
import com.pcloud.networking.api.ApiResponse;
import com.pcloud.networking.api.Call;
import com.pcloud.networking.api.Callback;
import com.pcloud.networking.api.ResponseAdapter;
import com.pcloud.networking.api.ResponseInterceptor;
import com.pcloud.networking.client.Response;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ApiClientCall<T>
implements Call<T> {
    private ApiComposer apiComposer;
    private com.pcloud.networking.client.Call rawCall;
    private ResponseAdapter<T> responseAdapter;

    ApiClientCall(ApiComposer apiComposer, com.pcloud.networking.client.Call rawCall, ResponseAdapter<T> responseAdapter) {
        this.apiComposer = apiComposer;
        this.rawCall = rawCall;
        this.responseAdapter = responseAdapter;
    }

    @Override
    public T execute() throws IOException {
        try {
            return this.adapt(this.rawCall.execute());
        }
        catch (IOException e) {
            this.apiComposer.notifyIOError(this.rawCall.request().endpoint(), e);
            throw e;
        }
    }

    @Override
    public void enqueue(final Callback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback argument cannot be null.");
        }
        this.rawCall.enqueue(new com.pcloud.networking.client.Callback(){

            public void onFailure(com.pcloud.networking.client.Call call, IOException e) {
                ApiClientCall.this.apiComposer.notifyIOError(call.request().endpoint(), e);
                if (!ApiClientCall.this.isCancelled()) {
                    callback.onFailure(ApiClientCall.this, e);
                }
            }

            public void onResponse(com.pcloud.networking.client.Call call, Response response) throws IOException {
                if (!ApiClientCall.this.isCancelled()) {
                    try {
                        callback.onResponse(ApiClientCall.this, ApiClientCall.this.adapt(response));
                    }
                    catch (IOException e) {
                        ApiClientCall.this.apiComposer.notifyIOError(call.request().endpoint(), e);
                        callback.onFailure(ApiClientCall.this, e);
                    }
                }
            }
        });
    }

    @Override
    public T enqueueAndWait() throws IOException, InterruptedException {
        return this.adapt(this.rawCall.enqueueAndWait());
    }

    @Override
    public T enqueueAndWait(long timeout, TimeUnit timeUnit) throws IOException, InterruptedException, TimeoutException {
        return this.adapt(this.rawCall.enqueueAndWait(timeout, timeUnit));
    }

    @Override
    public boolean isExecuted() {
        return this.rawCall.isExecuted();
    }

    @Override
    public void cancel() {
        this.rawCall.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.rawCall.isCancelled();
    }

    @Override
    public Call<T> clone() {
        return new ApiClientCall<T>(this.apiComposer, this.rawCall, this.responseAdapter);
    }

    protected T adapt(Response response) throws IOException {
        if (this.isCancelled()) {
            throw new IOException("Cancelled");
        }
        T result = this.responseAdapter.adapt(response);
        if (result instanceof ApiResponse) {
            List<ResponseInterceptor> interceptors = this.apiComposer.interceptors();
            for (ResponseInterceptor interceptor : interceptors) {
                try {
                    interceptor.intercept((ApiResponse)result);
                }
                catch (Exception e) {
                    IOUtils.closeQuietly((Closeable)response);
                    throw new RuntimeException(String.format("Error while calling ResponseInterceptor of type '%s'", interceptor.getClass()), e);
                }
            }
        }
        return result;
    }
}

