package paykunpay.yashoka.com.paykunpay_lib;

public class InterfaceContainer {
    private OnPaymentResult mListener;
    private static InterfaceContainer mInstance;
    private boolean mState;

    public interface OnPaymentResult{
        void paymentSuccessfully();
        void paymentFailed();
    }
    private InterfaceContainer() {}
    public static InterfaceContainer getInstance() {
        if(mInstance == null) {
            mInstance = new InterfaceContainer();
        }
        return mInstance;
    }
    public void setListener(OnPaymentResult listener) {
        mListener = listener;
    }
    public void changeState(boolean state) {
        if(mListener != null) {
            mState = state;
            notifyStateChange();
        }
    }

    public boolean getState() {
        return mState;
    }

    private void notifyStateChange() {
        mListener.paymentSuccessfully();
    }
}
