/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.plugin.aspectj;

import java.util.Iterator;
import java.util.List;
import org.apache.cactus.server.runner.XMLConstants;
import patterntesting.plugin.aspectj.AjcResult;

public class XMLFormatter
implements XMLConstants {
    public static String format(List ajcResults) {
        StringBuffer xml = new StringBuffer();
        XMLFormatter.generateHeader(xml);
        Iterator it = ajcResults.iterator();
        while (it.hasNext()) {
            AjcResult result = (AjcResult)it.next();
            XMLFormatter.generateError(xml, result);
        }
        XMLFormatter.generateFooter(xml);
        return xml.toString();
    }

    private static void generateHeader(StringBuffer buffer) {
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        buffer.append("<errors>");
    }

    private static void generateError(StringBuffer buffer, AjcResult result) {
        buffer.append("<error file=\"" + result.getFileName() + "\" " + "line" + "=\"" + result.getLine() + "\">");
        buffer.append(XMLFormatter.xmlEncode(result.getErrorMessage()));
        buffer.append("</error>");
    }

    private static void generateFooter(StringBuffer buffer) {
        buffer.append("</errors>");
    }

    private static String xmlEncode(String theString) {
        String newString = XMLFormatter.replace(theString, '&', "&amp;");
        newString = XMLFormatter.replace(newString, '<', "&lt;");
        newString = XMLFormatter.replace(newString, '>', "&gt;");
        newString = XMLFormatter.replace(newString, '\"', "&quot;");
        return newString;
    }

    public static String replace(String theBaseString, char theChar, String theNewString) {
        if (theBaseString == null) {
            return null;
        }
        int len = theBaseString.length() - 1;
        int pos = -1;
        while ((pos = theBaseString.indexOf(theChar, pos + 1)) > -1) {
            String before;
            if (pos == 0) {
                String after = theBaseString.substring(1);
                theBaseString = theNewString + after;
                continue;
            }
            if (pos == len) {
                before = theBaseString.substring(0, pos);
                theBaseString = before + theNewString;
                continue;
            }
            before = theBaseString.substring(0, pos);
            String after = theBaseString.substring(pos + 1);
            theBaseString = before + theNewString + after;
        }
        return theBaseString;
    }
}

