/*
 * Decompiled with CFR 0.152.
 */
package org.p2psockets;

import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Random;
import org.p2psockets.P2PInetAddress;

public class P2PSocketAddress
extends SocketAddress {
    private String host = null;
    private InetAddress inetAddr = null;
    private int port;

    public P2PSocketAddress(int port) {
        this((InetAddress)null, port);
    }

    public P2PSocketAddress(InetAddress inetAddr, int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The port give is out of range: " + port);
        }
        if (port == 0) {
            port = this.generateRandomPort();
        }
        this.port = port;
        if (inetAddr == null) {
            try {
                this.inetAddr = P2PInetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                inetAddr = null;
            }
        } else {
            this.inetAddr = inetAddr;
        }
        this.host = this.inetAddr.getHostName();
    }

    public P2PSocketAddress(String host, int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The port given is out of range: " + port);
        }
        if (host == null || host.equals("localhost")) {
            try {
                this.inetAddr = P2PInetAddress.getLocalHost();
                host = this.inetAddr.getHostName();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                throw new RuntimeException(e.toString());
            }
        }
        try {
            this.inetAddr = P2PInetAddress.getByAddress(host, null);
            this.host = this.inetAddr.getHostName();
        }
        catch (UnknownHostException e) {
            this.host = host;
            this.inetAddr = null;
        }
        if (port == 0) {
            port = this.generateRandomPort();
        }
        this.port = port;
    }

    public final int getPort() {
        return this.port;
    }

    public final InetAddress getAddress() {
        return this.inetAddr;
    }

    public final String getHostName() {
        if (this.host != null) {
            return this.host;
        }
        if (this.inetAddr != null) {
            return this.inetAddr.getHostName();
        }
        return null;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHostName(String host) {
        this.host = host;
    }

    public String toString() {
        if (this.host != null) {
            return this.host + ":" + this.port;
        }
        if (this.inetAddr != null && this.inetAddr.getHostAddress() != null) {
            return this.inetAddr.getHostAddress() + ":" + this.port;
        }
        return "unresolved";
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof P2PSocketAddress)) {
            return false;
        }
        P2PSocketAddress compareMe = (P2PSocketAddress)obj;
        boolean results = false;
        if (compareMe.getAddress() != null && this.inetAddr != null) {
            results = compareMe.getAddress().equals(this.inetAddr);
        } else if (compareMe.getHostName() != null && this.host != null) {
            results = compareMe.getHostName().equals(this.host);
        }
        return results & compareMe.getPort() == this.port;
    }

    public final int hashCode() {
        if (this.inetAddr != null) {
            return this.inetAddr.hashCode() + this.port;
        }
        if (this.host != null) {
            return this.host.hashCode() + this.port;
        }
        return this.port;
    }

    protected int generateRandomPort() {
        Random randomGenerator = new Random();
        int port = randomGenerator.nextInt() % 65536;
        if (port < 0) {
            port *= -1;
        }
        if (port <= 1024) {
            port += 1024;
        }
        return port;
    }
}

