/*
 * Decompiled with CFR 0.152.
 */
package org.p2psockets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import net.jxta.socket.JxtaSocket;
import org.p2psockets.P2PInetAddress;
import org.p2psockets.P2PInetAddressException;
import org.p2psockets.P2PNameService;
import org.p2psockets.P2PNetwork;
import org.p2psockets.P2PSocketAddress;

public class P2PSocket
extends Socket {
    protected P2PSocketAddress remoteSocketAddress;
    protected P2PSocketAddress localSocketAddress;
    protected JxtaSocket jxtaSocket;
    protected InputStream socketIn;
    protected OutputStream socketOut;
    protected static final int SEND_BUFFER_SIZE = 5000;
    private boolean socketCreated = false;
    private boolean socketBound = false;
    private boolean socketConnected = false;
    private boolean socketClosed = false;
    private boolean socketShutIn = false;
    private boolean socketShutOut = false;

    public P2PSocket() {
    }

    public P2PSocket(String host, int port) throws UnknownHostException, IOException {
        if (port <= 0) {
            throw new IllegalArgumentException("Sockets can not have a port of 0");
        }
        this.remoteSocketAddress = new P2PSocketAddress(host, port);
        this.localSocketAddress = new P2PSocketAddress(P2PInetAddress.getLocalHost(), 0);
        this.connectSocket();
    }

    public P2PSocket(InetAddress address, int port) throws IOException {
        if (port <= 0) {
            throw new IllegalArgumentException("Sockets can not have a port of 0");
        }
        this.remoteSocketAddress = new P2PSocketAddress(address, port);
        this.localSocketAddress = new P2PSocketAddress(P2PInetAddress.getLocalHost(), 0);
        this.connectSocket();
    }

    public P2PSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        if (port <= 0) {
            throw new IllegalArgumentException("Sockets can not have a port of 0");
        }
        this.remoteSocketAddress = new P2PSocketAddress(host, port);
        this.localSocketAddress = new P2PSocketAddress(P2PInetAddress.getLocalHost(), localPort);
        this.connectSocket();
    }

    public P2PSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        if (port <= 0) {
            throw new IllegalArgumentException("Sockets can not have a port of 0");
        }
        this.remoteSocketAddress = new P2PSocketAddress(address, port);
        this.localSocketAddress = new P2PSocketAddress(P2PInetAddress.getLocalHost(), localPort);
        this.connectSocket();
    }

    public P2PSocket(String host, int port, boolean stream) throws IOException {
        this(host, port);
    }

    public P2PSocket(InetAddress address, int port, boolean stream) throws IOException {
        this(address, port);
    }

    protected P2PSocket(JxtaSocket clientJxtaSocket, String remoteHost, int remotePort, InetAddress localAddress, int localPort) throws IOException {
        this.remoteSocketAddress = new P2PSocketAddress(remoteHost, remotePort);
        this.localSocketAddress = new P2PSocketAddress(localAddress, localPort);
        this.jxtaSocket = clientJxtaSocket;
        this.socketIn = this.jxtaSocket.getInputStream();
        this.socketOut = this.jxtaSocket.getOutputStream();
        this.socketConnected = true;
        this.socketBound = true;
    }

    private void connectSocket() throws IOException {
        this.bind(this.localSocketAddress);
        this.connect(this.remoteSocketAddress);
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (endpoint == null) {
            throw new IllegalArgumentException("The remote address can not be null");
        }
        if (this.isClosed()) {
            throw new SocketException("The socket is closed");
        }
        if (this.isConnected()) {
            throw new SocketException("The socket is already connected");
        }
        if (!(endpoint instanceof P2PSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type; only P2PSocketAddress is supported");
        }
        this.remoteSocketAddress = (P2PSocketAddress)endpoint;
        this.jxtaSocket = P2PNameService.resolve(this.remoteSocketAddress, P2PNetwork.getApplicationPeerGroup());
        this.socketIn = this.jxtaSocket.getInputStream();
        this.socketOut = this.jxtaSocket.getOutputStream();
        this.socketConnected = true;
        this.socketBound = true;
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("The socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("The socket is already bound");
        }
        if (bindpoint != null && !(bindpoint instanceof P2PSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type; must use P2PSocketAddress");
        }
        this.localSocketAddress = bindpoint == null ? new P2PSocketAddress(P2PInetAddress.getLocalHost(), 0) : (P2PSocketAddress)bindpoint;
        this.socketBound = true;
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return this.remoteSocketAddress.getAddress();
    }

    public InetAddress getLocalAddress() {
        if (!this.isBound()) {
            try {
                return P2PInetAddress.anyLocalAddress();
            }
            catch (P2PInetAddressException e) {
                e.printStackTrace();
            }
        }
        return this.localSocketAddress.getAddress();
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        return this.remoteSocketAddress.getPort();
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.localSocketAddress.getPort();
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return this.remoteSocketAddress;
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return this.localSocketAddress;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("The socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("The socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("The socket input is shutdown");
        }
        return this.socketIn;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("The socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("The socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("The socket output is shutdown");
        }
        return this.socketOut;
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Urgent data not supported");
    }

    public void setOOBInline(boolean on) throws SocketException {
    }

    public boolean getOOBInline() throws SocketException {
        return false;
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("The socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout value can not be negative");
        }
        this.jxtaSocket.setSoTimeout(timeout);
    }

    public int getSoTimeout() throws SocketException {
        try {
            return this.jxtaSocket.getSoTimeout();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SocketException(e.toString());
        }
    }

    public void setSendBufferSize(int size) throws SocketException {
    }

    public int getSendBufferSize() throws SocketException {
        return 5000;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
    }

    public int getReceiveBufferSize() throws SocketException {
        return 5000;
    }

    public void setKeepAlive(boolean on) throws SocketException {
    }

    public boolean getKeepAlive() throws SocketException {
        return false;
    }

    public void setTrafficClass(int tc) throws SocketException {
    }

    public int getTrafficClass() throws SocketException {
        return 0;
    }

    public void setReuseAddress(boolean on) throws SocketException {
    }

    public boolean getReuseAddress() throws SocketException {
        return false;
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (this.socketCreated) {
            this.jxtaSocket.close();
        }
        this.socketClosed = true;
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("The socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("The socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("The socket input is already shutdown");
        }
        this.socketIn.close();
        this.socketShutIn = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("The socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("The socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("The socket output is already shutdown");
        }
        this.socketOut.flush();
        this.socketOut.close();
        this.socketShutOut = true;
    }

    public boolean isConnected() {
        return this.socketConnected;
    }

    public boolean isBound() {
        return this.socketBound;
    }

    public boolean isClosed() {
        return this.socketClosed;
    }

    public boolean isInputShutdown() {
        return this.socketShutIn;
    }

    public boolean isOutputShutdown() {
        return this.socketShutOut;
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        if (this.isConnected()) {
            results.append("Socket: connected");
        } else {
            results.append("Socket");
        }
        results.append("[remoteSocketAddress=" + this.remoteSocketAddress.toString() + ", localSocketAddress=" + this.localSocketAddress.toString() + "]");
        return results.toString();
    }

    public static void setSocketImplFactory(SocketImplFactory fac) throws IOException {
    }
}

