/*
 * Decompiled with CFR 0.152.
 */
package org.p2psockets;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImplFactory;
import net.jxta.socket.JxtaServerSocket;
import net.jxta.socket.JxtaSocket;
import org.p2psockets.P2PInetAddress;
import org.p2psockets.P2PNameService;
import org.p2psockets.P2PNetwork;
import org.p2psockets.P2PSocket;
import org.p2psockets.P2PSocketAddress;

public class P2PServerSocket
extends ServerSocket {
    public static final String ANONYMOUS_PEER_NAME = "www.anonymous.peer";
    protected static final int RECEIVE_BUFFER_SIZE = 5000;
    protected JxtaServerSocket jxtaServerSocket;
    protected P2PSocketAddress socketAddress;
    private boolean serverSocketCreated = false;
    private boolean serverSocketBound = false;
    private boolean serverSocketClosed = false;

    public P2PServerSocket() throws IOException {
    }

    public P2PServerSocket(int port) throws IOException {
        this(port, -1, null);
    }

    public P2PServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null);
    }

    public P2PServerSocket(String host, int port) throws IOException {
        this(port, -1, P2PInetAddress.getByAddress(host, null));
    }

    public P2PServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        backlog = -1;
        this.socketAddress = bindAddr == null ? new P2PSocketAddress(port) : new P2PSocketAddress(bindAddr, port);
        this.bind(this.socketAddress);
    }

    public void bind(SocketAddress endpoint) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("The socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("The server socket is already bound");
        }
        if (endpoint != null && !(endpoint instanceof P2PSocketAddress)) {
            throw new IllegalArgumentException("endpoint must be a P2PSocketAddress");
        }
        this.socketAddress = endpoint == null ? new P2PSocketAddress(0) : (P2PSocketAddress)endpoint;
        this.jxtaServerSocket = P2PNameService.bind(this.socketAddress, P2PNetwork.getApplicationPeerGroup());
        this.serverSocketBound = true;
        this.serverSocketCreated = true;
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.bind(endpoint);
    }

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        return this.socketAddress.getAddress();
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.socketAddress.getPort();
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return this.socketAddress;
    }

    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("The server socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("The server socket is not bound yet");
        }
        try {
            JxtaSocket clientJxtaSocket = this.jxtaServerSocket.accept();
            P2PSocketAddress remoteSocketAddress = new P2PSocketAddress(ANONYMOUS_PEER_NAME, 0);
            String remoteHost = remoteSocketAddress.getAddress().getHostName();
            int remotePort = remoteSocketAddress.getPort();
            InetAddress localAddress = this.socketAddress.getAddress();
            int localPort = this.socketAddress.getPort();
            P2PSocket clientSocket = new P2PSocket(clientJxtaSocket, remoteHost, remotePort, localAddress, localPort);
            return clientSocket;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.serverSocketClosed = true;
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("The server socket is closed");
        }
        this.jxtaServerSocket.setSoTimeout(timeout);
    }

    public int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("The server socket is closed");
        }
        return this.jxtaServerSocket.getSoTimeout();
    }

    public void setReuseAddress(boolean on) throws SocketException {
    }

    public boolean getReuseAddress() throws SocketException {
        return false;
    }

    public String toString() {
        if (!this.isBound()) {
            return "P2PServerSocket[unbound]";
        }
        return "P2PServerSocket[socketAddress=" + this.socketAddress.toString() + "]";
    }

    public static void setSocketFactory(SocketImplFactory fac) throws IOException {
    }

    public void setReceiveBufferSize(int size) throws SocketException {
    }

    public int getReceiveBufferSize() throws SocketException {
        return 5000;
    }

    public boolean isBound() {
        return this.serverSocketBound;
    }

    public boolean isClosed() {
        return this.serverSocketClosed;
    }
}

