/*
 * Decompiled with CFR 0.152.
 */
package org.p2psockets;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.ext.config.Profiler;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEConfig;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import org.p2psockets.P2PNameService;

public class P2PNetwork {
    public static String P2PSOCKETS_NETWORK = "p2psockets.network";
    public static String JXTA_USERNAME = "net.jxta.tls.principal";
    public static String JXTA_PASSWORD = "net.jxta.tls.password";
    public static String JXTA_HOME = "JXTA_HOME";
    private static PeerGroup netPeerGroup;
    private static PeerGroup applicationPeerGroup;
    private static boolean signedIn;

    public static boolean accountExists(String userName) throws Exception {
        String jxtaHome = System.getProperty("JXTA_HOME", "." + File.separator + ".jxta");
        File homeDir = new File(jxtaHome);
        PSEConfig pseConfig = new PSEConfig(homeDir);
        return pseConfig.principalIsIssuer(userName, null);
    }

    public static void createAccount() throws Exception {
        String userName = System.getProperty(JXTA_USERNAME);
        String password = System.getProperty(JXTA_PASSWORD);
        if (userName == null || password == null) {
            throw new RuntimeException("You must provide a JXTA username and password by setting " + JXTA_USERNAME + " and " + JXTA_PASSWORD);
        }
        P2PNetwork.createAccount(userName, password);
    }

    public static void createAccount(String userName, String password) throws Exception {
        String applicationPeerGroupName = System.getProperty(P2PSOCKETS_NETWORK);
        if (applicationPeerGroupName == null) {
            throw new RuntimeException("You must either provide the system property " + P2PSOCKETS_NETWORK + " when running your software, " + "or code your application to use " + "P2PNetwork.createAccount(String userName, String password, " + "String applicationPeerGroupName)");
        }
        P2PNetwork.createAccount(userName, password, applicationPeerGroupName);
    }

    public static synchronized void createAccount(String userName, String password, String applicationPeerGroupName) throws Exception {
        if (signedIn) {
            return;
        }
        File jxtaDir = new File(System.getProperty("JXTA_HOME"));
        if (jxtaDir != null && !jxtaDir.equals("") && jxtaDir.toString().indexOf(".jxta") != -1) {
            System.out.println("Deleting JXTA configuration directory at " + jxtaDir + "...");
            jxtaDir.delete();
        }
        Profiler profiler = new Profiler(userName, userName, password);
        profiler.save();
        System.setProperty(JXTA_USERNAME, userName);
        System.setProperty(JXTA_PASSWORD, password);
        netPeerGroup = PeerGroupFactory.newNetPeerGroup();
        if (!netPeerGroup.isRendezvous()) {
            P2PNetwork.contactRendezVous(netPeerGroup);
        }
        PeerGroup applicationPeerGroup = P2PNetwork.findCreateAndJoinPeerGroup(applicationPeerGroupName, netPeerGroup);
        P2PNetwork.setApplicationPeerGroup(applicationPeerGroup);
        signedIn = true;
    }

    public static synchronized void signin() throws Exception {
        String userName = System.getProperty(JXTA_USERNAME);
        String password = System.getProperty(JXTA_PASSWORD);
        if (userName == null || password == null) {
            throw new RuntimeException("You must provide a JXTA username and password by setting " + JXTA_USERNAME + " and " + JXTA_PASSWORD);
        }
        P2PNetwork.signin(userName, password);
    }

    public static void signin(String userName, String password) throws Exception {
        String applicationPeerGroupName = System.getProperty(P2PSOCKETS_NETWORK);
        if (applicationPeerGroupName == null) {
            throw new RuntimeException("You must either provide the system property " + P2PSOCKETS_NETWORK + " when running your software, " + "or code your application to use " + "P2PNetwork.signin(String userName, String password, " + "String applicationPeerGroupName)");
        }
        P2PNetwork.signin(userName, password, applicationPeerGroupName, true, true);
    }

    public static void signin(String userName, String password, String applicationPeerGroupName) throws Exception {
        P2PNetwork.signin(userName, password, applicationPeerGroupName, true, false);
    }

    public static synchronized void signin(String userName, String password, String applicationPeerGroupName, boolean profilePeer, boolean createIfNotExist) throws Exception {
        PSEConfig pseConfig;
        if (signedIn) {
            return;
        }
        String jxtaHome = System.getProperty("JXTA_HOME", "." + File.separator + ".jxta");
        File homeDir = new File(jxtaHome);
        if (createIfNotExist && !homeDir.exists()) {
            System.out.println("No JXTA account exists; creating one for " + userName + "...");
            P2PNetwork.createAccount(userName, password, applicationPeerGroupName);
            return;
        }
        if (profilePeer) {
            Profiler profiler = new Profiler(userName, userName, password);
            profiler.save();
        }
        if (!(pseConfig = new PSEConfig(homeDir)).principalIsIssuer(userName, null) || !pseConfig.validPasswd(password)) {
            throw new Exception("Invalid username or password given");
        }
        System.setProperty(JXTA_USERNAME, userName);
        System.setProperty(JXTA_PASSWORD, password);
        netPeerGroup = PeerGroupFactory.newNetPeerGroup();
        if (!netPeerGroup.isRendezvous()) {
            P2PNetwork.contactRendezVous(netPeerGroup);
        }
        PeerGroup applicationPeerGroup = P2PNetwork.findCreateAndJoinPeerGroup(applicationPeerGroupName, netPeerGroup);
        P2PNetwork.setApplicationPeerGroup(applicationPeerGroup);
        signedIn = true;
    }

    public static void signOff() throws Exception {
        signedIn = false;
    }

    public static synchronized PeerGroup getNetPeerGroup() {
        if (netPeerGroup == null) {
            throw new RuntimeException("You must call P2PNetwork.signin() before  attempting to use this class");
        }
        return netPeerGroup;
    }

    public static synchronized void setApplicationPeerGroup(PeerGroup appPeerGroup) {
        applicationPeerGroup = appPeerGroup;
    }

    public static synchronized PeerGroup getApplicationPeerGroup() {
        return applicationPeerGroup;
    }

    protected static void contactRendezVous(PeerGroup inGroup) throws Exception {
        RendezVousService rdv = inGroup.getRendezVousService();
        System.out.print("Waiting for RendezVous Connection.");
        System.out.flush();
        int timeSoFar = 0;
        while (!rdv.isConnectedToRendezVous() && timeSoFar < 120000) {
            System.out.print(".");
            System.out.flush();
            Thread.currentThread();
            Thread.sleep(1000L);
            timeSoFar += 1000;
        }
        System.out.print("\n");
        if (!rdv.isConnectedToRendezVous()) {
            throw new RuntimeException("No RendezVous found for the peer group " + inGroup.getPeerGroupName());
        }
        System.out.println("Finished connecting to RendezVous.");
    }

    protected static PeerGroup findCreateAndJoinPeerGroup(String applicationPeerGroupName, PeerGroup searchInPeerGroup) throws Exception {
        PeerGroup peerGroup;
        PeerGroupAdvertisement peerGroupAd = P2PNameService.searchForAdvertisement(applicationPeerGroupName, searchInPeerGroup);
        if (peerGroupAd != null) {
            peerGroup = searchInPeerGroup.newGroup((Advertisement)peerGroupAd);
        } else {
            peerGroup = P2PNetwork.createPeerGroup(applicationPeerGroupName, searchInPeerGroup);
            if (peerGroup == null) {
                throw new IOException(applicationPeerGroupName + " could not be found or created.");
            }
        }
        P2PNameService.joinPeerGroup(peerGroup);
        return peerGroup;
    }

    protected static PeerGroup createPeerGroup(String applicationPeerGroupName, PeerGroup parentPeerGroup) throws Exception {
        ModuleImplAdvertisement moduleImplAdvertisement = parentPeerGroup.getAllPurposePeerGroupImplAdvertisement();
        byte[] digest = P2PNetwork.generateHash(applicationPeerGroupName, null);
        PeerGroupID newPeerGroupID = IDFactory.newPeerGroupID((PeerGroupID)parentPeerGroup.getPeerGroupID(), (byte[])digest);
        PeerGroupAdvertisement newPeerGroupAd = (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement((String)PeerGroupAdvertisement.getAdvertisementType());
        newPeerGroupAd.setName(applicationPeerGroupName);
        newPeerGroupAd.setPeerGroupID(newPeerGroupID);
        newPeerGroupAd.setModuleSpecID(moduleImplAdvertisement.getModuleSpecID());
        PeerGroup newPeerGroup = parentPeerGroup.newGroup((Advertisement)newPeerGroupAd);
        return newPeerGroup;
    }

    protected static byte[] generateHash(String clearTextID, String function) {
        String id = function == null ? clearTextID : clearTextID + ":" + function;
        byte[] buffer = id.getBytes();
        MessageDigest algorithm = null;
        try {
            algorithm = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            System.out.println("Cannot load MD5 Digest Hash implementation");
            e.printStackTrace();
            return null;
        }
        algorithm.reset();
        algorithm.update(buffer);
        try {
            byte[] digest1 = algorithm.digest();
            return digest1;
        }
        catch (Exception de) {
            System.out.println("Failed to creat a digest.");
            de.printStackTrace();
            return null;
        }
    }

    static {
        signedIn = false;
    }
}

