/*
 * Decompiled with CFR 0.152.
 */
package org.p2psockets;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.StringTokenizer;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.binaryID.DigestTool;
import net.jxta.impl.id.binaryID.PeerGroupBinaryID;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.socket.JxtaServerSocket;
import net.jxta.socket.JxtaSocket;
import org.p2psockets.P2PInetAddress;
import org.p2psockets.P2PNetwork;
import org.p2psockets.P2PSocketAddress;

public class P2PNameService {
    public static final String PEER_SERVICE_SUFFIX = ".peer";
    public static final String PEER_SERVICE_PREFIX = "www.";
    public static final String NAME_FIELD = "Name";
    private static final int TIMEOUT = 2000;
    private static final int MAX_ADVERTISEMENT_DISCOVERY_ATTEMPTS = 3;
    private static final int MAX_PORT_DISCOVERY_ATTEMPTS = 5;
    private static DigestTool digestTool = new DigestTool();

    public static JxtaServerSocket bind(P2PSocketAddress endpoint, PeerGroup hostParentPeerGroup) throws IOException {
        try {
            if (endpoint == null) {
                endpoint = new P2PSocketAddress(P2PInetAddress.getLocalHost(), 0);
            }
            InetAddress inetAddress = endpoint.getAddress();
            int port = endpoint.getPort();
            byte[] ipAddress = inetAddress.getAddress();
            String host = inetAddress.getHostName();
            if (inetAddress == null || inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress()) {
                host = P2PInetAddress.getLocalHost().getHostName();
            } else if (inetAddress.getHostName() == null && inetAddress.getAddress() == null) {
                host = P2PInetAddress.getLocalHost().getHostName();
            } else if (inetAddress.getHostName() != null) {
                host = inetAddress.getHostName();
            }
            endpoint.setHostName(host);
            PeerGroup hostPeerGroup = P2PNameService.findCreateAndJoinPeerGroup(endpoint.getAddress().getHostName(), endpoint.getAddress().getHostAddress(), hostParentPeerGroup, true);
            P2PNameService.becomeRendezvous(hostPeerGroup);
            endpoint.setPort(port);
            PipeAdvertisement serverSocketAd = P2PNameService.createAndPublishPipe(host, port, hostPeerGroup);
            JxtaServerSocket serverSide = new JxtaServerSocket(hostPeerGroup, serverSocketAd, 50, 0);
            return serverSide;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    public static JxtaSocket resolve(P2PSocketAddress endpoint, PeerGroup hostParentPeerGroup) throws IOException {
        try {
            if (endpoint == null) {
                throw new IllegalArgumentException("You must provide an endpoint to resolve.");
            }
            InetAddress inetAddress = endpoint.getAddress();
            int port = endpoint.getPort();
            String ipAddress = inetAddress.getHostAddress();
            String host = inetAddress.getHostName();
            if (inetAddress == null || inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress()) {
                host = P2PInetAddress.getLocalHost().getHostName();
            } else if (inetAddress.getHostName() == null && inetAddress.getAddress() == null) {
                host = P2PInetAddress.getLocalHost().getHostName();
            } else if (inetAddress.getHostName() != null) {
                host = inetAddress.getHostName();
            } else if (inetAddress.getHostName() == null && inetAddress.getAddress() != null) {
                host = P2PNameService.findHostName(ipAddress, hostParentPeerGroup);
            }
            endpoint.setHostName(host);
            return P2PNameService.resolve(host, port, hostParentPeerGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    public static JxtaSocket resolve(String host, int port, PeerGroup hostParentPeerGroup) throws IOException {
        try {
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("The port value is out of range: " + port);
            }
            PeerGroup hostPeerGroup = P2PNameService.findCreateAndJoinPeerGroup(host, null, hostParentPeerGroup, false);
            PipeAdvertisement serverSocketAd = P2PNameService.createPipeAdvertisement(host, port, hostPeerGroup);
            JxtaSocket socket = new JxtaSocket(hostPeerGroup, null, serverSocketAd, 60000, true);
            return socket;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    public static JxtaSocket resolve(byte[] ipAddress, int port, PeerGroup hostParentPeerGroup) throws IOException {
        String ipString = P2PInetAddress.getByAddress(ipAddress).getHostAddress();
        if (ipString.equals("127.0.0.1") || ipString.equals("0.0.0.0")) {
            return P2PNameService.resolve("localhost", port, hostParentPeerGroup);
        }
        return P2PNameService.resolve(P2PInetAddress.getByAddress(ipAddress).getHostName(), port, hostParentPeerGroup);
    }

    public static PeerGroupAdvertisement searchForAdvertisement(String value, PeerGroup searchInPeerGroup) {
        DiscoveryService netDiscovery = searchInPeerGroup.getDiscoveryService();
        Enumeration ae = null;
        PeerGroupAdvertisement findMeAdv = null;
        int count = 3;
        while (count-- > 0) {
            try {
                ae = netDiscovery.getLocalAdvertisements(1, NAME_FIELD, value);
                if (ae != null && ae.hasMoreElements()) break;
                netDiscovery.getRemoteAdvertisements(null, 1, NAME_FIELD, value, 1, null);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (ae != null && ae.hasMoreElements()) {
            findMeAdv = (PeerGroupAdvertisement)ae.nextElement();
        }
        return findMeAdv;
    }

    public static byte[] findIPAddress(String host) throws IOException, UnknownHostException {
        return P2PNameService.findIPAddress(host, P2PNetwork.getApplicationPeerGroup());
    }

    public static byte[] findIPAddress(String host, PeerGroup searchInPeerGroup) throws IOException, UnknownHostException {
        if (host == null || host.equals("localhost")) {
            return P2PInetAddress.getLocalHost().getAddress();
        }
        PeerGroupAdvertisement groupAd = P2PNameService.searchForAdvertisement(host + "/*", searchInPeerGroup);
        String nameField = groupAd.getName();
        StringTokenizer tk = new StringTokenizer(nameField, "/", false);
        tk.nextToken();
        String ipString = tk.nextToken();
        return P2PInetAddress.getByAddress(ipString, null).getAddress();
    }

    public static String findHostName(String ipAddress) throws IOException, UnknownHostException {
        return P2PNameService.findHostName(ipAddress, P2PNetwork.getApplicationPeerGroup());
    }

    public static String findHostName(String ipAddress, PeerGroup searchInPeerGroup) throws IOException, UnknownHostException {
        PeerGroupAdvertisement groupAd = P2PNameService.searchForAdvertisement("*/" + ipAddress, searchInPeerGroup);
        if (groupAd != null) {
            String nameField = groupAd.getName();
            StringTokenizer tk = new StringTokenizer(nameField, "/", false);
            return tk.nextToken();
        }
        return null;
    }

    public static boolean isHostNameTaken(String hostName) throws IOException {
        InetAddress inetAddr = P2PInetAddress.getByAddress(hostName, null);
        hostName = inetAddr.getHostName();
        PeerGroup searchInPeerGroup = P2PNetwork.getApplicationPeerGroup();
        PeerGroupAdvertisement groupAd = P2PNameService.searchForAdvertisement(hostName + "/*", searchInPeerGroup);
        return groupAd != null;
    }

    public static boolean isPortTaken(String hostName, int port) throws IOException {
        InetAddress inetAddr = P2PInetAddress.getByAddress(hostName, null);
        hostName = inetAddr.getHostName();
        PeerGroup searchInPeerGroup = P2PNetwork.getApplicationPeerGroup();
        PeerGroup hostPeerGroup = null;
        try {
            hostPeerGroup = P2PNameService.findCreateAndJoinPeerGroup(hostName, null, searchInPeerGroup, false);
        }
        catch (Exception e) {
            return false;
        }
        PipeAdvertisement portPipe = P2PNameService.searchForPipeAdvertisement(hostName, port, hostPeerGroup);
        return portPipe != null;
    }

    public static boolean isIPAddressTaken(String ipAddress) throws IOException {
        InetAddress inetAddr = P2PInetAddress.getByAddress(ipAddress, null);
        ipAddress = inetAddr.getHostAddress();
        PeerGroup searchInPeerGroup = P2PNetwork.getApplicationPeerGroup();
        PeerGroupAdvertisement groupAd = P2PNameService.searchForAdvertisement("*/" + ipAddress, searchInPeerGroup);
        return groupAd != null;
    }

    protected static PeerGroup findCreateAndJoinPeerGroup(String host, String ipAddress, PeerGroup searchInPeerGroup, boolean createIfNotFound) throws Exception {
        PeerGroup peerGroup;
        PeerGroupAdvertisement peerGroupAd = P2PNameService.searchForAdvertisement(host + "/*", searchInPeerGroup);
        if (peerGroupAd != null) {
            peerGroup = P2PNetwork.getApplicationPeerGroup().newGroup((Advertisement)peerGroupAd);
        } else if (createIfNotFound) {
            peerGroup = P2PNameService.createPeerGroup(host, ipAddress, searchInPeerGroup);
            if (peerGroup == null) {
                throw new IOException(host + " could not be found or created.");
            }
        } else {
            throw new IOException("A peer group with a Name of " + host + " could not be found.");
        }
        P2PNameService.joinPeerGroup(peerGroup);
        return peerGroup;
    }

    protected static PeerGroup createPeerGroup(String host, String ipAddress, PeerGroup parentPeerGroup) throws Exception {
        if (ipAddress == null) {
            ipAddress = P2PInetAddress.getByAddress(host, null).getHostAddress();
        }
        ModuleImplAdvertisement moduleImplAdvertisement = parentPeerGroup.getAllPurposePeerGroupImplAdvertisement();
        PeerGroupBinaryID newPeerGroupID = digestTool.createPeerGroupID(parentPeerGroup.getPeerGroupID(), host, null);
        PeerGroupAdvertisement newPeerGroupAd = (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement((String)PeerGroupAdvertisement.getAdvertisementType());
        newPeerGroupAd.setName(host + "/" + ipAddress);
        newPeerGroupAd.setPeerGroupID((PeerGroupID)newPeerGroupID);
        newPeerGroupAd.setModuleSpecID(moduleImplAdvertisement.getModuleSpecID());
        PeerGroup newPeerGroup = parentPeerGroup.newGroup((Advertisement)newPeerGroupAd);
        return newPeerGroup;
    }

    protected static PipeAdvertisement createAndPublishPipe(String host, int port, PeerGroup startServerInGroup) throws Exception {
        String ipAddress = P2PInetAddress.getByAddress(host, null).getHostAddress();
        PipeAdvertisement pipeAd = P2PNameService.createPipeAdvertisement(host, port, startServerInGroup);
        DiscoveryService parentDiscovery = startServerInGroup.getDiscoveryService();
        parentDiscovery.publish((Advertisement)pipeAd);
        parentDiscovery.remotePublish((Advertisement)pipeAd);
        return pipeAd;
    }

    protected static PipeAdvertisement createPipeAdvertisement(String host, int port, PeerGroup parentPeerGroup) throws Exception {
        PipeID serverSocketID = P2PNameService.getPipeID(host, port, parentPeerGroup);
        PipeAdvertisement serverSocketAd = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        serverSocketAd.setPipeID((ID)serverSocketID);
        serverSocketAd.setName(new Integer(port).toString());
        serverSocketAd.setType("JxtaUnicast");
        return serverSocketAd;
    }

    protected static PipeAdvertisement searchForPipeAdvertisement(String host, int port, PeerGroup parentPeerGroup) {
        DiscoveryService netDiscovery = parentPeerGroup.getDiscoveryService();
        Enumeration ae = null;
        PipeAdvertisement findMeAdv = null;
        int count = 3;
        while (count-- > 0) {
            try {
                ae = netDiscovery.getLocalAdvertisements(2, NAME_FIELD, Integer.toString(port));
                if (ae != null && ae.hasMoreElements()) break;
                netDiscovery.getRemoteAdvertisements(null, 2, NAME_FIELD, Integer.toString(port), 1, null);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (ae != null && ae.hasMoreElements()) {
            findMeAdv = (PipeAdvertisement)ae.nextElement();
        }
        return findMeAdv;
    }

    protected static PipeID getPipeID(String host, int port, PeerGroup parentPeerGroup) throws Exception {
        byte[] digest = P2PNameService.generateHash(host + ":" + new Integer(port).toString(), null);
        PeerGroupID parentGroupID = parentPeerGroup.getPeerGroupID();
        return IDFactory.newPipeID((PeerGroupID)parentGroupID, (byte[])digest);
    }

    protected static void joinPeerGroup(PeerGroup peerGroupToJoin) throws Exception {
        AuthenticationCredential cred = new AuthenticationCredential(peerGroupToJoin, null, null);
        MembershipService membership = peerGroupToJoin.getMembershipService();
        Authenticator auth = membership.apply(cred);
        if (!auth.isReadyForJoin()) {
            throw new RuntimeException("Unable to join " + peerGroupToJoin.getPeerGroupName());
        }
        membership.join(auth);
    }

    protected static void becomeRendezvous(PeerGroup inGroup) throws Exception {
        if (!inGroup.isRendezvous()) {
            RendezVousService rendezvous = inGroup.getRendezVousService();
            rendezvous.startRendezVous();
        }
    }

    protected static byte[] generateHash(String clearTextID, String function) {
        String id = function == null ? clearTextID : clearTextID + ":" + function;
        byte[] buffer = id.getBytes();
        MessageDigest algorithm = null;
        try {
            algorithm = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            System.out.println("Cannot load MD5 Digest Hash implementation");
            e.printStackTrace();
            return null;
        }
        algorithm.reset();
        algorithm.update(buffer);
        try {
            byte[] digest1 = algorithm.digest();
            return digest1;
        }
        catch (Exception de) {
            System.out.println("Failed to creat a digest.");
            de.printStackTrace();
            return null;
        }
    }
}

