/*
 * Decompiled with CFR 0.152.
 */
package org.p2psockets;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.p2psockets.P2PInetAddressException;
import org.p2psockets.P2PNameService;
import org.p2psockets.P2PNetwork;

public class P2PInetAddress {
    private static byte[] localHostAddress;
    private String hostName;
    private int address = -1;
    static /* synthetic */ Class class$java$net$InetAddress;

    P2PInetAddress(String hostName, int address) {
        this(hostName, P2PInetAddress.getAddress(address));
    }

    P2PInetAddress() {
        this(null, P2PInetAddress.getAddress(0));
    }

    P2PInetAddress(String hostName, byte[] address) {
        int intAddress;
        if (hostName == null && address == null) {
            hostName = P2PInetAddress.getLocalHostName();
            address = P2PInetAddress.getIPAddress(hostName);
        }
        if (hostName != null && hostName.equals("localhost")) {
            hostName = P2PInetAddress.getLocalHostName();
        }
        if (address == null && P2PInetAddress.isIPAddress(hostName)) {
            address = P2PInetAddress.fromIPString(hostName);
        }
        if (P2PInetAddress.isIPAddress(hostName)) {
            hostName = null;
        }
        this.address = address != null ? (intAddress = P2PInetAddress.getIPAddressAsInteger(address)) : P2PInetAddress.getIPAddressAsInteger(P2PInetAddress.generateIPAddress(hostName));
        if (P2PInetAddress.toIPString(P2PInetAddress.getAddress(this.address)).equals("127.0.0.1") || P2PInetAddress.toIPString(P2PInetAddress.getAddress(this.address)).equals("0.0.0.0")) {
            if (hostName == null) {
                hostName = P2PInetAddress.getLocalHostName();
            }
            this.address = P2PInetAddress.getIPAddressAsInteger(P2PInetAddress.generateIPAddress(hostName));
        }
        this.hostName = hostName;
    }

    public static InetAddress getByAddress(String host, byte[] addr) throws P2PInetAddressException {
        P2PInetAddress p2pAddr = new P2PInetAddress(host, addr);
        return p2pAddr.toInetAddress();
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        try {
            byte[] addr = null;
            if (P2PInetAddress.isIPAddress(host)) {
                if (host.equals("127.0.0.1") || host.equals("0.0.0.0")) {
                    host = P2PInetAddress.getLocalHostName();
                    addr = P2PInetAddress.getIPAddress(host);
                } else {
                    InetAddress hostInetAddr = P2PInetAddress.getByAddress(host, null);
                    addr = hostInetAddr.getAddress();
                }
            }
            if (host == null || host.equals("localhost")) {
                host = P2PInetAddress.getLocalHostName();
            }
            if (addr == null) {
                addr = P2PNameService.findIPAddress(host, P2PNetwork.getApplicationPeerGroup());
            }
            if (addr == null) {
                addr = P2PInetAddress.getIPAddress(host);
            }
            P2PInetAddress p2pAddr = new P2PInetAddress(host, addr);
            return p2pAddr.toInetAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnknownHostException(e.toString());
        }
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        InetAddress[] results = new InetAddress[]{P2PInetAddress.getByName(host)};
        return results;
    }

    public static InetAddress getByAddress(byte[] addr) throws P2PInetAddressException {
        P2PInetAddress p2pAddr = new P2PInetAddress(null, addr);
        return p2pAddr.toInetAddress();
    }

    public static InetAddress getLocalHost() throws P2PInetAddressException {
        P2PInetAddress p2pAddr = new P2PInetAddress(null, null);
        return p2pAddr.toInetAddress();
    }

    public static InetAddress anyLocalAddress() throws P2PInetAddressException {
        InetAddress results = P2PInetAddress.getByAddress("0.0.0.0", null);
        return results;
    }

    public static InetAddress loopbackAddress() throws P2PInetAddressException {
        InetAddress results = P2PInetAddress.getByAddress("localhost", null);
        return results;
    }

    protected InetAddress toInetAddress() throws P2PInetAddressException {
        try {
            if (this.hostName != null && this.address == -1) {
                this.address = P2PInetAddress.getIPAddressAsInteger(P2PInetAddress.getIPAddress(this.hostName));
            } else if (this.hostName == null && this.address != -1) {
                String ipAddressString = P2PInetAddress.toIPString(P2PInetAddress.getAddress(this.address));
                this.hostName = P2PNameService.findHostName(ipAddressString);
            }
            if (this.hostName == null && this.address == -1) {
                throw new UnknownHostException("Not enough information was provided for P2PInetAddress: hostName=" + this.hostName + ", address=" + this.address);
            }
            if (this.hostName == null) {
                this.hostName = P2PInetAddress.getIPString(P2PInetAddress.getAddress(this.address));
            }
            InetAddress results = InetAddress.getByAddress(this.hostName, P2PInetAddress.getAddress(this.address));
            Field canonicalHostNameField = null;
            Field[] fields = (class$java$net$InetAddress == null ? (class$java$net$InetAddress = P2PInetAddress.class$("java.net.InetAddress")) : class$java$net$InetAddress).getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getName().equals("canonicalHostName")) {
                    fields[i].setAccessible(true);
                    canonicalHostNameField = fields[i];
                    break;
                }
                ++i;
            }
            if (canonicalHostNameField == null) {
                throw new UnknownHostException("canonicalHostName could not be found through Java reflection.");
            }
            canonicalHostNameField.set(results, this.hostName);
            return results;
        }
        catch (Exception e) {
            throw new P2PInetAddressException(e);
        }
    }

    protected static byte[] getIPAddress(String hostName) {
        if (hostName == null || hostName.equals("127.0.0.1") || hostName.equals("localhost") || hostName.equals("0.0.0.0") || hostName.equals(P2PInetAddress.getLocalHostName())) {
            hostName = P2PInetAddress.getLocalHostName();
            if (P2PInetAddress.getLocalHostAddress() == null) {
                P2PInetAddress.setLocalHostAddress(P2PInetAddress.generateIPAddress(hostName));
            }
            return P2PInetAddress.getLocalHostAddress();
        }
        return P2PInetAddress.generateIPAddress(hostName);
    }

    protected static String getIPString(String hostName) {
        return P2PInetAddress.toIPString(P2PInetAddress.getIPAddress(hostName));
    }

    protected static String getIPString(byte[] addr) {
        StringBuffer results = new StringBuffer();
        try {
            results.append(new Byte(addr[0]).toString());
            results.append(".");
            results.append(new Byte(addr[1]).toString());
            results.append(".");
            results.append(new Byte(addr[2]).toString());
            results.append(".");
            results.append(new Byte(addr[3]).toString());
            return results.toString();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    protected static byte[] generateIPAddress(String hostName) {
        byte[] results = new byte[]{0, 0, 0, 0};
        byte[] hostNameBytes = hostName.getBytes();
        int i = 0;
        while (i < hostNameBytes.length) {
            int n = i % 4;
            results[n] = (byte)(results[n] + hostNameBytes[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            if (results[i2] == 0 || results[i2] == 127) {
                int n = i2;
                results[n] = (byte)(results[n] + 1);
            } else if (results[i2] == 255) {
                int n = i2;
                results[n] = (byte)(results[n] - -1);
            }
            ++i2;
        }
        return results;
    }

    protected static String toIPString(byte[] value) {
        String results = value == null ? "0.0.0.0" : (value[0] & 0xFF) + "." + (value[1] & 0xFF) + "." + (value[2] & 0xFF) + "." + (value[3] & 0xFF);
        return results;
    }

    protected static byte[] fromIPString(String ipString) {
        byte[] results = new byte[4];
        StringTokenizer tk = new StringTokenizer(ipString, ".", false);
        try {
            int i = 0;
            while (i < 4) {
                String ipByte = tk.nextToken();
                results[i] = new Short(ipByte).byteValue();
                ++i;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
        return results;
    }

    protected static boolean isIPAddress(String checkMe) {
        if (checkMe == null) {
            return false;
        }
        boolean results = false;
        StringTokenizer tk = new StringTokenizer(checkMe, ".", false);
        if (tk.countTokens() != 4) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            String ipByte = tk.nextToken();
            if (ipByte.length() > 3) {
                return false;
            }
            int j = 0;
            while (j < ipByte.length()) {
                char ipChar = ipByte.charAt(j);
                switch (ipChar) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected static int getIPAddressAsInteger(byte[] addr) {
        int results = 0;
        results = addr[3] & 0xFF;
        results |= addr[2] << 8 & 0xFF00;
        results |= addr[1] << 16 & 0xFF0000;
        return results |= addr[0] << 24 & 0xFF000000;
    }

    protected static String getLocalHostName() {
        return "www." + P2PNetwork.getApplicationPeerGroup().getPeerName() + ".peer";
    }

    protected static synchronized byte[] getLocalHostAddress() {
        return localHostAddress;
    }

    protected static synchronized void setLocalHostAddress(byte[] addr) {
        localHostAddress = addr;
    }

    protected static byte[] getAddress(int intAddr) {
        byte[] results = new byte[]{(byte)(intAddr >>> 24 & 0xFF), (byte)(intAddr >>> 16 & 0xFF), (byte)(intAddr >>> 8 & 0xFF), (byte)(intAddr & 0xFF)};
        return results;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

