/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.socket;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.endpoint.InputStreamMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.socket.JxtaSocket;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JxtaServerSocket
implements PipeMsgListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$socket$JxtaServerSocket == null ? (class$net$jxta$socket$JxtaServerSocket = JxtaServerSocket.class$("net.jxta.socket.JxtaServerSocket")) : class$net$jxta$socket$JxtaServerSocket).getName());
    public static final String nameSpace = "JXTASOC";
    public static final String credTag = "Cred";
    public static final String reqPipeTag = "reqPipe";
    public static final String remPeerTag = "remPeer";
    public static final String remPipeTag = "remPipe";
    public static final String dataTag = "data";
    public static final String closeTag = "close";
    public static final String streamTag = "stream";
    protected PeerGroup group;
    protected InputPipe serverPipe;
    protected PipeAdvertisement pipeadv;
    protected int backlog = 50;
    protected int timeout = 60000;
    protected String closeLock = new String("closeLock");
    protected UnbiasedQueue queue = UnbiasedQueue.synchronizedQueue((UnbiasedQueue)new UnbiasedQueue(this.backlog, true));
    protected boolean created = false;
    protected boolean bound = false;
    protected boolean closed = false;
    static /* synthetic */ Class class$net$jxta$socket$JxtaServerSocket;

    public JxtaServerSocket() {
    }

    public JxtaServerSocket(PeerGroup group, PipeAdvertisement pipeadv) throws IOException {
        this(group, pipeadv, 50);
    }

    public JxtaServerSocket(PeerGroup group, PipeAdvertisement pipeadv, int backlog) throws IOException {
        this(group, pipeadv, backlog, 60000);
    }

    public JxtaServerSocket(PeerGroup group, PipeAdvertisement pipeadv, int backlog, int timeout) throws IOException {
        this.group = group;
        this.pipeadv = pipeadv;
        this.backlog = backlog;
        this.timeout = timeout;
        this.queue.setMaxQueueSize(backlog);
        PipeService pipeSvc = group.getPipeService();
        this.serverPipe = pipeSvc.createInputPipe(pipeadv, (PipeMsgListener)this);
        this.setBound();
    }

    public void bind(PeerGroup group, PipeAdvertisement pipeadv) throws IOException {
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        this.group = group;
        this.pipeadv = pipeadv;
        PipeService pipeSvc = group.getPipeService();
        this.serverPipe = pipeSvc.createInputPipe(pipeadv, (PipeMsgListener)this);
        this.setBound();
    }

    public void bind(PeerGroup group, PipeAdvertisement pipeadv, int backlog) throws IOException {
        this.backlog = backlog;
        this.bind(group, pipeadv);
        this.queue.setMaxQueueSize(backlog);
    }

    public JxtaSocket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        try {
            Message msg;
            JxtaSocket socket;
            do {
                if ((msg = (Message)this.queue.pop((long)this.timeout)) != null) continue;
                throw new SocketException("closed");
            } while ((socket = this.processMessage(msg)) == null);
            return socket;
        }
        catch (InterruptedException ie) {
            throw new SocketException("interrupted");
        }
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public PipeAdvertisement getPipeAdv() {
        return this.pipeadv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        String string = this.closeLock;
        synchronized (string) {
            if (this.isClosed()) {
                return;
            }
            if (this.isBound()) {
                this.serverPipe.close();
            }
            this.queue.close();
            this.closed = true;
        }
    }

    protected void setBound() {
        this.bound = true;
    }

    public synchronized int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.timeout;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        String string = this.closeLock;
        synchronized (string) {
            return this.closed;
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        boolean pushed;
        block4: {
            Message message = event.getMessage();
            if (message == null) {
                return;
            }
            pushed = false;
            try {
                pushed = this.queue.push((Object)message, -1L);
            }
            catch (InterruptedException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block4;
                LOG.debug((Object)"Interrupted", (Throwable)e);
            }
        }
        if (!pushed && LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"backlog queue full, connect request dropped");
        }
    }

    private JxtaSocket processMessage(Message msg) {
        block9: {
            PipeAdvertisement outputPipeAdv = null;
            PeerAdvertisement peerAdv = null;
            StructuredDocument CredDoc = null;
            try {
                Messenger msgr;
                InputStream in;
                MessageElement el = msg.getMessageElement(nameSpace, credTag);
                if (el != null) {
                    in = el.getStream();
                    CredDoc = StructuredDocumentFactory.newStructuredDocument((MimeMediaType)el.getMimeType(), (InputStream)in);
                }
                if (CredDoc == null || !this.checkCred(CredDoc)) {
                    return null;
                }
                el = msg.getMessageElement(nameSpace, reqPipeTag);
                if (el != null) {
                    in = el.getStream();
                    outputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((MimeMediaType)el.getMimeType(), (InputStream)in);
                }
                if ((el = msg.getMessageElement(nameSpace, remPeerTag)) != null) {
                    in = el.getStream();
                    peerAdv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement((MimeMediaType)el.getMimeType(), (InputStream)in);
                }
                el = msg.getMessageElement(nameSpace, streamTag);
                boolean isStream = false;
                if (el != null) {
                    isStream = el.toString().equals("true");
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Connection request [isStream] :" + isStream));
                    }
                }
                if ((msgr = JxtaSocket.lightweightOutputPipe((PeerGroup)this.group, (PipeAdvertisement)outputPipeAdv, (PeerAdvertisement)peerAdv)) != null) {
                    PipeAdvertisement newpipe = JxtaServerSocket.newInputPipe(this.group, outputPipeAdv);
                    JxtaSocket newsoc = new JxtaSocket(this.group, msgr, newpipe, isStream);
                    this.sendResponseMessage(this.group, msgr, newpipe);
                    return newsoc;
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block9;
                LOG.debug((Object)"IOException occured", (Throwable)e);
            }
        }
        return null;
    }

    protected void sendResponseMessage(PeerGroup group, Messenger msgr, PipeAdvertisement pipeAd) throws IOException {
        block2: {
            Message msg = new Message();
            PeerAdvertisement peerAdv = group.getPeerAdvertisement();
            StructuredDocument credDoc = JxtaSocket.getCredDoc((PeerGroup)group);
            try {
                msg.addMessageElement(nameSpace, (MessageElement)new InputStreamMessageElement(credTag, MimeMediaType.XMLUTF8, credDoc.getStream(), null));
                msg.addMessageElement(nameSpace, (MessageElement)new InputStreamMessageElement(remPipeTag, MimeMediaType.XMLUTF8, pipeAd.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
                msg.addMessageElement(nameSpace, (MessageElement)new InputStreamMessageElement(remPeerTag, MimeMediaType.XMLUTF8, peerAdv.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
                msgr.sendMessage(msg);
            }
            catch (Throwable t) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                LOG.debug((Object)"error getting element stream", t);
            }
        }
    }

    private boolean checkCred(StructuredDocument cred) {
        return true;
    }

    protected static PipeAdvertisement newInputPipe(PeerGroup group, PipeAdvertisement pipeadv) {
        PipeAdvertisement adv = null;
        adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        adv.setPipeID((ID)IDFactory.newPipeID((PeerGroupID)group.getPeerGroupID()));
        adv.setName(pipeadv.getName() + ".remote");
        adv.setType(pipeadv.getType());
        return adv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

