/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services.zosmf;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.methods.RequestBuilder;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.jobs.exceptions.JobFileIdNotFoundException;
import org.zowe.jobs.model.JobFileContent;
import org.zowe.jobs.services.zosmf.AbstractZosmfJobsRequestRunner;

public class GetJobFileContentZosmfRequestRunner
extends AbstractZosmfJobsRequestRunner<JobFileContent> {
    private String jobName;
    private String jobId;
    private String fileId;

    public GetJobFileContentZosmfRequestRunner(String jobName, String jobId, String fileId, List<Header> headers) {
        super(headers);
        this.jobName = jobName;
        this.jobId = jobId;
        this.fileId = fileId;
    }

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfconnector) throws URISyntaxException {
        String urlPath = String.format("restjobs/jobs/%s/%s/files/%s/records", this.jobName, this.jobId, this.fileId);
        URI requestUrl = zosmfconnector.getFullUrl(urlPath);
        return RequestBuilder.get((URI)requestUrl);
    }

    protected JobFileContent getResult(ResponseCache responseCache) throws IOException {
        return new JobFileContent(responseCache.getEntity());
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        if (statusCode == 400 && jsonResponse.has("message")) {
            String zosmfMessage = jsonResponse.get("message").getAsString();
            if (String.format("Job '%s(%s)' does not contain spool file id %s", this.jobName, this.jobId, this.fileId).equals(zosmfMessage)) {
                return new JobFileIdNotFoundException(this.jobName, this.jobId, this.fileId);
            }
        }
        return this.createJobNotFoundExceptions(jsonResponse, statusCode, this.jobName, this.jobId);
    }
}

