/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Generated;
import org.zowe.data.sets.model.DataSetCreateRequest;
import org.zowe.data.sets.model.DataSetOrganisationType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ZosmfCreateRequest {
    private static final String PDSE_DSNTYPE = "LIBRARY";
    private String volser;
    private String unit;
    private String dsorg;
    private String dsntype;
    private String alcunit;
    private Integer primary;
    private Integer secondary;
    private Integer dirblk;
    private Integer avgblk;
    private String recfm;
    private Integer blksize;
    private Integer lrecl;

    public static ZosmfCreateRequest createFromDataSetCreateRequest(DataSetCreateRequest request) {
        ZosmfCreateRequestBuilder builder = ZosmfCreateRequest.builder().volser(request.getVolumeSerial()).unit(request.getDeviceType()).dsorg(ZosmfCreateRequest.checkDataSetOrganization(request.getDataSetOrganization().getZosmfName())).dsntype(ZosmfCreateRequest.retrieveDataSetNameType(request.getDataSetOrganization())).primary(request.getPrimary()).secondary(request.getSecondary()).dirblk(request.getDirectoryBlocks()).avgblk(request.getAverageBlock()).recfm(request.getRecordFormat()).blksize(request.getBlockSize()).lrecl(request.getRecordLength());
        switch (request.getAllocationUnit()) {
            case TRACK: {
                builder.alcunit("TRK");
                break;
            }
            case CYLINDER: {
                builder.alcunit("CYL");
                break;
            }
            default: {
                throw new IllegalArgumentException("Creating data sets with a z/OS MF connector only supports allocation unit type of track and cylinder");
            }
        }
        return builder.build();
    }

    private static String checkDataSetOrganization(String dsorg) {
        return DataSetOrganisationType.PO_E.getZosmfName().equals(dsorg) ? DataSetOrganisationType.PO.getZosmfName() : dsorg;
    }

    private static String retrieveDataSetNameType(DataSetOrganisationType dsorg) {
        return DataSetOrganisationType.PO_E == dsorg ? PDSE_DSNTYPE : null;
    }

    @Generated
    public static ZosmfCreateRequestBuilder builder() {
        return new ZosmfCreateRequestBuilder();
    }

    @Generated
    public String getVolser() {
        return this.volser;
    }

    @Generated
    public String getUnit() {
        return this.unit;
    }

    @Generated
    public String getDsorg() {
        return this.dsorg;
    }

    @Generated
    public String getDsntype() {
        return this.dsntype;
    }

    @Generated
    public String getAlcunit() {
        return this.alcunit;
    }

    @Generated
    public Integer getPrimary() {
        return this.primary;
    }

    @Generated
    public Integer getSecondary() {
        return this.secondary;
    }

    @Generated
    public Integer getDirblk() {
        return this.dirblk;
    }

    @Generated
    public Integer getAvgblk() {
        return this.avgblk;
    }

    @Generated
    public String getRecfm() {
        return this.recfm;
    }

    @Generated
    public Integer getBlksize() {
        return this.blksize;
    }

    @Generated
    public Integer getLrecl() {
        return this.lrecl;
    }

    @Generated
    public void setVolser(String volser) {
        this.volser = volser;
    }

    @Generated
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Generated
    public void setDsorg(String dsorg) {
        this.dsorg = dsorg;
    }

    @Generated
    public void setDsntype(String dsntype) {
        this.dsntype = dsntype;
    }

    @Generated
    public void setAlcunit(String alcunit) {
        this.alcunit = alcunit;
    }

    @Generated
    public void setPrimary(Integer primary) {
        this.primary = primary;
    }

    @Generated
    public void setSecondary(Integer secondary) {
        this.secondary = secondary;
    }

    @Generated
    public void setDirblk(Integer dirblk) {
        this.dirblk = dirblk;
    }

    @Generated
    public void setAvgblk(Integer avgblk) {
        this.avgblk = avgblk;
    }

    @Generated
    public void setRecfm(String recfm) {
        this.recfm = recfm;
    }

    @Generated
    public void setBlksize(Integer blksize) {
        this.blksize = blksize;
    }

    @Generated
    public void setLrecl(Integer lrecl) {
        this.lrecl = lrecl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZosmfCreateRequest)) {
            return false;
        }
        ZosmfCreateRequest other = (ZosmfCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$primary = this.getPrimary();
        Integer other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !((Object)this$primary).equals(other$primary)) {
            return false;
        }
        Integer this$secondary = this.getSecondary();
        Integer other$secondary = other.getSecondary();
        if (this$secondary == null ? other$secondary != null : !((Object)this$secondary).equals(other$secondary)) {
            return false;
        }
        Integer this$dirblk = this.getDirblk();
        Integer other$dirblk = other.getDirblk();
        if (this$dirblk == null ? other$dirblk != null : !((Object)this$dirblk).equals(other$dirblk)) {
            return false;
        }
        Integer this$avgblk = this.getAvgblk();
        Integer other$avgblk = other.getAvgblk();
        if (this$avgblk == null ? other$avgblk != null : !((Object)this$avgblk).equals(other$avgblk)) {
            return false;
        }
        Integer this$blksize = this.getBlksize();
        Integer other$blksize = other.getBlksize();
        if (this$blksize == null ? other$blksize != null : !((Object)this$blksize).equals(other$blksize)) {
            return false;
        }
        Integer this$lrecl = this.getLrecl();
        Integer other$lrecl = other.getLrecl();
        if (this$lrecl == null ? other$lrecl != null : !((Object)this$lrecl).equals(other$lrecl)) {
            return false;
        }
        String this$volser = this.getVolser();
        String other$volser = other.getVolser();
        if (this$volser == null ? other$volser != null : !this$volser.equals(other$volser)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$dsorg = this.getDsorg();
        String other$dsorg = other.getDsorg();
        if (this$dsorg == null ? other$dsorg != null : !this$dsorg.equals(other$dsorg)) {
            return false;
        }
        String this$dsntype = this.getDsntype();
        String other$dsntype = other.getDsntype();
        if (this$dsntype == null ? other$dsntype != null : !this$dsntype.equals(other$dsntype)) {
            return false;
        }
        String this$alcunit = this.getAlcunit();
        String other$alcunit = other.getAlcunit();
        if (this$alcunit == null ? other$alcunit != null : !this$alcunit.equals(other$alcunit)) {
            return false;
        }
        String this$recfm = this.getRecfm();
        String other$recfm = other.getRecfm();
        return !(this$recfm == null ? other$recfm != null : !this$recfm.equals(other$recfm));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZosmfCreateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : ((Object)$primary).hashCode());
        Integer $secondary = this.getSecondary();
        result = result * 59 + ($secondary == null ? 43 : ((Object)$secondary).hashCode());
        Integer $dirblk = this.getDirblk();
        result = result * 59 + ($dirblk == null ? 43 : ((Object)$dirblk).hashCode());
        Integer $avgblk = this.getAvgblk();
        result = result * 59 + ($avgblk == null ? 43 : ((Object)$avgblk).hashCode());
        Integer $blksize = this.getBlksize();
        result = result * 59 + ($blksize == null ? 43 : ((Object)$blksize).hashCode());
        Integer $lrecl = this.getLrecl();
        result = result * 59 + ($lrecl == null ? 43 : ((Object)$lrecl).hashCode());
        String $volser = this.getVolser();
        result = result * 59 + ($volser == null ? 43 : $volser.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $dsorg = this.getDsorg();
        result = result * 59 + ($dsorg == null ? 43 : $dsorg.hashCode());
        String $dsntype = this.getDsntype();
        result = result * 59 + ($dsntype == null ? 43 : $dsntype.hashCode());
        String $alcunit = this.getAlcunit();
        result = result * 59 + ($alcunit == null ? 43 : $alcunit.hashCode());
        String $recfm = this.getRecfm();
        result = result * 59 + ($recfm == null ? 43 : $recfm.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ZosmfCreateRequest(volser=" + this.getVolser() + ", unit=" + this.getUnit() + ", dsorg=" + this.getDsorg() + ", dsntype=" + this.getDsntype() + ", alcunit=" + this.getAlcunit() + ", primary=" + this.getPrimary() + ", secondary=" + this.getSecondary() + ", dirblk=" + this.getDirblk() + ", avgblk=" + this.getAvgblk() + ", recfm=" + this.getRecfm() + ", blksize=" + this.getBlksize() + ", lrecl=" + this.getLrecl() + ")";
    }

    @Generated
    public ZosmfCreateRequest() {
    }

    @Generated
    public ZosmfCreateRequest(String volser, String unit, String dsorg, String dsntype, String alcunit, Integer primary, Integer secondary, Integer dirblk, Integer avgblk, String recfm, Integer blksize, Integer lrecl) {
        this.volser = volser;
        this.unit = unit;
        this.dsorg = dsorg;
        this.dsntype = dsntype;
        this.alcunit = alcunit;
        this.primary = primary;
        this.secondary = secondary;
        this.dirblk = dirblk;
        this.avgblk = avgblk;
        this.recfm = recfm;
        this.blksize = blksize;
        this.lrecl = lrecl;
    }

    @Generated
    public static class ZosmfCreateRequestBuilder {
        @Generated
        private String volser;
        @Generated
        private String unit;
        @Generated
        private String dsorg;
        @Generated
        private String dsntype;
        @Generated
        private String alcunit;
        @Generated
        private Integer primary;
        @Generated
        private Integer secondary;
        @Generated
        private Integer dirblk;
        @Generated
        private Integer avgblk;
        @Generated
        private String recfm;
        @Generated
        private Integer blksize;
        @Generated
        private Integer lrecl;

        @Generated
        ZosmfCreateRequestBuilder() {
        }

        @Generated
        public ZosmfCreateRequestBuilder volser(String volser) {
            this.volser = volser;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder dsorg(String dsorg) {
            this.dsorg = dsorg;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder dsntype(String dsntype) {
            this.dsntype = dsntype;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder alcunit(String alcunit) {
            this.alcunit = alcunit;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder primary(Integer primary) {
            this.primary = primary;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder secondary(Integer secondary) {
            this.secondary = secondary;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder dirblk(Integer dirblk) {
            this.dirblk = dirblk;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder avgblk(Integer avgblk) {
            this.avgblk = avgblk;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder recfm(String recfm) {
            this.recfm = recfm;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder blksize(Integer blksize) {
            this.blksize = blksize;
            return this;
        }

        @Generated
        public ZosmfCreateRequestBuilder lrecl(Integer lrecl) {
            this.lrecl = lrecl;
            return this;
        }

        @Generated
        public ZosmfCreateRequest build() {
            return new ZosmfCreateRequest(this.volser, this.unit, this.dsorg, this.dsntype, this.alcunit, this.primary, this.secondary, this.dirblk, this.avgblk, this.recfm, this.blksize, this.lrecl);
        }

        @Generated
        public String toString() {
            return "ZosmfCreateRequest.ZosmfCreateRequestBuilder(volser=" + this.volser + ", unit=" + this.unit + ", dsorg=" + this.dsorg + ", dsntype=" + this.dsntype + ", alcunit=" + this.alcunit + ", primary=" + this.primary + ", secondary=" + this.secondary + ", dirblk=" + this.dirblk + ", avgblk=" + this.avgblk + ", recfm=" + this.recfm + ", blksize=" + this.blksize + ", lrecl=" + this.lrecl + ")";
        }
    }
}

