/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.methods.RequestBuilder;
import org.springframework.util.Base64Utils;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.unix.files.exceptions.NotAFileException;
import org.zowe.unix.files.model.UnixFileContent;
import org.zowe.unix.files.model.UnixFileContentWithETag;
import org.zowe.unix.files.services.zosmf.AbstractZosmfUnixFilesRequestRunner;

public class GetUnixFileContentZosmfRunner
extends AbstractZosmfUnixFilesRequestRunner<UnixFileContentWithETag> {
    private String path;
    private boolean convert;
    private boolean decode;

    public GetUnixFileContentZosmfRunner(String path, boolean convert, boolean decode, List<Header> headers) {
        super(headers);
        this.path = path;
        this.convert = convert;
        this.decode = decode;
    }

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException {
        URI requestUrl = zosmfConnector.getFullUrl("restfiles/fs" + this.path);
        RequestBuilder requestBuilder = RequestBuilder.get((URI)requestUrl);
        if (this.convert) {
            requestBuilder.addHeader("X-IBM-Data-Type", "binary");
        }
        return requestBuilder;
    }

    private UnixFileContent getContent(ResponseCache responseCache) {
        String content = responseCache.getEntity();
        if (this.decode) {
            String decodedContent = new String(Base64Utils.decodeFromString((String)content));
            return new UnixFileContent(decodedContent);
        }
        return new UnixFileContent(content);
    }

    protected UnixFileContentWithETag getResult(ResponseCache responseCache) throws IOException {
        UnixFileContent content = this.getContent(responseCache);
        String eTag = null;
        Header eTagHeader = responseCache.getFirstHeader("ETag");
        if (eTagHeader != null) {
            eTag = eTagHeader.getValue();
        }
        return new UnixFileContentWithETag(content, eTag);
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        JsonElement details = jsonResponse.get("details");
        if (details.getAsString().contains("EDC5121I Invalid argument.")) {
            throw new NotAFileException(this.path);
        }
        return this.createUnixFileException(jsonResponse, statusCode, this.path);
    }
}

