/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.http.HttpStatus;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.JsonUtils;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.data.sets.exceptions.InvalidDirectoryBlockException;
import org.zowe.data.sets.model.DataSetCreateRequest;
import org.zowe.data.sets.model.DataSetOrganisationType;
import org.zowe.data.sets.model.ZosmfCreateRequest;
import org.zowe.data.sets.services.zosmf.AbstractZosmfDataSetsRequestRunner;

public class CreateDataSetZosmfRequestRunner
extends AbstractZosmfDataSetsRequestRunner<String> {
    private DataSetCreateRequest request;
    private String dataSetName;

    public CreateDataSetZosmfRequestRunner(DataSetCreateRequest request, List<Header> headers) {
        super(headers);
        this.request = request;
        this.dataSetName = request.getName();
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        if (this.request.getDataSetOrganization() == DataSetOrganisationType.PS && this.request.getDirectoryBlocks() != null && this.request.getDirectoryBlocks() != 0) {
            throw new InvalidDirectoryBlockException(this.dataSetName);
        }
        String urlPath = String.format("restfiles/ds/%s", this.dataSetName);
        URI requestUrl = zosmfConnector.getFullUrl(urlPath);
        JsonObject requestBody = this.convertIntoZosmfRequestJson(this.request);
        StringEntity requestEntity = new StringEntity(requestBody.toString(), ContentType.APPLICATION_JSON);
        RequestBuilder requestBuilder = RequestBuilder.post((URI)requestUrl).setEntity((HttpEntity)requestEntity);
        return requestBuilder;
    }

    protected int[] getSuccessStatus() {
        return new int[]{201};
    }

    protected String getResult(ResponseCache responseCache) throws IOException {
        return this.dataSetName;
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        return new ZoweApiRestException(HttpStatus.resolve((int)statusCode), jsonResponse.toString(), new Object[0]);
    }

    private JsonObject convertIntoZosmfRequestJson(DataSetCreateRequest input) throws IOException {
        ZosmfCreateRequest request = ZosmfCreateRequest.createFromDataSetCreateRequest((DataSetCreateRequest)input);
        return JsonUtils.convertToJsonObject((Object)request);
    }
}

