/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.mapper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.mapstruct.Qualifier;
import org.zowe.data.sets.model.AllocationUnitType;
import org.zowe.data.sets.model.DataSetOrganisationType;

public class FieldMapper {
    public String name(JsonObject in) {
        return this.getStringOrNull(in, "dsname");
    }

    public boolean migrated(JsonObject in) {
        return "YES".equals(this.getStringOrNull(in, "migr"));
    }

    public Integer blocksize(JsonObject in) {
        return this.getIntegerOrNull(in, "blksz");
    }

    public String catalogName(JsonObject in) {
        return this.getStringOrNull(in, "catnm");
    }

    public String volumeSerial(JsonObject in) {
        return this.getStringOrNull(in, "vols");
    }

    public String deviceType(JsonObject in) {
        return this.getStringOrNull(in, "dev");
    }

    public DataSetOrganisationType dataSetOrganization(JsonObject in) {
        DataSetOrganisationType value = null;
        String dsorg2 = this.getStringOrNull(in, "dsorg");
        if (dsorg2 != null) {
            value = DataSetOrganisationType.getByZosmfName((String)dsorg2);
        }
        return value;
    }

    public AllocationUnitType allocationUnit(JsonObject in) {
        AllocationUnitType value = null;
        String spacu2 = this.getStringOrNull(in, "spacu");
        if (spacu2 != null) {
            value = AllocationUnitType.valueOf((String)spacu2.substring(0, spacu2.length() - 1));
        }
        return value;
    }

    public String expirationDate(JsonObject in) {
        return this.getStringOrNull(in, "edate");
    }

    public String creationDate(JsonObject in) {
        return this.getStringOrNull(in, "cdate");
    }

    public Integer recordLength(JsonObject in) {
        return this.getIntegerOrNull(in, "lrecl");
    }

    public String recordFormat(JsonObject in) {
        return this.getStringOrNull(in, "recfm");
    }

    public Integer allocatedSize(JsonObject in) {
        return this.getIntegerOrNull(in, "sizex");
    }

    public Integer used(JsonObject in) {
        return this.getIntegerOrNull(in, "used");
    }

    private Integer getIntegerOrNull(JsonObject json, String key) {
        Integer value = null;
        JsonElement jsonElement = json.get(key);
        if (jsonElement != null && !jsonElement.isJsonNull() && !jsonElement.getAsString().equals("?")) {
            value = jsonElement.getAsInt();
        }
        return value;
    }

    private String getStringOrNull(JsonObject json, String key) {
        String value = null;
        JsonElement jsonElement = json.get(key);
        if (jsonElement != null && !jsonElement.isJsonNull() && !jsonElement.getAsString().equals("?") && (value = jsonElement.getAsString()).equals("?")) {
            value = null;
        }
        return value;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface used {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface sizex {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface recfm {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface lrecl {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface cdate {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface edate {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface spacu {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface dsorg {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface dev {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface vols {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface catnm {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface blksz {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface migr {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface dsname {
    }
}

