/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.services.zosmf;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.util.StringUtils;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.PreconditionFailedException;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.unix.files.model.UnixFileContent;
import org.zowe.unix.files.model.UnixFileContentWithETag;
import org.zowe.unix.files.services.zosmf.AbstractZosmfUnixFilesRequestRunner;

public class PutUnixFileContentZosmfRunner
extends AbstractZosmfUnixFilesRequestRunner<String> {
    private String path;
    private UnixFileContentWithETag contentWithETag;
    private boolean convert;

    public PutUnixFileContentZosmfRunner(String path, UnixFileContentWithETag content, Boolean convert, List<Header> headers) {
        super(headers);
        this.path = path;
        this.contentWithETag = content;
        this.convert = convert;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        URI requestUrl = zosmfConnector.getFullUrl("restfiles/fs" + this.path);
        UnixFileContent content = this.contentWithETag.getContent();
        StringEntity requestEntity = new StringEntity(content.getContent());
        RequestBuilder requestBuilder = RequestBuilder.put((URI)requestUrl).setEntity((HttpEntity)requestEntity);
        String ifMatch = this.contentWithETag.getETag();
        if (StringUtils.hasText((String)ifMatch)) {
            requestBuilder.addHeader("If-Match", ifMatch.replaceAll("\"", ""));
        }
        requestBuilder.addHeader("Content-type", ContentType.TEXT_PLAIN.getMimeType());
        if (this.convert) {
            requestBuilder.addHeader("X-IBM-Data-Type", "binary");
        }
        return requestBuilder;
    }

    protected int[] getSuccessStatus() {
        return new int[]{204};
    }

    protected String getResult(ResponseCache responseCache) throws IOException {
        return responseCache.getFirstHeader("ETag").getValue();
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) throws IOException {
        return this.createUnixFileException(jsonResponse, statusCode, this.path);
    }

    protected ZoweApiRestException createGeneralException(ResponseCache responseCache, URI uri) throws IOException {
        if (responseCache.getStatus() == 412) {
            throw new PreconditionFailedException(this.path);
        }
        return super.createGeneralException(responseCache, uri);
    }
}

