/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.services.zosmf;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.unix.files.services.zosmf.AbstractZosmfUnixFilesRequestRunner;

public class GetUnixFileChtagZosmfRunner
extends AbstractZosmfUnixFilesRequestRunner<String> {
    private String path;

    public GetUnixFileChtagZosmfRunner(String path, List<Header> headers) {
        super(headers);
        this.path = path;
    }

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        URI requestUrl = zosmfConnector.getFullUrl("restfiles/fs" + this.path);
        StringEntity requestEntity = new StringEntity("{ \"request\": \"chtag\", \"action\": \"list\" }");
        RequestBuilder requestBuilder = RequestBuilder.put((URI)requestUrl);
        requestBuilder.setEntity((HttpEntity)requestEntity);
        requestBuilder.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        return requestBuilder;
    }

    protected String getResult(ResponseCache responseCache) throws IOException {
        String codepage = responseCache.getEntityAsJsonObject().get("stdout").getAsString();
        return codepage;
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) throws IOException {
        return this.createUnixFileException(jsonResponse, statusCode, this.path);
    }
}

