/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.services.zosmf;

import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.unix.files.model.UnixCreateAssetRequest;
import org.zowe.unix.files.model.UnixDirectoryAttributesWithChildren;
import org.zowe.unix.files.model.UnixFileContentWithETag;
import org.zowe.unix.files.services.UnixFilesService;
import org.zowe.unix.files.services.zosmf.CreateUnixAssetZosmfRunner;
import org.zowe.unix.files.services.zosmf.DeleteUnixFileZosmfRunner;
import org.zowe.unix.files.services.zosmf.GetUnixFileChtagZosmfRunner;
import org.zowe.unix.files.services.zosmf.GetUnixFileContentZosmfRunner;
import org.zowe.unix.files.services.zosmf.ListUnixDirectoryZosmfRunner;
import org.zowe.unix.files.services.zosmf.PutUnixFileContentZosmfRunner;

public abstract class AbstractZosmfUnixFilesService
extends UnixFilesService {
    abstract ZosmfConnector getZosmfConnector();

    @Override
    public UnixDirectoryAttributesWithChildren listUnixDirectory(String path, String hypermediaLinkToBase) {
        ListUnixDirectoryZosmfRunner runner = new ListUnixDirectoryZosmfRunner(path, hypermediaLinkToBase, this.getIbmHeadersFromRequest());
        return (UnixDirectoryAttributesWithChildren)runner.run(this.getZosmfConnector());
    }

    @Override
    public UnixFileContentWithETag getUnixFileContentWithETag(String path, boolean convert, boolean decode) {
        GetUnixFileContentZosmfRunner runner = new GetUnixFileContentZosmfRunner(path, convert, decode, this.getIbmHeadersFromRequest());
        return (UnixFileContentWithETag)runner.run(this.getZosmfConnector());
    }

    @Override
    public String putUnixFileContent(String path, UnixFileContentWithETag content, boolean convert) {
        PutUnixFileContentZosmfRunner runner = new PutUnixFileContentZosmfRunner(path, content, convert, this.getIbmHeadersFromRequest());
        return (String)runner.run(this.getZosmfConnector());
    }

    @Override
    public boolean shouldUnixFileConvert(String path) {
        String codepage = this.getUnixFileChtag(path);
        return codepage.contains("ISO8859") || codepage.contains("IBM-850") || codepage.contains("UTF");
    }

    @Override
    public String getUnixFileChtag(String path) {
        GetUnixFileChtagZosmfRunner runner = new GetUnixFileChtagZosmfRunner(path, this.getIbmHeadersFromRequest());
        return (String)runner.run(this.getZosmfConnector());
    }

    @Override
    public void deleteUnixFileContent(String path, boolean isRecursive) {
        DeleteUnixFileZosmfRunner runner = new DeleteUnixFileZosmfRunner(path, isRecursive, this.getIbmHeadersFromRequest());
        runner.run(this.getZosmfConnector());
    }

    @Override
    public void createUnixAsset(String path, UnixCreateAssetRequest request) {
        CreateUnixAssetZosmfRunner runner = new CreateUnixAssetZosmfRunner(path, request, this.getIbmHeadersFromRequest());
        runner.run(this.getZosmfConnector());
    }
}

