/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class JsonUtils {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final JsonParser parser = new JsonParser();

    public static <T> T convertString(String streamContent, Class<T> outputType) throws IOException {
        return (T)jsonMapper.readValue(streamContent, outputType);
    }

    public static <T> T convertFilePath(Path filePath, Class<T> outputType) throws IOException {
        return (T)jsonMapper.readValue(filePath.toFile(), outputType);
    }

    public static String convertToJsonString(Object o) throws JsonProcessingException {
        return jsonMapper.writeValueAsString(o);
    }

    public static JsonObject convertToJsonObject(Object o) throws IOException {
        return JsonUtils.readAsJsonElement(JsonUtils.convertToJsonString(o)).getAsJsonObject();
    }

    public static JsonElement readFileAsJsonElement(Path filePath) throws JsonSyntaxException, IOException {
        return JsonUtils.readAsJsonElement(new String(Files.readAllBytes(filePath)));
    }

    public static JsonElement readAsJsonElement(String string) throws JsonSyntaxException {
        return parser.parse(string);
    }
}

