/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.exceptions;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.HtmlUtils;
import org.zowe.api.common.errors.ApiError;
import org.zowe.api.common.exceptions.ZoweApiException;

public class ZoweApiRestException
extends ZoweApiException {
    private static final long serialVersionUID = -5142352192545942244L;
    private HttpStatus status;

    public ZoweApiRestException(HttpStatus status, String message, Object ... messageArguments) {
        super(message, messageArguments);
        this.status = status;
    }

    public ApiError getApiError() {
        return ApiError.builder().status(this.status).message(this.getMessage()).build();
    }

    protected static String htmlEncodeString(String string) throws UnsupportedEncodingException {
        return HtmlUtils.htmlEscape((String)URLDecoder.decode(string, StandardCharsets.UTF_8.name()));
    }
}

