/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.util;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.zowe.apiml.util.Recorder;

public class TestLogger
extends AppenderBase<ILoggingEvent>
implements Recorder<ILoggingEvent> {
    private static AtomicReference<TestLogger> lastInstance = new AtomicReference();
    private boolean listening;
    private List<ILoggingEvent> records;

    public TestLogger() {
        if (lastInstance.get() != null) {
            this.listening = TestLogger.lastInstance.get().listening;
            this.records = TestLogger.lastInstance.get().records;
        } else {
            this.records = new LinkedList<ILoggingEvent>();
        }
        lastInstance.set(this);
    }

    protected void append(ILoggingEvent eventObject) {
        if (this.listening) {
            this.records.add(eventObject);
        }
    }

    public static Recorder<ILoggingEvent> getHandler() {
        return lastInstance.getAndUpdate(x -> x == null ? new TestLogger() : x);
    }

    @Override
    public void startRecording() {
        this.listening = true;
    }

    @Override
    public void stopRecording() {
        this.records.clear();
        this.listening = false;
    }

    @Override
    public Optional<ILoggingEvent> findFirst(Predicate<ILoggingEvent> filter) {
        return this.records.stream().filter(filter).findFirst();
    }

    @Override
    public Optional<ILoggingEvent> findFirst(String messageInfix) {
        return this.records.stream().filter(x -> x.getMessage().contains(messageInfix)).findFirst();
    }

    @Override
    public List<ILoggingEvent> find(Predicate<ILoggingEvent> filter) {
        return this.records.stream().filter(filter).toList();
    }

    @Override
    public List<ILoggingEvent> find(String messageInfix) {
        return this.records.stream().filter(x -> x.getMessage().contains(messageInfix)).toList();
    }
}

