/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.gateway;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.zowe.apiml.gateway.MockService;

public class ApplicationRegistry {
    private final Map<String, MockService> instanceIdToService = Collections.synchronizedMap(new HashMap());

    public boolean remove(MockService mockService) {
        boolean removed = false;
        Iterator<Map.Entry<String, MockService>> i = this.instanceIdToService.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, MockService> entry = i.next();
            if (entry.getValue() != mockService) continue;
            i.remove();
            removed = true;
        }
        return removed;
    }

    public boolean update(MockService mockService) {
        switch (mockService.getStatus()) {
            case STARTED: 
            case ZOMBIE: {
                if (this.instanceIdToService.get(mockService.getInstanceId()) == mockService) {
                    return false;
                }
                this.remove(mockService);
                this.instanceIdToService.put(mockService.getInstanceId(), mockService);
                return true;
            }
            case STOPPED: 
            case CANCELLING: {
                return this.remove(mockService);
            }
        }
        throw new IllegalStateException("Unsupported status: " + String.valueOf((Object)mockService.getStatus()));
    }

    public Collection<MockService> getMockServices() {
        return this.instanceIdToService.values();
    }

    public Application getApplication(String serviceId) {
        Application application = new Application();
        application.setName(serviceId);
        this.instanceIdToService.values().stream().filter(i -> StringUtils.equalsIgnoreCase((CharSequence)serviceId, (CharSequence)i.getServiceId())).map(MockService::getInstanceInfo).forEach(arg_0 -> ((Application)application).addInstance(arg_0));
        return application;
    }

    public Applications getApplications() {
        Applications applications = new Applications();
        this.instanceIdToService.values().stream().map(MockService::getServiceId).distinct().map(this::getApplication).forEach(arg_0 -> ((Applications)applications).addApplication(arg_0));
        return applications;
    }

    public List<InstanceInfo> getInstances() {
        return this.instanceIdToService.values().stream().map(MockService::getInstanceInfo).toList();
    }

    public List<ServiceInstance> getServiceInstance(String serviceId) {
        return this.instanceIdToService.values().stream().filter(ms -> StringUtils.equalsIgnoreCase((CharSequence)serviceId, (CharSequence)ms.getServiceId())).map(MockService::getEurekaServiceInstance).collect(Collectors.toList());
    }

    public boolean afterTest() {
        boolean anyChange = false;
        Iterator<Map.Entry<String, MockService>> i = this.instanceIdToService.entrySet().iterator();
        while (i.hasNext()) {
            MockService mockService = i.next().getValue();
            if (mockService.getScope() != MockService.Scope.TEST) continue;
            i.remove();
            mockService.close();
            anyChange = true;
        }
        return anyChange;
    }

    public boolean afterClass() {
        boolean anyChange = !this.instanceIdToService.isEmpty();
        this.instanceIdToService.values().forEach(MockService::close);
        this.instanceIdToService.clear();
        return anyChange;
    }
}

