/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.gateway;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import com.netflix.appinfo.InstanceInfo;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;
import org.assertj.core.error.MultipleAssertionsError;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.netflix.eureka.EurekaServiceInstance;
import org.zowe.apiml.auth.AuthenticationScheme;

public class MockService
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockService.class);
    private static int idCounter = 1;
    private int port;
    private HttpServer server;
    private List<Endpoint> endpointsConfig;
    private String serviceId;
    private String vipAddress;
    private String hostname;
    private String gatewayUrl;
    private String serviceUrl;
    private AuthenticationScheme authenticationScheme;
    private String applid;
    private Scope scope;
    private List<Consumer<MockService>> statusChangedlisteners;
    private final Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.STOPPED);
    private static AssertionError assertionError;

    private void init() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(0), 0);
        this.endpoints.clear();
        this.endpointsConfig.forEach(endpoint -> {
            if (this.endpoints.put(endpoint.getPath(), (Endpoint)endpoint) != null) {
                throw new IllegalStateException("Duplicity of endpoints: " + endpoint.getPath());
            }
            this.server.createContext(endpoint.getPath(), endpoint::process);
        });
        if (this.gatewayUrl == null) {
            this.gatewayUrl = "api/v1";
        }
        if (this.serviceUrl == null) {
            this.serviceUrl = "/" + this.serviceId;
        }
        this.server.setExecutor(null);
    }

    public Status getStatus() {
        return this.status.get();
    }

    public String getInstanceId() {
        return this.hostname + ":" + this.getServiceId() + ":" + this.port;
    }

    private void fireStatusChanged() {
        if (this.statusChangedlisteners != null) {
            this.statusChangedlisteners.forEach(l -> l.accept(this));
        }
    }

    private static void setAssertionError(AssertionError assertionError) {
        if (MockService.assertionError == null) {
            MockService.assertionError = assertionError;
        } else {
            LinkedList<AssertionError> allErrors = new LinkedList<AssertionError>();
            if (MockService.assertionError instanceof MultipleAssertionsError) {
                allErrors.addAll(((MultipleAssertionsError)MockService.assertionError).getErrors());
            }
            allErrors.add(assertionError);
            MockService.assertionError = new MultipleAssertionsError(allErrors);
        }
    }

    public static void checkAssertionErrors() {
        AssertionError assertionError = MockService.assertionError;
        if (assertionError != null) {
            MockService.assertionError = null;
            throw assertionError;
        }
    }

    private void setStatus(Status status) {
        if (this.status.get() != status) {
            this.status.set(status);
            this.fireStatusChanged();
        }
    }

    public void start() throws IOException {
        if (!this.status.get().isUp()) {
            this.init();
            this.server.start();
            this.port = this.server.getAddress().getPort();
        }
        this.setStatus(Status.STARTED);
    }

    public void stop() {
        if (this.status.get().isUp()) {
            this.server.stop(0);
        }
        this.setStatus(Status.STOPPED);
    }

    public void zombie() {
        if (this.status.get().isUp()) {
            this.server.stop(0);
        }
        this.setStatus(Status.ZOMBIE);
    }

    public Endpoint getEndpoint() {
        Assertions.assertEquals((int)1, (int)this.endpoints.size(), (String)"There are more than one endpoint, please use method getEndpoints and select one");
        return this.endpoints.values().stream().findFirst().get();
    }

    public int getCounter() {
        int out = 0;
        for (Endpoint endpoint : this.endpoints.values()) {
            out += endpoint.getCounter();
        }
        return out;
    }

    public void resetCounter() {
        this.endpoints.values().forEach(Endpoint::resetCounter);
    }

    public void cleanStatusChangedListeners() {
        this.statusChangedlisteners = null;
    }

    @Override
    public void close() {
        this.cleanStatusChangedListeners();
        this.stop();
        this.status.set(Status.CANCELLING);
    }

    private Map<String, String> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("apiml.routes.api-v1.gatewayUrl", "api/v1");
        metadata.put("apiml.routes.api-v1.serviceUrl", "/" + this.serviceId);
        if (this.authenticationScheme != null) {
            metadata.put("apiml.authentication.scheme", this.authenticationScheme.getScheme());
        }
        if (this.applid != null) {
            metadata.put("apiml.authentication.applid", this.applid);
        }
        return metadata;
    }

    public InstanceInfo getInstanceInfo() {
        return InstanceInfo.Builder.newBuilder().setInstanceId(this.getInstanceId()).setHostName(this.hostname).setPort(this.port).setAppName(this.serviceId).setVIPAddress(this.vipAddress != null ? this.vipAddress : this.serviceId).setStatus(InstanceInfo.InstanceStatus.UP).setMetadata(this.getMetadata()).build();
    }

    public EurekaServiceInstance getEurekaServiceInstance() {
        InstanceInfo instanceInfo = this.getInstanceInfo();
        return instanceInfo == null ? null : new EurekaServiceInstance(instanceInfo);
    }

    @Generated
    private static String $default$hostname() {
        return "localhost";
    }

    @Generated
    private static Scope $default$scope() {
        return Scope.TEST;
    }

    @Generated
    MockService(int port, HttpServer server, List<Endpoint> endpointsConfig, String serviceId, String vipAddress, String hostname, String gatewayUrl, String serviceUrl, AuthenticationScheme authenticationScheme, String applid, Scope scope, List<Consumer<MockService>> statusChangedlisteners) {
        this.port = port;
        this.server = server;
        this.endpointsConfig = endpointsConfig;
        this.serviceId = serviceId;
        this.vipAddress = vipAddress;
        this.hostname = hostname;
        this.gatewayUrl = gatewayUrl;
        this.serviceUrl = serviceUrl;
        this.authenticationScheme = authenticationScheme;
        this.applid = applid;
        this.scope = scope;
        this.statusChangedlisteners = statusChangedlisteners;
    }

    @Generated
    public static MockServiceBuilder builder() {
        return new MockServiceBuilder();
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getVipAddress() {
        return this.vipAddress;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    @Generated
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Generated
    public AuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    @Generated
    public String getApplid() {
        return this.applid;
    }

    @Generated
    public Scope getScope() {
        return this.scope;
    }

    @Generated
    public Map<String, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public static enum Status {
        STOPPED,
        STARTED,
        CANCELLING,
        ZOMBIE;


        public boolean isUp() {
            return this == STARTED;
        }
    }

    public static final class Endpoint {
        private final int responseCode;
        private final String contentType;
        private final Headers headers;
        private final String body;
        private final String path;
        private final List<Consumer<HttpExchange>> assertions;
        private final AtomicInteger counter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void process(HttpExchange httpExchange) throws IOException {
            block13: {
                try {
                    if (this.contentType != null) {
                        httpExchange.getResponseHeaders().add("Content-Type", this.contentType);
                    }
                    if (this.assertions != null) {
                        this.assertions.forEach(assertion -> {
                            try {
                                assertion.accept(httpExchange);
                            }
                            catch (AssertionError afe) {
                                MockService.setAssertionError(afe);
                            }
                        });
                    }
                    byte[] bodyBytes = this.body == null ? null : this.body.getBytes(StandardCharsets.UTF_8);
                    log.debug("Request headers: " + Joiner.on((String)",").withKeyValueSeparator("=").join((Map)httpExchange.getRequestHeaders()));
                    log.debug("Response headers: " + Joiner.on((String)",").withKeyValueSeparator("=").join((Map)httpExchange.getResponseHeaders()));
                    for (Map.Entry<String, List<String>> headerEntry : this.headers.entrySet()) {
                        for (String value : headerEntry.getValue()) {
                            httpExchange.getResponseHeaders().add(headerEntry.getKey(), value);
                        }
                    }
                    httpExchange.sendResponseHeaders(this.responseCode, bodyBytes == null ? 0L : (long)bodyBytes.length);
                    if (bodyBytes == null) break block13;
                    try (OutputStream os = httpExchange.getResponseBody();){
                        os.write(bodyBytes);
                    }
                }
                finally {
                    this.counter.getAndIncrement();
                    httpExchange.close();
                }
            }
        }

        public int getCounter() {
            return this.counter.get();
        }

        public void resetCounter() {
            this.counter.set(0);
        }

        @Generated
        private static int $default$responseCode() {
            return 200;
        }

        @Generated
        private static Headers $default$headers() {
            return new Headers();
        }

        @Generated
        private static AtomicInteger $default$counter() {
            return new AtomicInteger();
        }

        @Generated
        Endpoint(int responseCode, String contentType, Headers headers, String body, String path, List<Consumer<HttpExchange>> assertions, AtomicInteger counter) {
            this.responseCode = responseCode;
            this.contentType = contentType;
            this.headers = headers;
            this.body = body;
            this.path = path;
            this.assertions = assertions;
            this.counter = counter;
        }

        @Generated
        public static EndpointBuilder builder() {
            return new EndpointBuilder();
        }

        @Generated
        public int getResponseCode() {
            return this.responseCode;
        }

        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Generated
        public Headers getHeaders() {
            return this.headers;
        }

        @Generated
        public String getBody() {
            return this.body;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public List<Consumer<HttpExchange>> getAssertions() {
            return this.assertions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Endpoint)) {
                return false;
            }
            Endpoint other = (Endpoint)o;
            if (this.getResponseCode() != other.getResponseCode()) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            Headers this$headers = this.getHeaders();
            Headers other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            List<Consumer<HttpExchange>> this$assertions = this.getAssertions();
            List<Consumer<HttpExchange>> other$assertions = other.getAssertions();
            if (this$assertions == null ? other$assertions != null : !((Object)this$assertions).equals(other$assertions)) {
                return false;
            }
            return this.getCounter() == other.getCounter();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getResponseCode();
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            Headers $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            List<Consumer<HttpExchange>> $assertions = this.getAssertions();
            result = result * 59 + ($assertions == null ? 43 : ((Object)$assertions).hashCode());
            result = result * 59 + this.getCounter();
            return result;
        }

        @Generated
        public String toString() {
            return "MockService.Endpoint(responseCode=" + this.getResponseCode() + ", contentType=" + this.getContentType() + ", headers=" + String.valueOf(this.getHeaders()) + ", body=" + this.getBody() + ", path=" + this.getPath() + ", assertions=" + String.valueOf(this.getAssertions()) + ", counter=" + this.getCounter() + ")";
        }

        public static class EndpointBuilder {
            @Generated
            private boolean responseCode$set;
            @Generated
            private int responseCode$value;
            @Generated
            private String contentType;
            @Generated
            private boolean headers$set;
            @Generated
            private Headers headers$value;
            @Generated
            private String body;
            @Generated
            private String path;
            @Generated
            private ArrayList<Consumer<HttpExchange>> assertions;
            @Generated
            private boolean counter$set;
            @Generated
            private AtomicInteger counter$value;
            private MockServiceBuilder mockServiceBuilder;

            public MockServiceBuilder and() {
                Endpoint endpoint = this.build();
                this.mockServiceBuilder.endpoints.add(endpoint);
                return this.mockServiceBuilder;
            }

            public EndpointBuilder bodyJson(Object body) throws JsonProcessingException {
                if (body == null) {
                    return this.body(null);
                }
                ObjectWriter writer = new ObjectMapper().writer();
                this.contentType("application/json");
                return this.body(writer.writeValueAsString(body));
            }

            @Generated
            EndpointBuilder() {
            }

            @Generated
            public EndpointBuilder responseCode(int responseCode) {
                this.responseCode$value = responseCode;
                this.responseCode$set = true;
                return this;
            }

            @Generated
            public EndpointBuilder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            @Generated
            public EndpointBuilder headers(Headers headers) {
                this.headers$value = headers;
                this.headers$set = true;
                return this;
            }

            @Generated
            public EndpointBuilder body(String body) {
                this.body = body;
                return this;
            }

            @Generated
            public EndpointBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public EndpointBuilder assertion(Consumer<HttpExchange> assertion) {
                if (this.assertions == null) {
                    this.assertions = new ArrayList();
                }
                this.assertions.add(assertion);
                return this;
            }

            @Generated
            public EndpointBuilder assertions(Collection<? extends Consumer<HttpExchange>> assertions) {
                if (assertions == null) {
                    throw new NullPointerException("assertions cannot be null");
                }
                if (this.assertions == null) {
                    this.assertions = new ArrayList();
                }
                this.assertions.addAll(assertions);
                return this;
            }

            @Generated
            public EndpointBuilder clearAssertions() {
                if (this.assertions != null) {
                    this.assertions.clear();
                }
                return this;
            }

            @Generated
            public EndpointBuilder counter(AtomicInteger counter) {
                this.counter$value = counter;
                this.counter$set = true;
                return this;
            }

            @Generated
            public Endpoint build() {
                List<Consumer<HttpExchange>> assertions = switch (this.assertions == null ? 0 : this.assertions.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.assertions.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<Consumer<HttpExchange>>(this.assertions));
                };
                int responseCode$value = this.responseCode$value;
                if (!this.responseCode$set) {
                    responseCode$value = Endpoint.$default$responseCode();
                }
                Headers headers$value = this.headers$value;
                if (!this.headers$set) {
                    headers$value = Endpoint.$default$headers();
                }
                AtomicInteger counter$value = this.counter$value;
                if (!this.counter$set) {
                    counter$value = Endpoint.$default$counter();
                }
                return new Endpoint(responseCode$value, this.contentType, headers$value, this.body, this.path, assertions, counter$value);
            }

            @Generated
            public String toString() {
                return "MockService.Endpoint.EndpointBuilder(responseCode$value=" + this.responseCode$value + ", contentType=" + this.contentType + ", headers$value=" + String.valueOf(this.headers$value) + ", body=" + this.body + ", path=" + this.path + ", assertions=" + String.valueOf(this.assertions) + ", counter$value=" + String.valueOf(this.counter$value) + ")";
            }
        }
    }

    public static enum Scope {
        TEST,
        CLASS;

    }

    public static class MockServiceBuilder {
        @Generated
        private int port;
        @Generated
        private HttpServer server;
        @Generated
        private List<Endpoint> endpointsConfig;
        @Generated
        private String serviceId;
        @Generated
        private String vipAddress;
        @Generated
        private boolean hostname$set;
        @Generated
        private String hostname$value;
        @Generated
        private String gatewayUrl;
        @Generated
        private String serviceUrl;
        @Generated
        private AuthenticationScheme authenticationScheme;
        @Generated
        private String applid;
        @Generated
        private boolean scope$set;
        @Generated
        private Scope scope$value;
        @Generated
        private ArrayList<Consumer<MockService>> statusChangedlisteners;
        private List<Endpoint> endpoints = new LinkedList<Endpoint>();
        AtomicInteger atCounter = new AtomicInteger(0);

        public Endpoint.EndpointBuilder addEndpoint(String path) {
            Endpoint.EndpointBuilder endpointBuilder = Endpoint.builder();
            endpointBuilder.path(path);
            endpointBuilder.mockServiceBuilder = this;
            return endpointBuilder;
        }

        public MockService build() {
            MockService mockService = this.internalBuild();
            mockService.port = idCounter++;
            mockService.endpointsConfig = this.endpoints;
            return mockService;
        }

        public MockService start() {
            MockService mockService;
            block2: {
                mockService = this.build();
                try {
                    mockService.start();
                }
                catch (IOException | RuntimeException e) {
                    int i = this.atCounter.getAndIncrement();
                    log.info("Not able to start mock server. Number of retries: {}", (Object)i);
                    if (i >= 4) break block2;
                    this.start();
                }
            }
            this.atCounter.set(0);
            return mockService;
        }

        @Generated
        MockServiceBuilder() {
        }

        @Generated
        public MockServiceBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public MockServiceBuilder server(HttpServer server) {
            this.server = server;
            return this;
        }

        @Generated
        public MockServiceBuilder endpointsConfig(List<Endpoint> endpointsConfig) {
            this.endpointsConfig = endpointsConfig;
            return this;
        }

        @Generated
        public MockServiceBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public MockServiceBuilder vipAddress(String vipAddress) {
            this.vipAddress = vipAddress;
            return this;
        }

        @Generated
        public MockServiceBuilder hostname(String hostname) {
            this.hostname$value = hostname;
            this.hostname$set = true;
            return this;
        }

        @Generated
        public MockServiceBuilder gatewayUrl(String gatewayUrl) {
            this.gatewayUrl = gatewayUrl;
            return this;
        }

        @Generated
        public MockServiceBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        @Generated
        public MockServiceBuilder authenticationScheme(AuthenticationScheme authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return this;
        }

        @Generated
        public MockServiceBuilder applid(String applid) {
            this.applid = applid;
            return this;
        }

        @Generated
        public MockServiceBuilder scope(Scope scope) {
            this.scope$value = scope;
            this.scope$set = true;
            return this;
        }

        @Generated
        public MockServiceBuilder statusChangedlistener(Consumer<MockService> statusChangedlistener) {
            if (this.statusChangedlisteners == null) {
                this.statusChangedlisteners = new ArrayList();
            }
            this.statusChangedlisteners.add(statusChangedlistener);
            return this;
        }

        @Generated
        public MockServiceBuilder statusChangedlisteners(Collection<? extends Consumer<MockService>> statusChangedlisteners) {
            if (statusChangedlisteners == null) {
                throw new NullPointerException("statusChangedlisteners cannot be null");
            }
            if (this.statusChangedlisteners == null) {
                this.statusChangedlisteners = new ArrayList();
            }
            this.statusChangedlisteners.addAll(statusChangedlisteners);
            return this;
        }

        @Generated
        public MockServiceBuilder clearStatusChangedlisteners() {
            if (this.statusChangedlisteners != null) {
                this.statusChangedlisteners.clear();
            }
            return this;
        }

        @Generated
        public MockService internalBuild() {
            List<Consumer<MockService>> statusChangedlisteners = switch (this.statusChangedlisteners == null ? 0 : this.statusChangedlisteners.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.statusChangedlisteners.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Consumer<MockService>>(this.statusChangedlisteners));
            };
            String hostname$value = this.hostname$value;
            if (!this.hostname$set) {
                hostname$value = MockService.$default$hostname();
            }
            Scope scope$value = this.scope$value;
            if (!this.scope$set) {
                scope$value = MockService.$default$scope();
            }
            return new MockService(this.port, this.server, this.endpointsConfig, this.serviceId, this.vipAddress, hostname$value, this.gatewayUrl, this.serviceUrl, this.authenticationScheme, this.applid, scope$value, statusChangedlisteners);
        }

        @Generated
        public String toString() {
            return "MockService.MockServiceBuilder(port=" + this.port + ", server=" + String.valueOf(this.server) + ", endpointsConfig=" + String.valueOf(this.endpointsConfig) + ", serviceId=" + this.serviceId + ", vipAddress=" + this.vipAddress + ", hostname$value=" + this.hostname$value + ", gatewayUrl=" + this.gatewayUrl + ", serviceUrl=" + this.serviceUrl + ", authenticationScheme=" + String.valueOf(this.authenticationScheme) + ", applid=" + this.applid + ", scope$value=" + String.valueOf((Object)this.scope$value) + ", statusChangedlisteners=" + String.valueOf(this.statusChangedlisteners) + ")";
        }
    }
}

