/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.registry.AbstractInstanceRegistry;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.EurekaServerHttpClientFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.netflix.eureka.server.InstanceRegistry;
import org.springframework.cloud.netflix.eureka.server.InstanceRegistryProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.zowe.apiml.discovery.EurekaStatusUpdateEvent;
import org.zowe.apiml.discovery.config.EurekaConfig;

public class ApimlInstanceRegistry
extends InstanceRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApimlInstanceRegistry.class);
    private static final String EXCEPTION_MESSAGE = "Implementation of InstanceRegistry changed, please verify fix of order sending events";
    private MethodHandle handleRegistrationMethod;
    private MethodHandle handlerResolveInstanceLeaseDurationMethod;
    private MethodHandle handleCancellationMethod;
    private MethodHandle register2ArgsMethodHandle;
    private MethodHandle register3ArgsMethodHandle;
    private MethodHandle cancelMethodHandle;
    private final ApplicationContext appCntx;
    private final EurekaConfig.Tuple tuple;

    public ApimlInstanceRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaClient eurekaClient, EurekaServerHttpClientFactory eurekaServerHttpClientFactory, InstanceRegistryProperties instanceRegistryProperties, ApplicationContext appCntx, EurekaConfig.Tuple tuple) {
        super(serverConfig, clientConfig, serverCodecs, eurekaClient, eurekaServerHttpClientFactory, instanceRegistryProperties.getExpectedNumberOfClientsSendingRenews(), instanceRegistryProperties.getDefaultOpenForTrafficCount());
        this.appCntx = appCntx;
        this.tuple = tuple;
        this.init();
    }

    private void init() {
        try {
            Method registrationMethod = InstanceRegistry.class.getDeclaredMethod("handleRegistration", InstanceInfo.class, Integer.TYPE, Boolean.TYPE);
            registrationMethod.setAccessible(true);
            this.handleRegistrationMethod = MethodHandles.lookup().unreflect(registrationMethod);
            Method cancelationMethod = InstanceRegistry.class.getDeclaredMethod("handleCancelation", String.class, String.class, Boolean.TYPE);
            cancelationMethod.setAccessible(true);
            this.handleCancellationMethod = MethodHandles.lookup().unreflect(cancelationMethod);
            Method resolveInstanceLeaseDurationMethod = InstanceRegistry.class.getDeclaredMethod("resolveInstanceLeaseDuration", InstanceInfo.class);
            resolveInstanceLeaseDurationMethod.setAccessible(true);
            this.handlerResolveInstanceLeaseDurationMethod = MethodHandles.lookup().unreflect(resolveInstanceLeaseDurationMethod);
            Constructor lookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            lookupConstructor.setAccessible(true);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)lookupConstructor.newInstance(PeerAwareInstanceRegistryImpl.class);
            this.register2ArgsMethodHandle = lookup.findSpecial(PeerAwareInstanceRegistryImpl.class, "register", MethodType.methodType(Void.TYPE, InstanceInfo.class, Boolean.TYPE), PeerAwareInstanceRegistryImpl.class);
            this.cancelMethodHandle = lookup.findSpecial(PeerAwareInstanceRegistryImpl.class, "cancel", MethodType.methodType(Boolean.TYPE, String.class, String.class, Boolean.TYPE), PeerAwareInstanceRegistryImpl.class);
            lookup = (MethodHandles.Lookup)lookupConstructor.newInstance(AbstractInstanceRegistry.class);
            this.register3ArgsMethodHandle = lookup.findSpecial(AbstractInstanceRegistry.class, "register", MethodType.methodType(Void.TYPE, InstanceInfo.class, Integer.TYPE, Boolean.TYPE), AbstractInstanceRegistry.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, e);
        }
    }

    protected int resolveInstanceLeaseDurationRewritten(InstanceInfo info) {
        try {
            return (Integer)this.handlerResolveInstanceLeaseDurationMethod.invokeWithArguments(new Object[]{this, info});
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, e);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, t);
        }
    }

    public void register(InstanceInfo info, int leaseDuration, boolean isReplication) {
        info = this.changeServiceId(info);
        try {
            this.register3ArgsMethodHandle.invokeWithArguments(new Object[]{this, info, leaseDuration, isReplication});
            this.handleRegistrationMethod.invokeWithArguments(new Object[]{this, info, leaseDuration, isReplication});
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, e);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, t);
        }
    }

    public void register(InstanceInfo info, boolean isReplication) {
        info = this.changeServiceId(info);
        try {
            this.register2ArgsMethodHandle.invokeWithArguments(new Object[]{this, info, isReplication});
            this.handleRegistrationMethod.invokeWithArguments(new Object[]{this, info, this.resolveInstanceLeaseDurationRewritten(info), isReplication});
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, e);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, t);
        }
    }

    public boolean cancel(String appName, String serverId, boolean isReplication) {
        try {
            String[] updatedValues = this.replaceValues(appName, serverId);
            boolean out = (Boolean)this.cancelMethodHandle.invokeWithArguments(new Object[]{this, updatedValues[0], updatedValues[1], isReplication});
            this.handleCancellationMethod.invokeWithArguments(new Object[]{this, updatedValues[0], updatedValues[1], isReplication});
            return out;
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, e);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, t);
        }
    }

    public boolean renew(String appName, String serverId, boolean isReplication) {
        String[] updatedValues = this.replaceValues(appName, serverId);
        return super.renew(updatedValues[0], updatedValues[1], isReplication);
    }

    public boolean statusUpdate(String appName, String instanceId, InstanceInfo.InstanceStatus newStatus, String lastDirtyTimestamp, boolean isReplication) {
        String[] updatedValues = this.replaceValues(appName, instanceId);
        boolean isUpdated = super.statusUpdate(updatedValues[0], updatedValues[1], newStatus, lastDirtyTimestamp, isReplication);
        this.appCntx.publishEvent((ApplicationEvent)new EurekaStatusUpdateEvent((Object)this, appName, instanceId));
        return isUpdated;
    }

    private String[] replaceValues(String appName, String instanceId) {
        if (this.tuple.isValid()) {
            String appNameRegex = "(?i)^" + this.tuple.getOldPrefix();
            String instanceIdRegex = "(?i):" + this.tuple.getOldPrefix();
            String targetValue = this.tuple.getNewPrefix();
            if (targetValue.contains("*")) {
                targetValue = targetValue.replace("*", "");
            }
            appName = appName.replaceAll(appNameRegex, targetValue).toUpperCase();
            instanceId = instanceId.contains(":") ? instanceId.replaceAll(instanceIdRegex, ":" + targetValue) : instanceId.replaceAll(appNameRegex, targetValue);
        }
        return new String[]{appName, instanceId};
    }

    protected InstanceInfo changeServiceId(InstanceInfo info) {
        if (this.tuple.isValid()) {
            Object servicePrefix = this.tuple.getOldPrefix();
            if (!((String)servicePrefix).contains("*")) {
                servicePrefix = (String)servicePrefix + "*";
            }
            String instanceId = info.getInstanceId();
            String appName = info.getAppName();
            Pattern p = Pattern.compile("(?i)^" + (String)servicePrefix);
            if (p.matcher(appName).find()) {
                String[] updatedValues = this.replaceValues(appName, instanceId);
                log.debug("The instance ID of {} service has been changed to {}.", (Object)info.getAppName(), (Object)updatedValues[1]);
                return new InstanceInfo.Builder(info).setInstanceId(updatedValues[1]).setAppGroupName(updatedValues[0]).setAppName(updatedValues[0]).setVIPAddress(updatedValues[0].toLowerCase()).build();
            }
            return info;
        }
        return info;
    }
}

