/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.zowe.apiml.cloudgatewayservice.service.model.ApimlInfo;
import org.zowe.apiml.cloudgatewayservice.service.model.CentralServiceInfo;
import org.zowe.apiml.config.ApiInfo;
import org.zowe.apiml.services.ServiceInfo;

@Component
public class CentralApimlInfoMapper {
    @Value(value="${apiml.cloudGateway.registry.metadata-key-allow-list:}")
    Set<String> metadataKeysAllowList = new HashSet<String>();

    public ApimlInfo buildApimlServiceInfo(@NonNull String apimlId, List<ServiceInfo> gatewayServices) {
        if (apimlId == null) {
            throw new NullPointerException("apimlId is marked non-null but is null");
        }
        List<CentralServiceInfo> services = Optional.ofNullable(gatewayServices).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(this::mapServices).collect(Collectors.toList());
        return ApimlInfo.builder().apimlId(apimlId).services(services).build();
    }

    private CentralServiceInfo mapServices(ServiceInfo gws) {
        return CentralServiceInfo.builder().serviceId(gws.getServiceId()).status(gws.getStatus()).apiId(this.extractApiId(gws.getApiml())).customMetadata(this.extractMetadata(gws)).build();
    }

    private Map<String, String> extractMetadata(ServiceInfo gws) {
        return Optional.ofNullable(gws.getInstances()).orElseGet(Collections::emptyMap).entrySet().stream().findFirst().map(Map.Entry::getValue).filter(i -> !CollectionUtils.isEmpty((Map)i.getCustomMetadata())).map(ServiceInfo.Instances::getCustomMetadata).orElse(Collections.emptyMap()).entrySet().stream().filter(entry -> this.metadataKeysAllowList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Set<String> extractApiId(ServiceInfo.Apiml apiml) {
        return Optional.ofNullable(apiml).map(ServiceInfo.Apiml::getApiInfo).orElse(Collections.emptyList()).stream().map(ApiInfo::getApiId).collect(Collectors.toSet());
    }
}

