/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service;

import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.zowe.apiml.auth.Authentication;
import org.zowe.apiml.auth.AuthenticationScheme;
import org.zowe.apiml.cloudgatewayservice.service.routing.RouteDefinitionProducer;
import org.zowe.apiml.cloudgatewayservice.service.scheme.SchemeHandler;
import org.zowe.apiml.eurekaservice.client.util.EurekaMetadataParser;
import org.zowe.apiml.product.routing.RoutedService;
import org.zowe.apiml.util.CorsUtils;
import org.zowe.apiml.util.StringUtils;
import reactor.core.publisher.Flux;

@Service
public class RouteLocator
implements RouteDefinitionLocator {
    private static final EurekaMetadataParser metadataParser = new EurekaMetadataParser();
    @Value(value="${apiml.service.forwardClientCertEnabled:false}")
    private boolean forwardingClientCertEnabled;
    private final ApplicationContext context;
    private final CorsUtils corsUtils;
    private final ReactiveDiscoveryClient discoveryClient;
    private final List<FilterDefinition> commonFilters;
    private final List<RouteDefinitionProducer> routeDefinitionProducers;
    private final Map<AuthenticationScheme, SchemeHandler> schemeHandlers = new EnumMap<AuthenticationScheme, SchemeHandler>(AuthenticationScheme.class);
    private final AtomicReference<Object> corsConfigurationSource = new AtomicReference();

    public RouteLocator(ApplicationContext context, CorsUtils corsUtils, ReactiveDiscoveryClient discoveryClient, List<FilterDefinition> commonFilters, List<SchemeHandler> schemeHandlersList, List<RouteDefinitionProducer> routeDefinitionProducers) {
        this.context = context;
        this.corsUtils = corsUtils;
        this.discoveryClient = discoveryClient;
        this.commonFilters = commonFilters;
        this.routeDefinitionProducers = routeDefinitionProducers;
        for (SchemeHandler schemeHandler : schemeHandlersList) {
            this.schemeHandlers.put(schemeHandler.getAuthenticationScheme(), schemeHandler);
        }
    }

    Flux<List<ServiceInstance>> getServiceInstances() {
        return this.discoveryClient.getServices().flatMap(service -> this.discoveryClient.getInstances(service).collectList());
    }

    void setAuth(ServiceInstance serviceInstance, RouteDefinition routeDefinition, Authentication auth) {
        SchemeHandler schemeHandler;
        if (auth != null && auth.getScheme() != null && (schemeHandler = this.schemeHandlers.get(auth.getScheme())) != null) {
            schemeHandler.apply(serviceInstance, routeDefinition, auth);
        }
    }

    void setCors(ServiceInstance serviceInstance) {
        this.corsUtils.setCorsConfiguration(serviceInstance.getServiceId().toLowerCase(), serviceInstance.getMetadata(), (prefix, serviceId, config) -> {
            serviceId = serviceInstance.getMetadata().getOrDefault("apiml.service.apimlId", serviceInstance.getServiceId().toLowerCase());
            this.getCorsConfigurationSource().registerCorsConfiguration("/" + serviceId + "/**", config);
        });
    }

    Stream<RoutedService> getRoutedService(ServiceInstance serviceInstance) {
        if (org.apache.commons.lang.StringUtils.equalsIgnoreCase((String)"GATEWAY", (String)serviceInstance.getServiceId())) {
            return Stream.of(new RoutedService("zuul", "", "/"));
        }
        return metadataParser.parseToListRoute(serviceInstance.getMetadata()).stream().sorted(Comparator.comparingInt(x -> StringUtils.removeFirstAndLastOccurrence((String)x.getGatewayUrl(), (String)"/").length()).reversed());
    }

    static <T> List<T> join(List<T> a, List<T> b) {
        if (b.isEmpty()) {
            return a;
        }
        LinkedList<T> output = new LinkedList<T>(a);
        output.addAll(b);
        return output;
    }

    List<FilterDefinition> getPostRoutingFilters(ServiceInstance serviceInstance) {
        LinkedList<FilterDefinition> serviceRelated = new LinkedList<FilterDefinition>();
        if (this.forwardingClientCertEnabled && Optional.ofNullable(serviceInstance.getMetadata().get("apiml.service.supportClientCertForwarding")).map(Boolean::parseBoolean).orElse(false).booleanValue()) {
            FilterDefinition clientCertFilter = new FilterDefinition();
            clientCertFilter.setName("ClientCertFilterFactory");
            serviceRelated.add(clientCertFilter);
        }
        return RouteLocator.join(this.commonFilters, serviceRelated);
    }

    private List<RouteDefinition> getAuthFilterPerRoute(AtomicInteger orderHolder, ServiceInstance serviceInstance, List<FilterDefinition> postRoutingFilters) {
        Authentication auth = metadataParser.parseAuthentication(serviceInstance.getMetadata());
        return this.getRoutedService(serviceInstance).map(routedService -> this.routeDefinitionProducers.stream().sorted(Comparator.comparingInt(x -> x.getOrder())).map(rdp -> {
            RouteDefinition routeDefinition = rdp.get(serviceInstance, (RoutedService)routedService);
            routeDefinition.setOrder(orderHolder.getAndIncrement());
            routeDefinition.getFilters().addAll(postRoutingFilters);
            this.setAuth(serviceInstance, routeDefinition, auth);
            return routeDefinition;
        }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Flux<RouteDefinition> getRouteDefinitions() {
        AtomicInteger order = new AtomicInteger();
        return this.getServiceInstances().flatMap(Flux::fromIterable).map(serviceInstance -> {
            this.setCors((ServiceInstance)serviceInstance);
            return this.getAuthFilterPerRoute(order, (ServiceInstance)serviceInstance, this.getPostRoutingFilters((ServiceInstance)serviceInstance));
        }).flatMapIterable(list -> list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    private UrlBasedCorsConfigurationSource getCorsConfigurationSource() {
        Object $value = this.corsConfigurationSource.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.corsConfigurationSource;
            synchronized (atomicReference) {
                $value = this.corsConfigurationSource.get();
                if ($value == null) {
                    UrlBasedCorsConfigurationSource actualValue = (UrlBasedCorsConfigurationSource)this.context.getBean(UrlBasedCorsConfigurationSource.class);
                    $value = actualValue == null ? this.corsConfigurationSource : actualValue;
                    this.corsConfigurationSource.set($value);
                }
            }
        }
        return (UrlBasedCorsConfigurationSource)($value == this.corsConfigurationSource ? null : $value);
    }
}

