/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import java.util.Enumeration;
import lombok.Generated;
import org.apache.catalina.connector.RequestFacade;
import org.apache.commons.lang3.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
public class RequestAttributesProvider
implements WebFilter,
GlobalFilter,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestAttributesProvider.class);

    private <R> R getRequest(ServerWebExchange exchange) {
        ServerHttpRequest delegatedRequest;
        ServerHttpRequest request = exchange.getRequest();
        while (request instanceof ServerHttpRequestDecorator && request != (delegatedRequest = ((ServerHttpRequestDecorator)request).getDelegate())) {
            request = delegatedRequest;
        }
        return (R)request;
    }

    private void copyAttributes(ServerWebExchange exchange) {
        RequestFacade requestFacade;
        AbstractServerHttpRequest request = (AbstractServerHttpRequest)this.getRequest(exchange);
        try {
            requestFacade = (RequestFacade)request.getNativeRequest();
        }
        catch (Exception e) {
            log.debug("The current request implementation does not support obtaining of request attributes. Is it running a test?");
            return;
        }
        Streams.of((Enumeration)requestFacade.getAttributeNames()).filter(name -> !exchange.getAttributes().containsKey(name)).forEach(name -> exchange.getAttributes().put(name, requestFacade.getAttribute(name)));
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        this.copyAttributes(exchange);
        return chain.filter(exchange);
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        this.copyAttributes(exchange);
        return chain.filter(exchange);
    }

    public int getOrder() {
        return -2147483647;
    }
}

