/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.config;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.security.KeyStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreakerFactory;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.gateway.config.GlobalCorsProperties;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.MutableDiscoveryClientOptionalArgs;
import org.springframework.cloud.util.ProxyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.pattern.PathPatternParser;
import org.zowe.apiml.cloudgatewayservice.config.AdditionalEurekaClientsHolder;
import org.zowe.apiml.cloudgatewayservice.config.EurekaFactory;
import org.zowe.apiml.cloudgatewayservice.config.NettyRoutingFilterApiml;
import org.zowe.apiml.cloudgatewayservice.filters.X509awareXForwardedHeadersFilter;
import org.zowe.apiml.config.AdditionalRegistration;
import org.zowe.apiml.config.AdditionalRegistrationCondition;
import org.zowe.apiml.config.AdditionalRegistrationParser;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.message.yaml.YamlMessageService;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;
import org.zowe.apiml.product.gateway.AdditionalRegistrationGatewayRegistry;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.HttpsConfigError;
import org.zowe.apiml.security.HttpsFactory;
import org.zowe.apiml.security.SecurityUtils;
import org.zowe.apiml.util.CorsUtils;
import reactor.netty.http.client.HttpClient;

@Configuration
public class ConnectionsConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionsConfig.class);
    private static final char[] KEYRING_PASSWORD = "password".toCharArray();
    @Value(value="${server.ssl.protocol:TLSv1.2}")
    private String protocol;
    @Value(value="${server.ssl.trustStore:#{null}}")
    private String trustStorePath;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    private char[] trustStorePassword;
    @Value(value="${server.ssl.trustStoreType:PKCS12}")
    private String trustStoreType;
    @Value(value="${server.ssl.keyAlias:#{null}}")
    private String keyAlias;
    @Value(value="${server.ssl.keyStore:#{null}}")
    private String keyStorePath;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    private char[] keyStorePassword;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    private char[] keyPassword;
    @Value(value="${server.ssl.keyStoreType:PKCS12}")
    private String keyStoreType;
    @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifySslCertificatesOfServices;
    @Value(value="${apiml.security.ssl.nonStrictVerifySslCertificatesOfServices:false}")
    private boolean nonStrictVerifySslCertificatesOfServices;
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${server.attls.enabled:false}")
    private boolean attlsEnabled;
    @Value(value="${server.ssl.trustStoreRequired:false}")
    private boolean trustStoreRequired;
    @Value(value="${eureka.client.serviceUrl.defaultZone}")
    private String eurekaServerUrl;
    @Value(value="${apiml.gateway.timeout:60}")
    private int requestTimeout;
    @Value(value="${apiml.service.corsEnabled:false}")
    private boolean corsEnabled;
    private final ApplicationContext context;
    private static final ApimlLogger apimlLog = ApimlLogger.of(ConnectionsConfig.class, (MessageService)YamlMessageServiceInstance.getInstance());

    public ConnectionsConfig(ApplicationContext context) {
        this.context = context;
    }

    @PostConstruct
    public void updateConfigParameters() {
        ServerProperties serverProperties = (ServerProperties)this.context.getBean(ServerProperties.class);
        if (SecurityUtils.isKeyring((String)this.keyStorePath)) {
            this.keyStorePath = SecurityUtils.formatKeyringUrl((String)this.keyStorePath);
            serverProperties.getSsl().setKeyStore(this.keyStorePath);
            if (this.keyStorePassword == null) {
                this.keyStorePassword = KEYRING_PASSWORD;
            }
        }
        if (SecurityUtils.isKeyring((String)this.trustStorePath)) {
            this.trustStorePath = SecurityUtils.formatKeyringUrl((String)this.trustStorePath);
            serverProperties.getSsl().setTrustStore(this.trustStorePath);
            if (this.trustStorePassword == null) {
                this.trustStorePassword = KEYRING_PASSWORD;
            }
        }
    }

    @Bean
    public HttpsConfig httpsConfig() {
        HttpsConfig config = HttpsConfig.builder().protocol(this.protocol).verifySslCertificatesOfServices(this.verifySslCertificatesOfServices).nonStrictVerifySslCertificatesOfServices(this.nonStrictVerifySslCertificatesOfServices).trustStorePassword(this.trustStorePassword).trustStoreRequired(this.trustStoreRequired).trustStore(this.trustStorePath).trustStoreType(this.trustStoreType).keyAlias(this.keyAlias).keyStore(this.keyStorePath).keyPassword(this.keyPassword).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).build();
        log.info("Using HTTPS configuration: {}", (Object)config.toString());
        return config;
    }

    public HttpsFactory factory() {
        return new HttpsFactory(this.httpsConfig());
    }

    @Bean
    public BeanPostProcessor routingFilterHandler(final HttpClient httpClient, final ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider, final HttpClientProperties properties) {
        final SslContext justTruststore = this.sslContext(false);
        final SslContext withKeystore = this.sslContext(true);
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if ("routingFilter".equals(beanName)) {
                    log.debug("Updating routing bean {}", NettyRoutingFilterApiml.class);
                    return new NettyRoutingFilterApiml(httpClient, (ObjectProvider<List<HttpHeadersFilter>>)headersFiltersProvider, properties, justTruststore, withKeystore);
                }
                return bean;
            }
        };
    }

    SslContext sslContext(boolean setKeystore) {
        try {
            SslContextBuilder builder = SslContextBuilder.forClient();
            KeyStore trustStore = SecurityUtils.loadKeyStore((String)this.trustStoreType, (String)this.trustStorePath, (char[])this.trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            builder.trustManager(trustManagerFactory);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (setKeystore) {
                KeyStore keyStore = SecurityUtils.loadKeyStore((String)this.keyStoreType, (String)this.keyStorePath, (char[])this.keyStorePassword);
                keyManagerFactory.init(keyStore, this.keyStorePassword);
                builder.keyManager(keyManagerFactory);
            } else {
                KeyStore emptyKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
                emptyKeystore.load(null, null);
                keyManagerFactory.init(emptyKeystore, null);
                builder.keyManager(keyManagerFactory);
            }
            return builder.build();
        }
        catch (Exception e) {
            apimlLog.log("org.zowe.apiml.common.sslContextInitializationError", new Object[]{e.getMessage()});
            throw new HttpsConfigError("Error initializing SSL Context: " + e.getMessage(), (Throwable)e, HttpsConfigError.ErrorCode.HTTP_CLIENT_INITIALIZATION_FAILED, this.factory().getConfig());
        }
    }

    @Bean(value={"primaryApimlEurekaJerseyClient"})
    EurekaJerseyClient getEurekaJerseyClient() {
        return this.factory().createEurekaJerseyClientBuilder(this.eurekaServerUrl, this.serviceId, this.attlsEnabled).build();
    }

    @Bean(destroyMethod="shutdown")
    @RefreshScope
    @ConditionalOnMissingBean(value={EurekaClient.class})
    public CloudEurekaClient primaryEurekaClient(ApplicationInfoManager manager, EurekaClientConfig config, @Qualifier(value="primaryApimlEurekaJerseyClient") EurekaJerseyClient eurekaJerseyClient, @Autowired(required=false) HealthCheckHandler healthCheckHandler) {
        ApplicationInfoManager appManager = AopUtils.isAopProxy((Object)manager) ? (ApplicationInfoManager)ProxyUtils.getTargetObject((Object)manager) : manager;
        MutableDiscoveryClientOptionalArgs args = new MutableDiscoveryClientOptionalArgs();
        args.setEurekaJerseyClient(eurekaJerseyClient);
        CloudEurekaClient cloudEurekaClient = new CloudEurekaClient(appManager, config, (AbstractDiscoveryClientOptionalArgs)args, (ApplicationEventPublisher)this.context);
        cloudEurekaClient.registerHealthCheck(healthCheckHandler);
        return cloudEurekaClient;
    }

    @Bean
    public List<AdditionalRegistration> additionalRegistration() {
        List additionalRegistrations = new AdditionalRegistrationParser().extractAdditionalRegistrations(System.getenv());
        log.debug("Parsed {} additional registration: {}", (Object)additionalRegistrations.size(), (Object)additionalRegistrations);
        return additionalRegistrations;
    }

    @Bean(destroyMethod="shutdown")
    @Conditional(value={AdditionalRegistrationCondition.class})
    @RefreshScope
    public AdditionalEurekaClientsHolder additionalEurekaClientsHolder(ApplicationInfoManager manager, EurekaClientConfig config, List<AdditionalRegistration> additionalRegistrations, EurekaFactory eurekaFactory, @Autowired(required=false) HealthCheckHandler healthCheckHandler, AdditionalRegistrationGatewayRegistry additionalRegistrationGatewayRegistry, Optional<X509awareXForwardedHeadersFilter> x509awareXForwardedHeadersFilter) {
        ArrayList<CloudEurekaClient> additionalClients = new ArrayList<CloudEurekaClient>(additionalRegistrations.size());
        for (AdditionalRegistration apimlRegistration : additionalRegistrations) {
            CloudEurekaClient cloudEurekaClient = this.registerInTheApimlInstance(config, apimlRegistration, manager, eurekaFactory);
            additionalClients.add(cloudEurekaClient);
            cloudEurekaClient.registerHealthCheck(healthCheckHandler);
            x509awareXForwardedHeadersFilter.ifPresent(__ -> additionalRegistrationGatewayRegistry.registerCacheRefreshEventListener((DiscoveryClient)cloudEurekaClient));
        }
        return new AdditionalEurekaClientsHolder(additionalClients);
    }

    private CloudEurekaClient registerInTheApimlInstance(EurekaClientConfig config, AdditionalRegistration apimlRegistration, ApplicationInfoManager appManager, EurekaFactory eurekaFactory) {
        log.debug("additional registration: {}", (Object)apimlRegistration.getDiscoveryServiceUrls());
        HashMap<String, String> urls = new HashMap<String, String>();
        urls.put("defaultZone", apimlRegistration.getDiscoveryServiceUrls());
        EurekaClientConfigBean configBean = new EurekaClientConfigBean();
        BeanUtils.copyProperties((Object)config, (Object)configBean);
        configBean.setServiceUrl(urls);
        EurekaJerseyClient jerseyClient = this.factory().createEurekaJerseyClientBuilder(this.eurekaServerUrl, this.serviceId, this.attlsEnabled).build();
        MutableDiscoveryClientOptionalArgs args = new MutableDiscoveryClientOptionalArgs();
        args.setEurekaJerseyClient(jerseyClient);
        EurekaInstanceConfig eurekaInstanceConfig = appManager.getEurekaInstanceConfig();
        InstanceInfo newInfo = eurekaFactory.createInstanceInfo(eurekaInstanceConfig);
        return eurekaFactory.createCloudEurekaClient(eurekaInstanceConfig, newInfo, configBean, args, this.context);
    }

    @Bean
    public Customizer<ReactiveResilience4JCircuitBreakerFactory> defaultCustomizer() {
        return factory -> factory.configureDefault(id -> new Resilience4JConfigBuilder(id).circuitBreakerConfig(CircuitBreakerConfig.ofDefaults()).timeLimiterConfig(TimeLimiterConfig.custom().timeoutDuration(Duration.ofSeconds(this.requestTimeout)).build()).build());
    }

    @Bean
    @Primary
    public WebClient webClient(HttpClient httpClient) {
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }

    @Bean
    public WebClient webClientClientCert(HttpClient httpClient) {
        httpClient = httpClient.secure(sslContextSpec -> sslContextSpec.sslContext(this.sslContext(true)));
        return this.webClient(httpClient);
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource(RoutePredicateHandlerMapping handlerMapping, GlobalCorsProperties globalCorsProperties, CorsUtils corsUtils) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource(new PathPatternParser());
        source.setCorsConfigurations(globalCorsProperties.getCorsConfigurations());
        corsUtils.registerDefaultCorsConfiguration((arg_0, arg_1) -> ((UrlBasedCorsConfigurationSource)source).registerCorsConfiguration(arg_0, arg_1));
        handlerMapping.setCorsConfigurationSource((CorsConfigurationSource)source);
        return source;
    }

    @Bean
    public CorsUtils corsUtils() {
        return new CorsUtils(this.corsEnabled, null);
    }

    @Bean
    public MessageService messageService() {
        YamlMessageService messageService = YamlMessageServiceInstance.getInstance();
        messageService.loadMessages("/cloud-gateway-log-messages.yml");
        return messageService;
    }
}

