/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.infinispan.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.zowe.apiml.cache.Storage;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.infinispan.exception.InfinispanConfigException;
import org.zowe.apiml.caching.service.infinispan.storage.InfinispanStorage;
import org.zowe.apiml.security.SecurityUtils;

@Configuration
@ConfigurationProperties(value="caching.storage.infinispan")
@ConditionalOnProperty(name={"caching.storage.mode"}, havingValue="infinispan")
public class InfinispanConfig
implements InitializingBean {
    private static final String SERVER_SSL_KEY_STORE_PASSWORD = "server.ssl.keyStorePassword";
    private static final String SERVER_SSL_KEY_STORE = "server.ssl.keyStore";
    private static final String SERVER_SSL_KEY_STORE_TYPE = "server.ssl.keyStoreType";
    private static final String KEYRING_PASSWORD = "password";
    @Value(value="${caching.storage.infinispan.initialHosts}")
    private String initialHosts;
    @Value(value="${server.ssl.keyStoreType}")
    private String keyStoreType;
    @Value(value="${server.ssl.keyStore}")
    private String keyStore;
    @Value(value="${server.ssl.keyStorePassword}")
    private String keyStorePass;
    @Value(value="${jgroups.bind.port}")
    private String port;
    @Value(value="${jgroups.bind.address}")
    private String address;
    @Value(value="${jgroups.keyExchange.port:7601}")
    private String keyExchangePort;
    @Value(value="${jgroups.tcp.diag.enabled:false}")
    private String tcpDiagEnabled;
    @Value(value="${server.attlsServer.enabled:false}")
    private boolean isServerAttlsEnabled;

    void updateKeyring() {
        if (SecurityUtils.isKeyring((String)this.keyStore)) {
            this.keyStore = SecurityUtils.formatKeyringUrl((String)this.keyStore);
            if (StringUtils.isBlank((CharSequence)this.keyStorePass)) {
                this.keyStorePass = KEYRING_PASSWORD;
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.updateKeyring();
    }

    static String getRootFolder() {
        String workspaceFolder;
        String instanceId = System.getenv().get("ZWE_haInstance_id");
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            instanceId = "localhost";
        }
        if (StringUtils.isBlank((CharSequence)(workspaceFolder = System.getenv().get("ZWE_zowe_workspaceDirectory")))) {
            return Paths.get("caching-service", instanceId).toString();
        }
        return Paths.get(workspaceFolder, "caching-service", instanceId).toString();
    }

    @Bean(destroyMethod="stop")
    synchronized DefaultCacheManager cacheManager(ResourceLoader resourceLoader) {
        ConfigurationBuilderHolder holder;
        System.setProperty("jgroups.tcpping.initial_hosts", this.initialHosts);
        System.setProperty("jgroups.bind.port", this.port);
        System.setProperty("jgroups.bind.address", this.address);
        System.setProperty("jgroups.keyExchange.port", this.keyExchangePort);
        System.setProperty("jgroups.tcp.diag.enabled", String.valueOf(Boolean.parseBoolean(this.tcpDiagEnabled)));
        Optional<String> oldKeyStoreType = Optional.ofNullable(System.getProperty(SERVER_SSL_KEY_STORE_TYPE));
        Optional<String> oldKeyStore = Optional.ofNullable(System.getProperty(SERVER_SSL_KEY_STORE));
        Optional<String> oldKeyStorePassword = Optional.ofNullable(System.getProperty(SERVER_SSL_KEY_STORE_PASSWORD));
        if (!this.isServerAttlsEnabled) {
            System.setProperty(SERVER_SSL_KEY_STORE_TYPE, this.keyStoreType);
            System.setProperty(SERVER_SSL_KEY_STORE, this.keyStore);
            System.setProperty(SERVER_SSL_KEY_STORE_PASSWORD, this.keyStorePass);
        }
        String infinispanConfigFile = this.isServerAttlsEnabled ? "infinispan-attls.xml" : "infinispan.xml";
        try (InputStream configurationStream = resourceLoader.getResource("classpath:" + infinispanConfigFile).getInputStream();){
            holder = new ParserRegistry().parse(configurationStream, MediaType.APPLICATION_XML);
        }
        catch (IOException e) {
            throw new InfinispanConfigException("Can't read configuration file", e);
        }
        holder.getGlobalConfigurationBuilder().globalState().persistentLocation(InfinispanConfig.getRootFolder()).enable();
        holder.newConfigurationBuilder("default").persistence().passivation(true).addSoftIndexFileStore().shared(false);
        DefaultCacheManager cacheManager = new DefaultCacheManager(holder, true);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).encoding().mediaType("application/x-jboss-marshalling");
        builder.persistence().passivation(true).addSoftIndexFileStore().shared(false);
        List<String> caches = Arrays.asList("zoweCache", "zoweInvalidatedTokenCache", "zosmfAuthenticationEndpoint", "invalidatedJwtTokens", "validationJwtToken", "zosmfInfo", "zosmfJwtEndpoint", "trustedCertificates", "parseOIDCToken", "validationOIDCToken");
        caches.forEach(cacheName -> ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache(cacheName, builder.build()));
        oldKeyStoreType.ifPresent(kst -> System.setProperty(SERVER_SSL_KEY_STORE_TYPE, kst));
        oldKeyStore.ifPresent(ks -> System.setProperty(SERVER_SSL_KEY_STORE, ks));
        oldKeyStorePassword.ifPresent(p -> System.setProperty(SERVER_SSL_KEY_STORE_PASSWORD, p));
        return cacheManager;
    }

    @Bean
    ClusteredLock lock(DefaultCacheManager cacheManager) {
        ClusteredLockManager clm = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)cacheManager);
        clm.defineLock("zoweInvalidatedTokenLock");
        return clm.get("zoweInvalidatedTokenLock");
    }

    @Bean
    Storage storage(DefaultCacheManager cacheManager, ClusteredLock clusteredLock) {
        return new InfinispanStorage((ConcurrentMap<String, KeyValue>)cacheManager.getCache("zoweCache"), (ConcurrentMap<String, Map<String, String>>)cacheManager.getCache("zoweInvalidatedTokenCache"), clusteredLock);
    }
}

