/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.config;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.models.OpenAPI;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(name={"modulithConfig"})
@OpenAPIDefinition(security={@SecurityRequirement(name="ClientCert")}, info=@Info(title="Caching service", description="REST API for the Caching service, which is a module of the API Mediation Layer.\nUse this API to perform tasks such as store, read and update items under the client certificate as a key.\n"))
@SecurityScheme(type=SecuritySchemeType.MUTUALTLS, name="ClientCert", description="Client certificate X509")
public class SwaggerConfig {
    @Value(value="${apiml.service.title}")
    private String apiTitle;
    @Value(value="${apiml.service.apiInfo[0].version}")
    private String apiVersion;
    @Value(value="${apiml.service.description}")
    private String apiDescription;

    @Bean
    public OpenAPI openAPI() {
        return new OpenAPI().info(new io.swagger.v3.oas.models.info.Info().title(this.apiTitle).description(this.apiDescription).version(this.apiVersion));
    }
}

