/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.config;

import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.HttpStatusServerEntryPoint;
import org.springframework.security.web.server.util.matcher.AndServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.zowe.apiml.security.common.util.X509Util;
import reactor.core.publisher.Mono;

@Configuration
@EnableWebFluxSecurity
public class SpringSecurityConfig {
    @Value(value="${apiml.service.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifyCertificates;
    @Value(value="${apiml.service.ssl.nonStrictVerifySslCertificatesOfServices:false}")
    private boolean nonStrictVerifyCerts;
    @Value(value="${apiml.health.protected:true}")
    private boolean isHealthEndpointProtected;

    @Bean
    @Order(value=1)
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        ArrayList<String> antMatchersToIgnore = new ArrayList<String>();
        antMatchersToIgnore.add("/cachingservice/application/info");
        antMatchersToIgnore.add("/cachingservice/v3/api-docs");
        if (!this.isHealthEndpointProtected) {
            antMatchersToIgnore.add("/cachingservice/application/health");
        }
        http.csrf(ServerHttpSecurity.CsrfSpec::disable).headers(headers -> headers.hsts(ServerHttpSecurity.HeaderSpec.HstsSpec::disable)).securityMatcher((ServerWebExchangeMatcher)new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{ServerWebExchangeMatchers.pathMatchers((String[])new String[]{"/cachingservice/**"})})).authorizeExchange(exchange -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)exchange.pathMatchers(antMatchersToIgnore.toArray(new String[0]))).permitAll().anyExchange().authenticated()).exceptionHandling(exceptionHandlingSpec -> exceptionHandlingSpec.authenticationEntryPoint((ServerAuthenticationEntryPoint)new HttpStatusServerEntryPoint(HttpStatus.FORBIDDEN)));
        if (this.verifyCertificates || !this.nonStrictVerifyCerts) {
            http.x509(x509spec -> x509spec.principalExtractor(X509Util.x509PrincipalExtractor()).authenticationManager(X509Util.x509ReactiveAuthenticationManager()));
        } else {
            http.authorizeExchange(exchange -> exchange.anyExchange().permitAll());
        }
        return http.build();
    }

    @Bean
    ReactiveUserDetailsService userDetailsService() {
        return username -> {
            ArrayList authorities = new ArrayList();
            UserDetails userDetails = User.withUsername((String)username).authorities(authorities).password("").build();
            return Mono.just((Object)userDetails);
        };
    }
}

