/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.api;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Messages;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.caching.service.StorageException;
import org.zowe.apiml.message.core.Message;
import org.zowe.apiml.message.core.MessageService;

@RestController
@RequestMapping(value={"/api/v1"})
public class CachingController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachingController.class);
    private final Storage storage;
    private final MessageService messageService;

    @GetMapping(value={"/cache"}, produces={"application/json"})
    @Operation(summary="Retrieves all values in the cache", description="Values returned for the calling service")
    @ResponseBody
    public ResponseEntity<Object> getAllValues(HttpServletRequest request) {
        return this.getServiceId(request).map(s -> {
            try {
                return new ResponseEntity(this.storage.readForService((String)s), (HttpStatusCode)HttpStatus.OK);
            }
            catch (Exception exception) {
                return this.handleInternalError(exception, request.getRequestURL());
            }
        }).orElseGet(this::getUnauthorizedResponse);
    }

    @DeleteMapping(value={"/cache"}, produces={"application/json"})
    @Operation(summary="Delete all values for service from the cache", description="Will delete all key-value pairs for specific service")
    @ResponseBody
    public ResponseEntity<Object> deleteAllValues(HttpServletRequest request) {
        return this.getServiceId(request).map(s -> {
            try {
                this.storage.deleteForService((String)s);
                return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
            }
            catch (Exception exception) {
                return this.handleInternalError(exception, request.getRequestURL());
            }
        }).orElseGet(this::getUnauthorizedResponse);
    }

    private ResponseEntity<Object> getUnauthorizedResponse() {
        Messages missingCert = Messages.MISSING_CERTIFICATE;
        Message message = this.messageService.createMessage(missingCert.getKey(), new Object[]{"parameter"});
        return new ResponseEntity((Object)message.mapToView(), (HttpStatusCode)missingCert.getStatus());
    }

    @GetMapping(value={"/cache/{key}"}, produces={"application/json"})
    @Operation(summary="Retrieves a specific value in the cache", description="Value returned is for the provided {key}")
    @ResponseBody
    public ResponseEntity<Object> getValue(@PathVariable String key, HttpServletRequest request) {
        return this.keyRequest(this.storage::read, key, request, HttpStatus.OK);
    }

    @DeleteMapping(value={"/cache/{key}"}, produces={"application/json"})
    @Operation(summary="Delete key from the cache", description="Will delete key-value pair for the provided {key}")
    @ResponseBody
    public ResponseEntity<Object> delete(@PathVariable String key, HttpServletRequest request) {
        return this.keyRequest(this.storage::delete, key, request, HttpStatus.NO_CONTENT);
    }

    @PostMapping(value={"/cache"}, produces={"application/json"})
    @Operation(summary="Create a new key in the cache", description="A new key-value pair will be added to the cache")
    @ResponseBody
    public ResponseEntity<Object> createKey(@RequestBody KeyValue keyValue, HttpServletRequest request) {
        return this.keyValueRequest(this.storage::create, keyValue, request, HttpStatus.CREATED);
    }

    @PostMapping(value={"/cache-list/{mapKey}"}, produces={"application/json"})
    @Operation(summary="Add a new item in the cache map", description="A new key-value pair will be added to the specific cache map with given map key.")
    @ResponseBody
    public ResponseEntity<Object> storeMapItem(@PathVariable String mapKey, @RequestBody KeyValue keyValue, HttpServletRequest request) {
        return this.mapKeyValueRequest(this.storage::storeMapItem, mapKey, keyValue, request, HttpStatus.CREATED);
    }

    @GetMapping(value={"/cache-list/{mapKey}"}, produces={"application/json"})
    @Operation(summary="Retrieves all the items in the cache map", description="Values returned for the calling service and specific cache map.")
    @ResponseBody
    public ResponseEntity<Object> getAllMapItems(@PathVariable String mapKey, HttpServletRequest request) {
        return this.getServiceId(request).map(s -> {
            log.debug("Storing for serviceId: {}", s);
            try {
                return new ResponseEntity(this.storage.getAllMapItems((String)s, mapKey), (HttpStatusCode)HttpStatus.OK);
            }
            catch (Exception exception) {
                return this.handleIncompatibleStorageMethod(exception, request.getRequestURL());
            }
        }).orElseGet(this::getUnauthorizedResponse);
    }

    @GetMapping(value={"/cache-list"}, produces={"application/json"})
    @Operation(summary="Retrieves all the maps in the cache", description="Values returned for the calling service")
    @ResponseBody
    public ResponseEntity<Object> getAllMaps(HttpServletRequest request) {
        return this.getServiceId(request).map(s -> {
            log.debug("Get all for serviceId: {}", s);
            try {
                return new ResponseEntity(this.storage.getAllMaps((String)s), (HttpStatusCode)HttpStatus.OK);
            }
            catch (Exception exception) {
                return this.handleIncompatibleStorageMethod(exception, request.getRequestURL());
            }
        }).orElseGet(this::getUnauthorizedResponse);
    }

    @DeleteMapping(value={"/cache-list/evict/rules/{mapKey}"}, produces={"application/json"})
    @Operation(summary="Delete a record from a rules map in the cache", description="Will delete a key-value pair from a specific rules map")
    @ResponseBody
    public ResponseEntity<Object> evictRules(@PathVariable String mapKey, HttpServletRequest request) {
        return this.getServiceId(request).map(s -> {
            log.debug("Delete record for serviceId: {}", s);
            try {
                this.storage.removeNonRelevantRules((String)s, mapKey);
                return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            catch (Exception exception) {
                return this.handleInternalError(exception, request.getRequestURL());
            }
        }).orElseGet(this::getUnauthorizedResponse);
    }

    @DeleteMapping(value={"/cache-list/evict/tokens/{mapKey}"}, produces={"application/json"})
    @Operation(summary="Delete a record from an invalid tokens map in the cache", description="Will delete a key-value pair from a specific tokens map")
    @ResponseBody
    public ResponseEntity<Object> evictTokens(@PathVariable String mapKey, HttpServletRequest request) {
        return this.getServiceId(request).map(s -> {
            log.debug("Evict tokens for serviceId: {}", s);
            try {
                this.storage.removeNonRelevantTokens((String)s, mapKey);
                return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            catch (Exception exception) {
                return this.handleInternalError(exception, request.getRequestURL());
            }
        }).orElseGet(this::getUnauthorizedResponse);
    }

    @PutMapping(value={"/cache"}, produces={"application/json"})
    @Operation(summary="Update key in the cache", description="Value at the key in the provided key-value pair will be updated to the provided value")
    @ResponseBody
    public ResponseEntity<Object> update(@RequestBody KeyValue keyValue, HttpServletRequest request) {
        return this.keyValueRequest(this.storage::update, keyValue, request, HttpStatus.NO_CONTENT);
    }

    private ResponseEntity<Object> exceptionToResponse(StorageException exception) {
        Message message = this.messageService.createMessage(exception.getKey(), (Object[])exception.getParameters());
        return new ResponseEntity((Object)message.mapToView(), (HttpStatusCode)exception.getStatus());
    }

    private ResponseEntity<Object> keyRequest(KeyOperation keyOperation, String key, HttpServletRequest request, HttpStatus successStatus) {
        Optional<String> serviceId = this.getServiceId(request);
        if (!serviceId.isPresent()) {
            return this.getUnauthorizedResponse();
        }
        try {
            if (key == null) {
                this.keyNotInCache();
            }
            KeyValue pair = keyOperation.storageRequest(serviceId.get(), key);
            return new ResponseEntity((Object)pair, (HttpStatusCode)successStatus);
        }
        catch (StorageException exception) {
            return this.exceptionToResponse(exception);
        }
        catch (Exception exception) {
            return this.handleInternalError(exception, request.getRequestURL());
        }
    }

    private ResponseEntity<Object> keyValueRequest(KeyValueOperation keyValueOperation, KeyValue keyValue, HttpServletRequest request, HttpStatus successStatus) {
        Optional<String> serviceId = this.getServiceId(request);
        if (!serviceId.isPresent()) {
            return this.getUnauthorizedResponse();
        }
        try {
            this.checkForInvalidPayload(keyValue);
            keyValueOperation.storageRequest(serviceId.get(), keyValue);
            return new ResponseEntity((HttpStatusCode)successStatus);
        }
        catch (StorageException exception) {
            return this.exceptionToResponse(exception);
        }
        catch (Exception exception) {
            return this.handleInternalError(exception, request.getRequestURL());
        }
    }

    private ResponseEntity<Object> mapKeyValueRequest(MapKeyValueOperation operation, String mapKey, KeyValue keyValue, HttpServletRequest request, HttpStatus successStatus) {
        Optional<String> serviceId = this.getServiceId(request);
        if (serviceId.isEmpty()) {
            return this.getUnauthorizedResponse();
        }
        try {
            log.debug("All map for serviceId: {}", (Object)serviceId.get());
            this.checkForInvalidPayload(keyValue);
            operation.storageRequest(serviceId.get(), mapKey, keyValue);
            return new ResponseEntity((HttpStatusCode)successStatus);
        }
        catch (StorageException exception) {
            return this.exceptionToResponse(exception);
        }
        catch (Exception exception) {
            return this.handleInternalError(exception, request.getRequestURL());
        }
    }

    private Optional<String> getServiceId(HttpServletRequest request) {
        Optional<String> certificateServiceId = this.getHeader(request, "X-Certificate-DistinguishedName");
        Optional<String> specificServiceId = this.getHeader(request, "X-CS-Service-ID");
        if (certificateServiceId.isPresent() && specificServiceId.isPresent()) {
            return Optional.of(certificateServiceId.get() + ", SERVICE=" + specificServiceId.get());
        }
        if (!specificServiceId.isPresent()) {
            return certificateServiceId;
        }
        return specificServiceId;
    }

    private Optional<String> getHeader(HttpServletRequest request, String headerName) {
        String serviceId = request.getHeader(headerName);
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            return Optional.empty();
        }
        return Optional.of(serviceId);
    }

    private ResponseEntity<Object> handleInternalError(Exception exception, StringBuffer requestURL) {
        Messages internalServerError = Messages.INTERNAL_SERVER_ERROR;
        Message message = this.messageService.createMessage(internalServerError.getKey(), new Object[]{requestURL, exception.getMessage(), exception.toString()});
        return new ResponseEntity((Object)message.mapToView(), (HttpStatusCode)internalServerError.getStatus());
    }

    private ResponseEntity<Object> handleIncompatibleStorageMethod(Exception exception, StringBuffer requestURL) {
        Messages internalServerError = Messages.INCOMPATIBLE_STORAGE_METHOD;
        Message message = this.messageService.createMessage(internalServerError.getKey(), new Object[]{requestURL, exception.getMessage(), exception.toString()});
        return new ResponseEntity((Object)message.mapToView(), (HttpStatusCode)internalServerError.getStatus());
    }

    private void keyNotInCache() {
        throw new StorageException(Messages.KEY_NOT_PROVIDED.getKey(), Messages.KEY_NOT_PROVIDED.getStatus(), new String[0]);
    }

    private StorageException invalidPayloadException(String keyValue, String message) {
        return new StorageException(Messages.INVALID_PAYLOAD.getKey(), Messages.INVALID_PAYLOAD.getStatus(), keyValue, message);
    }

    private void checkForInvalidPayload(KeyValue keyValue) {
        if (keyValue == null) {
            throw this.invalidPayloadException(null, "No KeyValue provided in the payload");
        }
        if (keyValue.getValue() == null) {
            throw this.invalidPayloadException(keyValue.toString(), "No value provided in the payload");
        }
        String key = keyValue.getKey();
        if (key == null) {
            throw this.invalidPayloadException(keyValue.toString(), "No key provided in the payload");
        }
    }

    @Generated
    public CachingController(Storage storage, MessageService messageService) {
        this.storage = storage;
        this.messageService = messageService;
    }

    @FunctionalInterface
    static interface KeyOperation {
        public KeyValue storageRequest(String var1, String var2);
    }

    @FunctionalInterface
    static interface KeyValueOperation {
        public KeyValue storageRequest(String var1, KeyValue var2) throws StorageException;
    }

    @FunctionalInterface
    static interface MapKeyValueOperation {
        public KeyValue storageRequest(String var1, String var2, KeyValue var3);
    }
}

